/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateEARProjectCommand;
import org.eclipse.jst.ws.internal.consumption.plugin.WebServiceConsumptionPlugin;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class CreateEJBProjectCommand
extends SimpleCommand {
    private static String LABEL = "%TASK_LABEL_CREATE_EJB_PROJECT";
    private static String DESCRIPTION = "%TASK_DESC_CREATE_EJB_PROJECT";
    private boolean isEJBProjectRequired_ = true;
    private String ejbProjectName_ = null;
    private String earProjectName_ = null;
    private IProject serviceProject;
    private IServer serviceExistingServer;
    private String serverFactoryId_;
    private String j2eeVersion_;

    public CreateEJBProjectCommand() {
        super(LABEL, DESCRIPTION);
    }

    public CreateEJBProjectCommand(String label, String desc) {
        super(label, desc);
    }

    public Status execute(Environment env) {
        try {
            if (this.ejbProjectName_ != null && this.ejbProjectName_.length() > 0 && this.earProjectName_ != null && this.earProjectName_.length() > 0) {
                Status status = this.createEJBProject(this.ejbProjectName_, this.earProjectName_, env);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                }
                return status;
            }
            if (!this.isEJBProjectRequired_) {
                return new SimpleStatus("");
            }
            if (this.ejbProjectName_ == null) {
                return new SimpleStatus("");
            }
            IProject container = J2EEPlugin.getWorkspace().getRoot().getProject(this.ejbProjectName_);
            if (container.exists()) {
                return new SimpleStatus("");
            }
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new EjbComponentCreationDataModelProvider());
            projectInfo.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)this.ejbProjectName_);
            projectInfo.setProperty("IEjbComponentCreationDataModelProperties.CREATE_DEFAULT_SESSION_BEAN", (Object)Boolean.TRUE);
            Status status = this.earProjectName_ != null ? this.addEARToProject(this.earProjectName_, projectInfo) : this.addEARToProject(this.serviceProject, projectInfo, env);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
            return status;
        }
        catch (Exception exception) {
            return new SimpleStatus("");
        }
    }

    private Status addEARToProject(String earProjectName, IDataModel projectInfo) {
        IProject earProject = null;
        EARNatureRuntime ear = null;
        if (this.j2eeVersion_ != null && this.j2eeVersion_.length() > 0) {
            ear = J2EEUtils.getEAR((int)Integer.parseInt(this.j2eeVersion_));
        } else {
            ear = J2EEUtils.get13EAR();
            if (ear != null) {
                earProject = ear.getProject();
            } else {
                ear = J2EEUtils.get12EAR();
                if (ear != null) {
                    earProject = ear.getProject();
                }
            }
        }
        projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProject.getName());
        projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.TRUE);
        if (this.j2eeVersion_ != null && this.j2eeVersion_.length() > 0) {
            projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(this.j2eeVersion_));
        } else if (earProject != null && earProject.exists()) {
            ear = EARNatureRuntime.getRuntime((IProject)earProject);
            int earVersion = ear.getJ2EEVersion();
            projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(earVersion));
            String.valueOf(earVersion);
        } else {
            projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(13));
            String.valueOf(13);
        }
        if (this.serverFactoryId_ != null) {
            this.serverFactoryId_.length();
        }
        IDataModelOperation ejbProjectCreationOperation = projectInfo.getDefaultOperation();
        try {
            ejbProjectCreationOperation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            return new SimpleStatus("org.eclipse.jst.ws.consumption", WebServiceConsumptionPlugin.getMessage("%MSG_ERROR_CANNOT_CREATE_EJB_PROJECT"), 4, (Throwable)e);
        }
        return new SimpleStatus("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status addEARToProject(IProject serviceProject, IDataModel projectInfo, Environment env) {
        Status mmStatus;
        IServer discoveredEARsServer;
        boolean addDiscoveredEARToServer;
        boolean addServiceEARToServer;
        IProject earProject;
        block13: {
            EARNatureRuntime ear = null;
            earProject = null;
            addServiceEARToServer = false;
            addDiscoveredEARToServer = false;
            discoveredEARsServer = null;
            EARNatureRuntime[] ears = J2EEUtils.getEARProjects((IProject)serviceProject);
            try {
                IServer defaultServer;
                if (ears != null && ears.length >= 1) {
                    ear = ears[0];
                    earProject = ear.getProject();
                    if (this.serviceExistingServer != null) {
                        Status mmStatus2;
                        if (this.serviceExistingServer.getServerState() != 4) {
                            this.serviceExistingServer.synchronousStop(false);
                        }
                        if ((mmStatus2 = ServerUtils.getInstance().modifyModules(env, this.serviceExistingServer, ResourceUtils.getModule((IProject)earProject), false, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                            return mmStatus2;
                        }
                        addServiceEARToServer = true;
                    }
                    break block13;
                }
                ear = J2EEUtils.get12EAR();
                if (ear != null && (defaultServer = ServerUtils.getDefaultExistingServer((IProject)(earProject = ear.getProject()))) != null) {
                    if (defaultServer.getServerState() != 4) {
                        defaultServer.synchronousStop(false);
                    }
                    if ((mmStatus = ServerUtils.getInstance().modifyModules(env, defaultServer, ResourceUtils.getModule((IProject)earProject), false, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                        return mmStatus;
                    }
                    addDiscoveredEARToServer = true;
                    discoveredEARsServer = defaultServer;
                }
            }
            catch (Exception e) {
                return new SimpleStatus("org.eclipse.jst.ws.consumption", WebServiceConsumptionPlugin.getMessage("%MSG_ERROR_CANNOT_CREATE_EJB_PROJECT"), 4, (Throwable)e);
            }
        }
        projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProject.getName());
        projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.TRUE);
        IDataModelOperation ejbProjectCreationOperation = projectInfo.getDefaultOperation();
        try {
            ejbProjectCreationOperation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            return new SimpleStatus("org.eclipse.jst.ws.consumption", WebServiceConsumptionPlugin.getMessage("%MSG_ERROR_CANNOT_CREATE_EJB_PROJECT"), 4, (Throwable)e);
        }
        if (addServiceEARToServer && (mmStatus = ServerUtils.getInstance().modifyModules(env, this.serviceExistingServer, ResourceUtils.getModule((IProject)earProject), true, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
            return mmStatus;
        }
        if (addDiscoveredEARToServer && (mmStatus = ServerUtils.getInstance().modifyModules(env, discoveredEARsServer, ResourceUtils.getModule((IProject)earProject), true, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
            return mmStatus;
        }
        return new SimpleStatus("");
    }

    private Status createEJBProject(String ejbProjectName, String earProjectName, Environment env) {
        try {
            Status mmStatus;
            boolean earAddedToServer;
            IProject ejbProject;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject earProject = root.getProject(earProjectName);
            if (earProject != null && !earProject.exists()) {
                CreateEARProjectCommand c = new CreateEARProjectCommand();
                c.setEarProjectName(earProjectName);
                c.setServerFactoryId(this.serverFactoryId_);
                c.setJ2EEVersion(this.j2eeVersion_);
                c.execute(env);
                earProject = root.getProject(earProjectName);
            }
            if ((ejbProject = root.getProject(ejbProjectName)) != null && !ejbProject.exists()) {
                IDataModel info = DataModelFactory.createDataModel((IDataModelProvider)new EjbComponentCreationDataModelProvider());
                info.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)ejbProjectName);
                info.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProjectName);
                info.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.TRUE);
                info.setProperty("IEjbComponentCreationDataModelProperties.CREATE_DEFAULT_SESSION_BEAN", (Object)Boolean.TRUE);
                if (this.j2eeVersion_ != null && this.j2eeVersion_.length() > 0) {
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(this.j2eeVersion_));
                } else if (earProject != null && earProject.exists()) {
                    EARNatureRuntime ear = EARNatureRuntime.getRuntime((IProject)earProject);
                    int earVersion = ear.getJ2EEVersion();
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(earVersion));
                    String.valueOf(earVersion);
                } else {
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(13));
                    String.valueOf(13);
                }
                if (this.serverFactoryId_ != null) {
                    this.serverFactoryId_.length();
                }
                IDataModelOperation operation = info.getDefaultOperation();
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            if (this.serviceExistingServer != null && !(earAddedToServer = ServerUtil.containsModule((IServer)this.serviceExistingServer, (IModule)ResourceUtils.getModule((IProject)earProject), (IProgressMonitor)new NullProgressMonitor())) && (mmStatus = ServerUtils.getInstance().modifyModules(env, this.serviceExistingServer, ResourceUtils.getModule((IProject)earProject), true, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                return mmStatus;
            }
        }
        catch (ExecutionException ite) {
            return new SimpleStatus("org.eclipse.jst.ws.consumption", WebServiceConsumptionPlugin.getMessage("%MSG_ERROR_CANNOT_CREATE_EJB_PROJECT"), 4, (Throwable)ite);
        }
        return new SimpleStatus("");
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName_ = earProjectName;
    }

    public void setEjbProjectName(String ejbProjectName) {
        this.ejbProjectName_ = ejbProjectName;
    }

    public void setEJBProjectRequired(boolean isEJBProjectRequired) {
        this.isEJBProjectRequired_ = isEJBProjectRequired;
    }

    public void setEJBProjectName(String ejbProjectName) {
        this.ejbProjectName_ = ejbProjectName;
    }

    public void setServiceExistingServer(IServer serviceExistingServer) {
        this.serviceExistingServer = serviceExistingServer;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId_ = serverFactoryId;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
    }
}

