/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;

public class CreateMonitorCommand
extends SimpleCommand {
    private static final String WEB_SERVICES = "Web services";
    private Boolean monitorService;
    private String serviceServerInstanceId;
    private Integer monitoredPort;

    public CreateMonitorCommand() {
        super("org.eclipse.jst.ws.internal.consumption.command.common.CreateMonitorCommand", "org.eclipse.jst.ws.internal.consumption.command.common.CreateMonitorCommand");
    }

    public Status execute(Environment env) {
        IServer server;
        if (this.monitorService != null && this.monitorService.booleanValue() && (server = ServerCore.findServer((String)this.serviceServerInstanceId)) != null) {
            ServerPort[] ports = server.getServerPorts(null);
            ServerPort port = null;
            int it = 0;
            while (it < ports.length) {
                ServerPort p = ports[it];
                String protocol = p.getProtocol();
                if (protocol != null && protocol.trim().toLowerCase().equals("http")) {
                    port = p;
                    break;
                }
                ++it;
            }
            if (port != null) {
                ServerMonitorManager serverMonitorManager = ServerMonitorManager.getInstance();
                IMonitoredServerPort[] monitoredPorts = serverMonitorManager.getMonitoredPorts(server);
                int it2 = 0;
                while (it2 < monitoredPorts.length) {
                    IMonitoredServerPort imsPort = monitoredPorts[it2];
                    if (port.getPort() == imsPort.getServerPort().getPort() && this.hasContentWebServices(imsPort)) {
                        if (!imsPort.isStarted()) {
                            try {
                                serverMonitorManager.startMonitor(imsPort);
                            }
                            catch (CoreException ce) {
                                MessageUtils msgUtils = new MessageUtils("org.eclipse.jst.ws.consumption.plugin", (Object)this);
                                SimpleStatus error = new SimpleStatus("org.eclipse.jst.ws.consumption", msgUtils.getMessage("MSG_ERROR_UNABLE_TO_START_MONITOR", new Object[]{String.valueOf(port.getPort()), server.getName()}), 4, (Throwable)ce);
                                env.getStatusHandler().reportError((Status)error);
                                return error;
                            }
                        }
                        this.monitoredPort = new Integer(imsPort.getMonitorPort());
                        return new SimpleStatus("");
                    }
                    ++it2;
                }
                try {
                    IMonitoredServerPort imsPort = serverMonitorManager.createMonitor(server, port, -1, new String[]{WEB_SERVICES});
                    serverMonitorManager.startMonitor(imsPort);
                    this.monitoredPort = new Integer(imsPort.getMonitorPort());
                    return new SimpleStatus("");
                }
                catch (CoreException ce) {
                    MessageUtils msgUtils = new MessageUtils("org.eclipse.jst.ws.consumption.plugin", (Object)this);
                    SimpleStatus error = new SimpleStatus("org.eclipse.jst.ws.consumption", msgUtils.getMessage("MSG_ERROR_UNABLE_TO_START_MONITOR", new Object[]{String.valueOf(port.getPort()), server.getName()}), 4, (Throwable)ce);
                    env.getStatusHandler().reportError((Status)error);
                    return error;
                }
            }
            MessageUtils msgUtils = new MessageUtils("org.eclipse.jst.ws.consumption.plugin", (Object)this);
            SimpleStatus info = new SimpleStatus("org.eclipse.jst.ws.consumption", msgUtils.getMessage("MSG_INFO_MONITORING_NOT_SUPPORTED", new Object[]{server.getName()}), 1);
            env.getStatusHandler().reportInfo((Status)info);
            return info;
        }
        return new SimpleStatus("");
    }

    private boolean hasContentWebServices(IMonitoredServerPort imsPort) {
        String[] contents = imsPort.getContentTypes();
        int i = 0;
        while (i < contents.length) {
            if (WEB_SERVICES.equals(contents[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        this.serviceServerInstanceId = typeRuntimeServer.getServerInstanceId();
    }

    public void setServiceServerInstanceId(String serviceServerInstanceId) {
        this.serviceServerInstanceId = serviceServerInstanceId;
    }

    public Integer getMonitoredPort() {
        return this.monitoredPort;
    }

    public void setMonitorService(Boolean value) {
        this.monitorService = value;
    }
}

