/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerDeployableConfigurationCommand
extends SimpleCommand {
    private String LABEL = "ServerDeployableConfigurationCommand";
    private String DESCRIPTION = "Ensure Deployable is added to Server Configuration";
    private MessageUtils msgUtils_;
    private Boolean creationScenario_ = Boolean.TRUE;
    private TypeRuntimeServer clientIds_;
    private IProject serviceProject_;
    private IProject sampleProject_;
    private String serviceServerTypeID_;
    private String sampleServerTypeID_;
    private IServer serviceExistingServer_;
    private IServer sampleExistingServer_;
    private String serviceProjectURL_;
    private String sampleProjectURL_;
    private boolean addedProjectToServer_ = false;

    public ServerDeployableConfigurationCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
    }

    public ServerDeployableConfigurationCommand(boolean creationScenario) {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
        this.creationScenario_ = new Boolean(creationScenario);
    }

    public Status execute(Environment env) {
        System.out.println("ServerDeployableConfigurationCommand");
        SimpleStatus status = new SimpleStatus("");
        try {
            IServer server;
            IProject project;
            if (!this.creationScenario_.booleanValue()) {
                return status;
            }
            IProject iProject = project = this.creationScenario_ != false ? this.serviceProject_ : this.sampleProject_;
            if (project == null) {
                return status;
            }
            this.sampleServerTypeID_ = this.clientIds_.getServerId();
            String serverFactoryId = this.creationScenario_ != false ? this.serviceServerTypeID_ : this.sampleServerTypeID_;
            IServer iServer = server = this.creationScenario_ != false ? this.serviceExistingServer_ : this.sampleExistingServer_;
            if (server != null) {
                IServer[] servers = ServerUtil.getServersByModule((IModule)ResourceUtils.getModule((IProject)project), null);
                boolean foundServer = false;
                int i = 0;
                while (i < servers.length) {
                    if (servers[i].equals(server)) {
                        foundServer = true;
                    }
                    ++i;
                }
                if (!foundServer) {
                    Status mmStatus = ServerUtils.getInstance().modifyModules(env, server, ResourceUtils.getModule((IProject)project), true, EnvironmentUtils.getIProgressMonitor((Environment)env));
                    if (mmStatus.getSeverity() == 4) {
                        return mmStatus;
                    }
                    this.addedProjectToServer_ = true;
                }
            } else {
                Status mmStatus;
                server = this.creationScenario_ == false && this.serviceServerTypeID_ == this.sampleServerTypeID_ ? this.serviceExistingServer_ : ServerUtils.getInstance().createServer(env, ResourceUtils.getModule((IProject)project), serverFactoryId, EnvironmentUtils.getIProgressMonitor((Environment)env));
                if (server == null) {
                    status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_CREATE_SERVER"), 4);
                    env.getStatusHandler().reportError((Status)status);
                    return status;
                }
                IModule[] parentModules = server.getRootModules(ResourceUtils.getModule((IProject)project), null);
                if (parentModules != null && parentModules.length != 0 && !ServerUtil.containsModule((IServer)server, (IModule)ResourceUtils.getModule((IProject)project), null) && (mmStatus = ServerUtils.getInstance().modifyModules(env, server, ResourceUtils.getModule((IProject)project), true, EnvironmentUtils.getIProgressMonitor((Environment)env))).getSeverity() == 4) {
                    return mmStatus;
                }
            }
            String projectURL = ResourceUtils.getWebProjectURL((IProject)project, (String)serverFactoryId, (IServer)server);
            if (this.creationScenario_.booleanValue()) {
                this.serviceExistingServer_ = server;
                this.serviceProjectURL_ = projectURL;
                if (this.serviceServerTypeID_.equals(this.sampleServerTypeID_) && this.clientIds_.getServerInstanceId() == null) {
                    this.sampleExistingServer_ = this.serviceExistingServer_;
                }
            } else {
                this.sampleExistingServer_ = server;
                this.sampleProjectURL_ = projectURL;
            }
            return status;
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_BAD_SERVER_CONFIG"), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }

    public void setSampleProject(IProject sampleProject) {
        this.sampleProject_ = sampleProject;
    }

    public void setServiceServerTypeID(String serviceServerTypeID) {
        this.serviceServerTypeID_ = serviceServerTypeID;
    }

    public void setSampleServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID_ = sampleServerTypeID;
    }

    public void setServiceExistingServer(IServer serviceExistingServer) {
        this.serviceExistingServer_ = serviceExistingServer;
    }

    public IServer getServiceExistingServer() {
        return this.serviceExistingServer_;
    }

    public String getServiceExistingServerInstId() {
        String id = null;
        IServerWorkingCopy wc = null;
        if (this.serviceExistingServer_ != null) {
            wc = this.serviceExistingServer_.createWorkingCopy();
            id = wc != null ? wc.getId() : null;
        }
        return id;
    }

    public String getSampleExistingServerInstId() {
        String id = null;
        IServerWorkingCopy wc = null;
        if (this.sampleExistingServer_ != null) {
            wc = this.sampleExistingServer_.createWorkingCopy();
            id = wc != null ? wc.getId() : null;
        }
        return id;
    }

    public void setSampleExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer_ = sampleExistingServer;
    }

    public IServer getSampleExistingServer() {
        return this.sampleExistingServer_;
    }

    public String getServiceProjectURL() {
        return this.serviceProjectURL_;
    }

    public String getSampleProjectURL() {
        return this.sampleProjectURL_;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer clientId) {
        this.clientIds_ = clientId;
    }

    public boolean getAddedProjectToServer() {
        return this.addedProjectToServer_;
    }
}

