/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.sampleapp.command;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofBeanVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofBeanVisitor;
import org.eclipse.jst.ws.internal.consumption.command.common.JavaMofReflectionCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Choice;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.selection.BooleanSelection;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class JavaToModelCommand
extends SimpleCommand {
    private MessageUtils msgUtils;
    private IResource resource;
    private String clientProject;
    private BooleanSelection[] methods;
    private String proxyBean;
    private JavaClass javaClass;
    private Model model;
    private Element parentElement;
    private IProject project;
    public static String LABEL = "JavaToModelCommand";
    public static String DESCRIPTION = "this creates a model from a resource";

    public JavaToModelCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(DESCRIPTION);
        this.setName(LABEL);
    }

    private Status createJavaReflection(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        JavaMofReflectionCommand javaMofReflectionCommand = new JavaMofReflectionCommand();
        javaMofReflectionCommand.setClientProject(this.clientProject);
        javaMofReflectionCommand.setProxyBean(this.proxyBean);
        status = javaMofReflectionCommand.execute(env);
        this.javaClass = (JavaClass)javaMofReflectionCommand.getJavaClass();
        return status;
    }

    public Model getDataModel() {
        return this.model;
    }

    public Status buildModelFromMof(Environment env) throws CoreException {
        Choice OKChoice = new Choice('O', this.msgUtils.getMessage("LABEL_OK"), this.msgUtils.getMessage("DESCRIPTION_OK"));
        Choice CancelChoice = new Choice('C', this.msgUtils.getMessage("LABEL_CANCEL"), this.msgUtils.getMessage("DESCRIPTION_CANCEL"));
        SimpleStatus status = new SimpleStatus("");
        if (this.model == null && this.parentElement == null) {
            Choice result;
            JavaMofBeanVisitor beanVisitor = new JavaMofBeanVisitor();
            JavaMofBeanVisitorAction beanVisitorAction = new JavaMofBeanVisitorAction(this.clientProject, this.methods, env);
            status = beanVisitor.run(this.javaClass, beanVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = env.getStatusHandler().report((Status)status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_SAMPLE_CREATION_CANCELED"), 4);
            }
            this.model = beanVisitorAction.getModel();
        } else if (this.model == null && this.parentElement != null) {
            Choice result;
            JavaMofBeanVisitor beanVisitor = new JavaMofBeanVisitor();
            JavaMofBeanVisitorAction beanVisitorAction = new JavaMofBeanVisitorAction(this.parentElement, this.clientProject, env);
            status = beanVisitor.run(this.javaClass, beanVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = env.getStatusHandler().report((Status)status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_SAMPLE_CREATION_CANCELED"), 4);
            }
            this.model = beanVisitorAction.getModel();
        } else {
            Choice result;
            JavaMofBeanVisitor beanVisitor = new JavaMofBeanVisitor();
            JavaMofBeanVisitorAction beanVisitorAction = new JavaMofBeanVisitorAction(this.model, this.clientProject, env);
            status = beanVisitor.run(this.javaClass, beanVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = env.getStatusHandler().report((Status)status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_SAMPLE_CREATION_CANCELED"), 4);
            }
            this.model = beanVisitorAction.getModel();
        }
        return status;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        if (this.clientProject == null) {
            return status;
        }
        ProjectUtilities.getProject((String)this.clientProject);
        status = this.createJavaReflection(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        try {
            status = this.buildModelFromMof(env);
            return status;
        }
        catch (CoreException exc) {
            IStatus embeddedStatus = exc.getStatus();
            status = EnvironmentUtils.convertIStatusToStatus((IStatus)embeddedStatus);
            return status;
        }
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methods = methods;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setParentElement(Element parentElement) {
        this.parentElement = parentElement;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }
}

