/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.preferences.ui;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.javascript.ui.internal.common.JSCommonUIMessages;
import org.eclipse.wst.javascript.ui.internal.common.preferences.OverlayPreferenceStore;
import org.eclipse.wst.javascript.ui.internal.common.preferences.ui.TokenParser;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractColorPage;
import org.eclipse.wst.sse.ui.internal.preferences.ui.StyledTextColorPicker;

public class JavaScriptColorPage
extends AbstractColorPage {
    private OverlayPreferenceStore fOverlayStore;
    protected RegionParser fParser = new TokenParser();

    protected OverlayPreferenceStore.OverlayKey[] createOverlayKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        ArrayList styleList = new ArrayList();
        this.initStyleList(styleList);
        Iterator i = styleList.iterator();
        while (i.hasNext()) {
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, (String)i.next()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public String getSampleText() {
        return JSCommonUIMessages.sample_javascript_UI_;
    }

    protected void initContextSytleMap(Dictionary contextStyleMap) {
        contextStyleMap.put("DEFAULT", "DEFAULT");
        contextStyleMap.put("KEYWORD", "KEYWORD");
        contextStyleMap.put("LITERAL", "LITERAL");
        contextStyleMap.put("COMMENT", "COMMENT");
        contextStyleMap.put("UNFINISHED_COMMENT", "UNFINISHED_COMMENT");
    }

    protected void initDescriptions(Dictionary descriptions) {
        descriptions.put("DEFAULT", JSCommonUIMessages.Default_Code_UI_);
        descriptions.put("KEYWORD", JSCommonUIMessages.Keywords_UI_);
        descriptions.put("LITERAL", JSCommonUIMessages.Literal_Strings_UI_);
        descriptions.put("COMMENT", JSCommonUIMessages.Comments_UI_);
        descriptions.put("UNFINISHED_COMMENT", JSCommonUIMessages.Unfinished_Strings_and_Comments_UI_);
    }

    public void init(IWorkbench workbench) {
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayKeys());
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    protected void initStyleList(ArrayList list) {
        list.add("DEFAULT");
        list.add("KEYWORD");
        list.add("LITERAL");
        list.add("COMMENT");
        list.add("UNFINISHED_COMMENT");
    }

    protected void setupPicker(StyledTextColorPicker picker) {
        picker.setParser(this.fParser);
        Hashtable descriptions = new Hashtable();
        this.initDescriptions(descriptions);
        Hashtable contextStyleMap = new Hashtable();
        this.initContextSytleMap(contextStyleMap);
        ArrayList styleList = new ArrayList();
        this.initStyleList(styleList);
        picker.setContextStyleMap(contextStyleMap);
        picker.setDescriptions(descriptions);
        picker.setStyleList(styleList);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        WorkbenchHelp.setHelp((Control)c, (String)"org.eclipse.wst.javascript.ui.webx0042");
        return c;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.fPicker.refresh();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSEditorPlugin.getDefault().getPreferenceStore();
    }

    protected void createContentsForPicker(Composite parent) {
        this.fPicker = new StyledTextColorPicker(parent, 0);
        GridData data = new GridData(1808);
        this.fPicker.setLayoutData((Object)data);
        this.fPicker.setPreferenceStore((IPreferenceStore)this.fOverlayStore);
        this.setupPicker(this.fPicker);
        this.fPicker.setText(this.getSampleText());
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        this.savePreferences();
        return true;
    }

    protected void savePreferences() {
        JSEditorPlugin.getDefault().savePluginPreferences();
    }
}

