/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.editor;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.javascript.core.internal.contenttype.ContentTypeIdForJavaScript;
import org.eclipse.wst.javascript.ui.internal.common.JSSourceViewerConfiguration;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorSourceViewerConfiguration;
import org.eclipse.wst.javascript.ui.internal.editor.JSLineStyleListener;
import org.eclipse.wst.javascript.ui.internal.editor.JavaPairMatcher;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;
import org.eclipse.wst.javascript.ui.internal.views.contentoutline.JSContentOutlinePage;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorActionBuilder;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorDropTargetAdapter;
import org.eclipse.wst.sse.ui.internal.IExtendedContributor;
import org.eclipse.wst.sse.ui.internal.IPopupMenuContributor;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredResourceMarkerAnnotationModel;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;
import org.eclipse.wst.sse.ui.internal.debug.EditBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ManageBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointsTarget;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ConfigurationPointCalculator;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IExtendedStorageEditorInput;

public class JSEditor
extends TextEditor {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected static final IStatus STATUS_ERROR = new Status(4, "JSEditorPlugin.ID", 1, "ERROR", null);
    protected static final IStatus STATUS_OK = new Status(0, "JSEditorPlugin.ID", 0, "OK", null);
    protected JavaPairMatcher fBracketMatcher = new JavaPairMatcher(BRACKETS);
    private JSContentOutlinePage fContentOutlinePage = null;
    private IEditorPart fEditorPart = null;
    private JSLineStyleListener fLineStyleListener = null;
    String[] fShowInTargetIds = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private IShowInTargetList fShowInTargetListAdapter = new ShowInTargetLister();
    private ISourceEditingTextTools fSourceEditingTextTools = new SourceEditingTextTools();
    IDocumentProvider fStorageInputDocumentProvider = null;
    private static final String UNDERSCORE = "_";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected void addContextMenuActions(IMenuManager menu) {
    }

    protected void addExtendedContextMenuActions(IMenuManager menu) {
        IEditorActionBarContributor c = this.getEditorSite().getActionBarContributor();
        if (c instanceof IPopupMenuContributor) {
            ((IPopupMenuContributor)c).contributeToPopupMenu(menu);
        } else {
            ExtendedEditorActionBuilder builder = new ExtendedEditorActionBuilder();
            IExtendedContributor pmc = builder.readActionExtensions(this.getConfigurationPoints());
            if (pmc != null) {
                pmc.setActiveEditor((IEditorPart)this);
                pmc.contributeToPopupMenu(menu);
            }
        }
    }

    public void close(final boolean save) {
        if (this.getEditorPart() != null) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    JSEditor.this.getSite().getPage().closeEditor(JSEditor.this.getEditorPart(), save);
                }
            });
        } else {
            super.close(save);
        }
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(EditorPreferenceNames.MATCHING_BRACKETS, EditorPreferenceNames.MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(JavaScriptUIMessages.getResourceBundle(), "Editor_Cut_", (ITextEditor)this, 3, true);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        action = new TextOperationAction(JavaScriptUIMessages.getResourceBundle(), "Editor_Paste_", (ITextEditor)this, 5, true);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        action = new TextOperationAction(JavaScriptUIMessages.getResourceBundle(), "Editor_Delete_", (ITextEditor)this, 6, true);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.DELETE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction(ITextEditorActionConstants.DELETE, (IAction)action);
        try {
            ResourceBundle resourceBundle = JavaScriptUIMessages.getResourceBundle();
            TextOperationAction contentAssistAction = new TextOperationAction(resourceBundle, "ContentAssistProposal_", (ITextEditor)this, 13, true);
            IWorkbenchHelpSystem helpSystem = JSEditorPlugin.getDefault().getWorkbench().getHelpSystem();
            helpSystem.setHelp((IAction)contentAssistAction, "org.eclipse.wst.sse.ui.xmlm1010");
            contentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
            this.setAction("ContentAssistProposal", (IAction)contentAssistAction);
            ToggleBreakpointAction breakpointAction = new ToggleBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.toggle", (IAction)breakpointAction);
            breakpointAction = new ManageBreakpointAction((ITextEditor)this, this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.manage", (IAction)breakpointAction);
            breakpointAction = new EditBreakpointAction((ITextEditor)this, this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.edit", (IAction)breakpointAction);
            String ext = BreakpointRulerAction.getFileExtension((IEditorInput)this.getEditorInput());
            if (BreakpointProviderBuilder.getInstance().isAvailable(this.getInputContentType(this.getEditorInput()), ext)) {
                this.setAction("RulerDoubleClick", this.getAction("org.eclipse.wst.sse.ui.breakpoints.toggle"));
            } else {
                this.setAction("RulerDoubleClick", this.getAction(IDEActionFactory.BOOKMARK.getId()));
            }
        }
        catch (MissingResourceException exception) {
            throw new SourceEditingRuntimeException((Throwable)exception, JavaScriptUIMessages.An_error_has_occurred_when_ERROR_);
        }
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs});
    }

    protected String[] createShowInTargetIds() {
        ArrayList<String> allIds = new ArrayList<String>(0);
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] configurationIds = this.getConfigurationPoints();
        int i = 0;
        while (i < configurationIds.length) {
            String[] definitions = builder.getDefinitions("showintarget", configurationIds[i]);
            int j = 0;
            while (j < definitions.length) {
                String someIds = definitions[j];
                if (someIds != null && someIds.length() > 0) {
                    String[] ids = StringUtils.unpack((String)someIds);
                    int k = 0;
                    while (k < ids.length) {
                        String id = ids[k].trim();
                        if (!allIds.contains(id)) {
                            allIds.add(id);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!allIds.contains("org.eclipse.ui.views.ResourceNavigator")) {
            allIds.add("org.eclipse.ui.views.ResourceNavigator");
        }
        return allIds.toArray(new String[0]);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.initializeDrop((Control)this.getSourceViewer().getTextWidget());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer sourceViewer = new SourceViewer(parent, verticalRuler, this.fOverviewRuler, true, styles);
        JSLineStyleListener lineStyleListener = this.getLineStyleListener();
        if (lineStyleListener != null) {
            lineStyleListener.setSourceViewer((ISourceViewer)sourceViewer);
            StyledText textWidget = sourceViewer.getTextWidget();
            textWidget.addLineStyleListener((LineStyleListener)lineStyleListener);
        }
        this.setSourceViewerConfiguration();
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    public void dispose() {
        JSLineStyleListener lineStyleListener = this.getLineStyleListener();
        if (lineStyleListener != null) {
            lineStyleListener.dispose();
            lineStyleListener = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.handleConvertLineDelimiters();
        super.doSave(progressMonitor);
    }

    public void doSaveAs() {
        this.handleConvertLineDelimiters();
        super.doSaveAs();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        StyledText textWidget = null;
        if (this.getSourceViewer() != null) {
            textWidget = this.getSourceViewer().getTextWidget();
        }
        if (this.fLineStyleListener != null) {
            if (textWidget != null) {
                textWidget.removeLineStyleListener((LineStyleListener)this.fLineStyleListener);
            }
            this.fLineStyleListener.dispose();
            this.fLineStyleListener = null;
        }
        try {
            JSLineStyleListener lineStyleListener;
            super.doSetInput(input);
            String contentType = this.getInputContentType(input);
            this.setEditorContextMenuId(String.valueOf(contentType) + ".source.EditorContext");
            this.setRulerContextMenuId(String.valueOf(contentType) + ".source.RulerContext");
            this.setHelpContextId(String.valueOf(contentType) + ".source.HelpId");
            if (this.getHelpContextId() != null && this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
                IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
                helpSystem.setHelp((Control)this.getSourceViewer().getTextWidget(), this.getHelpContextId());
            }
            if ((lineStyleListener = this.getLineStyleListener()) != null && textWidget != null) {
                textWidget.addLineStyleListener((LineStyleListener)lineStyleListener);
            }
            if (this.fContentOutlinePage != null) {
                this.fContentOutlinePage.setDocument(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
            }
            this.fShowInTargetIds = this.createShowInTargetIds();
        }
        catch (CoreException exception) {
            this.dispose();
            throw new CoreException(exception.getStatus());
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addContextMenuActions(menu);
        this.addExtendedContextMenuActions(menu);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getContentOutlinePage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.fShowInTargetListAdapter;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            return ToggleBreakpointsTarget.getInstance();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(required)) {
            return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.equals(required)) {
            return this.fSourceEditingTextTools;
        }
        return super.getAdapter(required);
    }

    protected String[] getConfigurationPoints() {
        return ConfigurationPointCalculator.getConfigurationPoints((IEditorPart)this, (String)this.getInputContentType(this.getEditorInput()), (String)".source", ((Object)((Object)this)).getClass());
    }

    protected IContentOutlinePage getContentOutlinePage() {
        if (this.fContentOutlinePage == null || this.fContentOutlinePage.getControl().isDisposed()) {
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            this.fContentOutlinePage = new JSContentOutlinePage(document, this.getSourceViewer());
        }
        return this.fContentOutlinePage;
    }

    IEditorPart getEditorPart() {
        if (this.fEditorPart == null) {
            return this;
        }
        return this.fEditorPart;
    }

    String getInputContentType(Object element) {
        return ContentTypeIdForJavaScript.ContentTypeID_JAVASCRIPT;
    }

    protected JSLineStyleListener getLineStyleListener() {
        if (this.fLineStyleListener == null) {
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            this.fLineStyleListener = new JSLineStyleListener(document, this.getSourceViewer());
        }
        return this.fLineStyleListener;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (EditorPreferenceNames.EDITOR_TEXT_HOVER_MODIFIERS.equals(property)) {
            this.updateHoverBehavior();
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void initializeDrop(Control control) {
        int operations = 3;
        DropTarget dropTarget = new DropTarget(control, operations);
        ExtendedEditorDropTargetAdapter dropTargetAdapter = new ExtendedEditorDropTargetAdapter();
        dropTargetAdapter.setTargetEditor((IEditorPart)this);
        dropTargetAdapter.setTargetIDs(this.getConfigurationPoints());
        dropTargetAdapter.setTextViewer((ITextViewer)this.getSourceViewer());
        dropTarget.setTransfer(dropTargetAdapter.getTransfers());
        dropTarget.addDropListener((DropTargetListener)dropTargetAdapter);
    }

    protected void initializeEditor() {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setHelpContextId("org.eclipse.wst.javascript.ui.ejsc0000");
        this.setPreferenceStore(this.createCombinedPreferenceStore());
    }

    public boolean isEditable() {
        return true;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.toggle"));
        menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.manage"));
        menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.edit"));
        menu.add((IContributionItem)new Separator());
        super.rulerContextMenuAboutToShow(menu);
    }

    protected void sanityCheckState(IEditorInput input) {
        super.sanityCheckState(input);
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput)) {
            if (this.fStorageInputDocumentProvider == null) {
                this.fStorageInputDocumentProvider = new StorageInputDocumentProvider();
            }
            this.setDocumentProvider(this.fStorageInputDocumentProvider);
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.fEditorPart = editorPart;
    }

    protected void setSourceViewerConfiguration() {
        Object configuration = super.getSourceViewerConfiguration();
        if (configuration == null || !(configuration instanceof JSSourceViewerConfiguration)) {
            configuration = new JSEditorSourceViewerConfiguration(this.getPreferenceStore());
            this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
        }
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    protected void updateStatusField(String category) {
        IStatusField field;
        super.updateStatusField(category);
        if (category == null) {
            return;
        }
        if ("Offset".equals(category) && (field = this.getStatusField(category)) != null) {
            Point selection = this.getSourceViewer().getTextWidget().getSelection();
            int offset1 = JSEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)selection.x);
            int offset2 = JSEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)selection.y);
            String text = null;
            text = offset1 != offset2 ? "[" + offset1 + "-" + offset2 + "]" : "[ " + offset1 + " ]";
            field.setText(text == null ? this.fErrorLabel : text);
        }
    }

    private void handleConvertLineDelimiters() {
        if (this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getNumberOfLines() > 1) {
            try {
                this.convertLineDelimiters(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
            }
            catch (CoreException e) {
                throw new SourceEditingRuntimeException((Throwable)e);
            }
        }
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.updateStatusField("Offset");
    }

    private void convertLineDelimiters(IDocument document) throws CoreException {
        String contentTypeId = ContentTypeIdForJavaScript.ContentTypeID_JAVASCRIPT;
        String endOfLineCode = ContentBasedPreferenceGateway.getPreferencesString((String)contentTypeId, (String)"endOfLineCode");
        if (endOfLineCode != null && endOfLineCode.length() > 0) {
            String lineDelimiterToUse = System.getProperty("line.separator");
            if (endOfLineCode.equals("EOL_Mac")) {
                lineDelimiterToUse = "\r";
            } else if (endOfLineCode.equals("EOL_Unix")) {
                lineDelimiterToUse = "\n";
            } else if (endOfLineCode.equals("EOL_Windows")) {
                lineDelimiterToUse = "\r\n";
            }
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            int lineCount = document.getNumberOfLines();
            try {
                int i = 0;
                while (i < lineCount) {
                    String currentLineDelimiter;
                    IRegion lineInfo = document.getLineInformation(i);
                    int lineStartOffset = lineInfo.getOffset();
                    int lineLength = lineInfo.getLength();
                    int lineEndOffset = lineStartOffset + lineLength;
                    if (i < lineCount - 1 && (currentLineDelimiter = document.getLineDelimiter(i)) != null && currentLineDelimiter.compareTo(lineDelimiterToUse) != 0) {
                        multiTextEdit.addChild((TextEdit)new ReplaceEdit(lineEndOffset, currentLineDelimiter.length(), lineDelimiterToUse));
                    }
                    ++i;
                }
                if (multiTextEdit.getChildrenSize() > 0) {
                    multiTextEdit.apply(document);
                }
            }
            catch (BadLocationException exception) {
                throw new SourceEditingRuntimeException((Throwable)exception);
            }
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        ArrayList<String> allIds = new ArrayList<String>(0);
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] configurationIds = this.getConfigurationPoints();
        int i = 0;
        while (i < configurationIds.length) {
            String[] definitions = builder.getDefinitions("preferencepages", configurationIds[i]);
            int j = 0;
            while (j < definitions.length) {
                String someIds = definitions[j];
                if (someIds != null && someIds.length() > 0) {
                    String[] ids = StringUtils.unpack((String)someIds);
                    int k = 0;
                    while (k < ids.length) {
                        String id = ids[k].trim();
                        if (!allIds.contains(id)) {
                            allIds.add(id);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        String[] superPages = super.collectContextMenuPreferencePages();
        int m = 0;
        while (m < superPages.length) {
            String id = superPages[m].trim();
            if (!allIds.contains(id)) {
                allIds.add(id);
            }
            ++m;
        }
        return allIds.toArray(new String[0]);
    }

    public int getOrientation() {
        return 0x2000000;
    }

    private class ShowInTargetLister
    implements IShowInTargetList {
        ShowInTargetLister() {
        }

        public String[] getShowInTargetIds() {
            return JSEditor.this.fShowInTargetIds;
        }
    }

    private class SourceEditingTextTools
    implements ISourceEditingTextTools {
        SourceEditingTextTools() {
        }

        public int getCaretOffset() {
            return 0;
        }

        public IDocument getDocument() {
            return JSEditor.this.getDocumentProvider().getDocument((Object)JSEditor.this.getEditorInput());
        }

        public IEditorPart getEditorPart() {
            return JSEditor.this.getEditorPart();
        }

        public ITextSelection getSelection() {
            ITextSelection selection = null;
            ISelection s = JSEditor.this.getSelectionProvider().getSelection();
            selection = s instanceof ITextSelection ? (ITextSelection)s : TextSelection.emptySelection();
            return selection;
        }
    }

    class StorageInputDocumentProvider
    extends StorageDocumentProvider
    implements IElementStateListener {
        StorageInputDocumentProvider() {
        }

        protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
            StructuredResourceMarkerAnnotationModel model = null;
            IStorageEditorInput storageInput = (IStorageEditorInput)element;
            String contentType = JSEditor.this.getInputContentType(element);
            String ext = BreakpointRulerAction.getFileExtension((IEditorInput)storageInput);
            IResource res = BreakpointProviderBuilder.getInstance().getResource((IEditorInput)storageInput, contentType, ext);
            String id = storageInput.getName();
            if (storageInput.getStorage() != null) {
                id = storageInput.getStorage().getFullPath().toString();
            }
            model = res != null ? new StructuredResourceMarkerAnnotationModel(res, id) : new StructuredResourceMarkerAnnotationModel((IResource)ResourcesPlugin.getWorkspace().getRoot(), id);
            return model;
        }

        protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
            if (element instanceof IExtendedStorageEditorInput) {
                ((IExtendedStorageEditorInput)element).addElementStateListener((IElementStateListener)this);
            }
            return super.createElementInfo(element);
        }

        protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
            if (element instanceof IExtendedStorageEditorInput) {
                ((IExtendedStorageEditorInput)element).removeElementStateListener((IElementStateListener)this);
            }
            super.disposeElementInfo(element, info);
        }

        protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
            new FileDocumentProvider().saveDocument(monitor, element, document, overwrite);
        }

        public void elementContentAboutToBeReplaced(Object element) {
            this.fireElementContentAboutToBeReplaced(element);
        }

        public void elementContentReplaced(Object element) {
            this.fireElementContentReplaced(element);
        }

        public void elementDeleted(Object element) {
            this.fireElementDeleted(element);
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            this.fireElementDirtyStateChanged(element, isDirty);
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            this.fireElementMoved(originalElement, movedElement);
        }
    }
}

