/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.views.contentoutline;

import java.text.Collator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.javascript.ui.internal.common.ContentElement;
import org.eclipse.wst.javascript.ui.internal.common.ContentElementComparerImpl;
import org.eclipse.wst.javascript.ui.internal.common.JSContentElementImpl;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPluginImageHelper;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;
import org.eclipse.wst.javascript.ui.internal.editor.SimpleTreeViewer;
import org.eclipse.wst.javascript.ui.internal.editor.SimpleViewerSelectionManagerImpl;
import org.eclipse.wst.javascript.ui.internal.views.contentoutline.JSLabelProvider;
import org.eclipse.wst.javascript.ui.internal.views.contentoutline.JSTreeContentProvider;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.edit.util.SharedEditorPluginImageHelper;

public class JSContentOutlinePage
extends ContentOutlinePage
implements IDocumentListener {
    private static final String OUTLINE_LINK_PREF = "outline-link-editor";
    private static final String OUTLINE_SHOW_HIERARCHY_PREF = "outline-show-hierarchy";
    private static final String OUTLINE_SHOW_VARIABLES_PREF = "outline-show-variables";
    private static final String OUTLINE_SORT_PREF = "outline-sort";
    protected ImageDescriptor COLLAPSE_D = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/dlcl16/collapseall.gif");
    protected ImageDescriptor COLLAPSE_E = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/elcl16/collapseall.gif");
    protected ImageDescriptor DELETE_D = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/dlcl16/delete.gif");
    protected ImageDescriptor DELETE_E = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/elcl16/delete.gif");
    protected ImageDescriptor SYNCED_D = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/dlcl16/synced.gif");
    protected ImageDescriptor SYNCED_E = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/elcl16/synced.gif");
    protected DeleteAction fDeleteAction = new DeleteAction();
    protected IDocument fDocument = null;
    private PropertyChangeUpdateActionContributionItem fShowHierarchyItem;
    private PropertyChangeUpdateActionContributionItem fShowVariablesItem;
    private PropertyChangeUpdateActionContributionItem fSortItem;
    protected ISourceViewer fSourceViewer = null;
    private PropertyChangeUpdateActionContributionItem fToggleLinkItem;
    protected TreeViewer fTreeViewer = null;
    protected SimpleViewerSelectionManagerImpl fViewerSelectionManager = null;
    private boolean fContextMenuRegistered = false;
    private MenuManager fContextMenu = null;

    public JSContentOutlinePage(IDocument document, ISourceViewer sourceViewer) {
        this.setDocument(document);
        this.setSourceViewer(sourceViewer);
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.fDeleteAction);
        IContributionItem[] items = menuManager.getItems();
        if (items.length > 0 && items[items.length - 1].getId() != null) {
            menuManager.insertAfter(items[items.length - 1].getId(), (IContributionItem)new GroupMarker("additions"));
        } else {
            menuManager.add((IContributionItem)new GroupMarker("additions"));
        }
    }

    public void createControl(Composite parent) {
        this.createTreeViewer(parent);
        this.fTreeViewer.setContentProvider((IContentProvider)new JSTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new JSLabelProvider());
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.getViewerSelectionManager());
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this.getViewerSelectionManager());
        this.fTreeViewer.setInput((Object)this.fDocument);
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener((IDocumentListener)this);
        }
        this.fContextMenu = new MenuManager("#popup");
        this.fContextMenu.setRemoveAllWhenShown(true);
        this.fContextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                JSContentOutlinePage.this.contextMenuAboutToShow(menuManager);
            }
        });
        Menu menu = this.fContextMenu.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
        this.registerContextMenu();
    }

    protected void createTreeViewer(Composite parent) {
        this.fTreeViewer = new SimpleTreeViewer(new Tree(parent, 772));
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTreeViewer.setComparer((IElementComparer)new ContentElementComparerImpl());
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.setTreeViewer(this.fTreeViewer);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
        }
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.disconnectCaretListeners();
            if (this.fTreeViewer != null) {
                this.fTreeViewer.removeDoubleClickListener((IDoubleClickListener)this.fViewerSelectionManager);
                this.fTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.fViewerSelectionManager);
            }
        }
        if (this.fShowHierarchyItem != null) {
            this.fShowHierarchyItem.disconnect();
        }
        if (this.fSortItem != null) {
            this.fSortItem.disconnect();
        }
        if (this.fShowVariablesItem != null) {
            this.fShowVariablesItem.disconnect();
        }
        if (this.fToggleLinkItem != null) {
            this.fToggleLinkItem.disconnect();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
    }

    public Control getControl() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return this.fTreeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.fTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fTreeViewer.getSelection();
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected ViewerSelectionManager getViewerSelectionManager() {
        if (this.fViewerSelectionManager == null) {
            this.fViewerSelectionManager = new SimpleViewerSelectionManagerImpl(this.getSourceViewer(), this.fTreeViewer);
        }
        return this.fViewerSelectionManager;
    }

    void registerContextMenu() {
        IEditorPart ownerEditor;
        IWorkbenchPage page;
        if (!this.fContextMenuRegistered && this.getTreeViewer() != null && this.getTreeViewer().getControl() != null && (page = this.getSite().getWorkbenchWindow().getActivePage()) != null && (ownerEditor = page.getActiveEditor()) != null) {
            this.fContextMenuRegistered = true;
            this.getSite().registerContextMenu(String.valueOf(ownerEditor.getEditorSite().getId()) + ".OutlineContext", this.fContextMenu, (ISelectionProvider)this);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        SortAction sortAction = new SortAction(this.getTreeViewer(), JSEditorPlugin.getDefault().getPreferenceStore(), OUTLINE_SORT_PREF);
        this.fSortItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)sortAction);
        PropertyChangeUpdateAction action = new ShowHierarchyAction(JavaScriptUIMessages.JSContentOutlinePage_2, JSEditorPlugin.getInstance().getPreferenceStore(), OUTLINE_SHOW_HIERARCHY_PREF, true);
        this.fShowHierarchyItem = new PropertyChangeUpdateActionContributionItem(action);
        action = new ShowVariablesAction(JavaScriptUIMessages.JSContentOutlinePage_3, JSEditorPlugin.getInstance().getPreferenceStore(), OUTLINE_SHOW_VARIABLES_PREF, true);
        this.fShowVariablesItem = new PropertyChangeUpdateActionContributionItem(action);
        CollapseTreeAction collapseAction = new CollapseTreeAction(this.getTreeViewer());
        this.fToggleLinkItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)new ToggleLinkAction(JSEditorPlugin.getInstance().getPreferenceStore(), OUTLINE_LINK_PREF));
        actionBars.getToolBarManager().add((IContributionItem)this.fSortItem);
        actionBars.getToolBarManager().add((IAction)collapseAction);
        actionBars.getMenuManager().add((IContributionItem)this.fToggleLinkItem);
        actionBars.getMenuManager().add((IContributionItem)this.fShowHierarchyItem);
        actionBars.getMenuManager().add((IContributionItem)this.fShowVariablesItem);
    }

    public void setDocument(IDocument document) {
        if (document != this.fDocument) {
            this.fDocument = document;
            if (this.fTreeViewer != null) {
                this.fTreeViewer.setInput((Object)this.fDocument);
                this.fTreeViewer.refresh();
            }
        }
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setSelection(selection, true);
        }
    }

    protected void setSourceViewer(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
    }

    protected class SortAction
    extends PropertyChangeUpdateAction {
        private TreeViewer treeViewer;

        public SortAction(TreeViewer viewer, IPreferenceStore store, String preferenceKey) {
            super(JavaScriptUIMessages.JSContentOutlinePage_4, store, preferenceKey, false);
            this.setImageDescriptor(JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/sort.gif"));
            this.setToolTipText(this.getText());
            this.treeViewer = viewer;
            if (this.isChecked()) {
                this.treeViewer.setSorter((ViewerSorter)new CategorySorter(Collator.getInstance()));
            }
        }

        public void update() {
            super.update();
            this.treeViewer.getControl().setVisible(false);
            Object[] expandedElements = this.treeViewer.getExpandedElements();
            if (this.isChecked()) {
                this.treeViewer.setSorter((ViewerSorter)new CategorySorter(Collator.getInstance()));
            } else {
                this.treeViewer.setSorter(null);
            }
            this.treeViewer.setInput(this.treeViewer.getInput());
            this.treeViewer.setExpandedElements(expandedElements);
            this.treeViewer.getControl().setVisible(true);
        }

        protected class CategorySorter
        extends ViewerSorter {
            public int category(Object element) {
                if (element instanceof ContentElement) {
                    return ((ContentElement)element).getType();
                }
                return 0;
            }

            public CategorySorter() {
            }

            public CategorySorter(Collator collator) {
                super(collator);
            }
        }
    }

    protected class CollapseTreeAction
    extends Action {
        private TreeViewer fTreeViewer = null;

        public CollapseTreeAction(TreeViewer viewer) {
            super(JavaScriptUIMessages.JSContentOutlinePage_0, 1);
            this.setImageDescriptor(JSContentOutlinePage.this.COLLAPSE_E);
            this.setDisabledImageDescriptor(JSContentOutlinePage.this.COLLAPSE_D);
            this.setToolTipText(this.getText());
            this.fTreeViewer = viewer;
        }

        public void run() {
            super.run();
            this.fTreeViewer.collapseAll();
        }
    }

    protected class DeleteAction
    extends Action {
        public DeleteAction() {
            super(JavaScriptUIMessages.JSContentOutlinePage_5);
            this.setImageDescriptor(JSContentOutlinePage.this.DELETE_E);
            this.setDisabledImageDescriptor(JSContentOutlinePage.this.DELETE_D);
            this.setToolTipText(this.getText());
        }

        public void run() {
            Object firstElement;
            ISelection selection = JSContentOutlinePage.this.getTreeViewer().getSelection();
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof ContentElement) {
                ContentElement contentElement = (ContentElement)firstElement;
                try {
                    JSContentOutlinePage.this.fDocument.replace(contentElement.getOffset(), contentElement.getLength(), "");
                    JSContentOutlinePage.this.fTreeViewer.refresh();
                }
                catch (BadLocationException exception) {
                    throw new SourceEditingRuntimeException((Throwable)exception);
                }
            }
        }
    }

    protected class ShowHierarchyAction
    extends PropertyChangeUpdateAction {
        public ShowHierarchyAction(String text, IPreferenceStore store, String preferenceKey, boolean defaultValue) {
            super(text, store, preferenceKey, defaultValue);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/hierarchy.gif"));
        }

        public void update() {
            super.update();
            JSContentElementImpl.setSupportChildren(this.isChecked());
            Object[] expanded = JSContentOutlinePage.this.getTreeViewer().getExpandedElements();
            JSContentOutlinePage.this.getTreeViewer().refresh();
            JSContentOutlinePage.this.getTreeViewer().setExpandedElements(expanded);
        }
    }

    protected class ShowVariablesAction
    extends PropertyChangeUpdateAction {
        public ShowVariablesAction(String text, IPreferenceStore store, String preferenceKey, boolean defaultValue) {
            super(text, store, preferenceKey, defaultValue);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/default.gif"));
        }

        public void update() {
            super.update();
            JSContentElementImpl.setSupportVariables(this.isChecked());
            Object[] expanded = JSContentOutlinePage.this.getTreeViewer().getExpandedElements();
            JSContentOutlinePage.this.getTreeViewer().refresh();
            JSContentOutlinePage.this.getTreeViewer().setExpandedElements(expanded);
        }
    }

    protected class ToggleLinkAction
    extends PropertyChangeUpdateAction {
        public ToggleLinkAction(IPreferenceStore store, String preference) {
            super(JavaScriptUIMessages.JSContentOutlinePage_1, store, preference, true);
            this.setToolTipText(this.getText());
            this.setDisabledImageDescriptor(JSContentOutlinePage.this.SYNCED_D);
            this.setImageDescriptor(JSContentOutlinePage.this.SYNCED_E);
            this.update();
        }

        public void update() {
            ((SimpleTreeViewer)JSContentOutlinePage.this.getTreeViewer()).setLinkWithEditor(this.isChecked());
        }
    }
}

