/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.IOperationNode;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WTPActionContentProvider;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WTPActionLabelProvider;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WTPOptionalOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModelEvent;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModelListener;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public class WTPActionDialog
extends Dialog
implements WTPOperationDataModelListener {
    private ITreeViewerListener actionTreeListener;
    private ICheckStateListener checkStateListener;
    private ISelectionChangedListener updateDescriptionSelectionListener;
    private CheckboxTreeViewer checkboxTreeViewer;
    Text descriptionText;
    private final WTPOptionalOperationDataModel operationDataModel;
    private String id;

    public WTPActionDialog(Shell arg0, WTPOptionalOperationDataModel operationDataModel) {
        super(arg0);
        this.operationDataModel = operationDataModel;
        this.operationDataModel.addListener(this);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(WTPCommonUIResourceHandler.getString("WTPActionDialog_UI_0"));
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(superComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (this.getId() != null) {
            WorkbenchHelp.setHelp((Control)composite, (String)this.getId());
        }
        Label availableFiltersLabel = new Label(composite, 1);
        GridData availableFiltersLabelGridData = new GridData(768);
        availableFiltersLabelGridData.heightHint = this.convertHeightInCharsToPixels(1);
        availableFiltersLabel.setLayoutData((Object)availableFiltersLabelGridData);
        availableFiltersLabel.setText(WTPCommonUIResourceHandler.getString("WTPActionDialog_UI_0"));
        this.checkboxTreeViewer = new CheckboxTreeViewer(composite, 2080);
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new WTPActionContentProvider());
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new WTPActionLabelProvider());
        this.checkboxTreeViewer.setInput((Object)this.operationDataModel);
        Tree tree = this.checkboxTreeViewer.getTree();
        GridLayout treeLayout = new GridLayout();
        treeLayout.marginHeight = 0;
        treeLayout.marginWidth = 0;
        treeLayout.verticalSpacing = 0;
        treeLayout.horizontalSpacing = 0;
        treeLayout.numColumns = 1;
        GridData treeGridData = new GridData(768);
        treeGridData.widthHint = this.convertHorizontalDLUsToPixels(225);
        treeGridData.heightHint = this.convertVerticalDLUsToPixels(150);
        tree.setLayout((Layout)treeLayout);
        tree.setLayoutData((Object)treeGridData);
        this.descriptionText = new Text(composite, 2112);
        GridData descriptionTextGridData = new GridData(768);
        descriptionTextGridData.heightHint = this.convertHeightInCharsToPixels(3);
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
        this.descriptionText.setBackground(superComposite.getBackground());
        this.initListeners();
        this.updateCheckedItems();
        return composite;
    }

    protected void initListeners() {
        this.checkboxTreeViewer.addCheckStateListener(this.getCheckStateListener());
        this.checkboxTreeViewer.addSelectionChangedListener(this.getSelectionListener());
        this.checkboxTreeViewer.addTreeListener(this.getActionTreeListener());
    }

    protected ICheckStateListener getCheckStateListener() {
        if (this.checkStateListener == null) {
            this.checkStateListener = new CheckStateListener();
        }
        return this.checkStateListener;
    }

    private ISelectionChangedListener getSelectionListener() {
        if (this.updateDescriptionSelectionListener == null) {
            this.updateDescriptionSelectionListener = new SelectionChangedListener();
        }
        return this.updateDescriptionSelectionListener;
    }

    private ITreeViewerListener getActionTreeListener() {
        if (this.actionTreeListener == null) {
            this.actionTreeListener = new TreeViewerListener();
        }
        return this.actionTreeListener;
    }

    public void propertyChanged(WTPOperationDataModelEvent event) {
        switch (event.getFlag()) {
            case 1: {
                if (!"WTPOptionalOperationDataModel.OPERATION_TREE".equals(event.getPropertyName())) break;
                this.updateCheckedItems();
            }
        }
    }

    private void updateCheckedItems() {
        IOperationNode root = (IOperationNode)this.operationDataModel.getProperty("WTPOptionalOperationDataModel.OPERATION_TREE");
        this.updateCheckedState(root);
    }

    private void updateCheckedState(IOperationNode root) {
        if (root == null) {
            return;
        }
        IOperationNode[] children = root.getChildren();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.checkboxTreeViewer.setChecked((Object)children[i], children[i].isChecked());
            boolean disabled = children[i].getParent() != null ? children[i].getParent().isChecked() : false;
            this.checkboxTreeViewer.setGrayed((Object)children[i], disabled);
            this.updateCheckedState(children[i]);
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public class CheckStateListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean checked = event.getChecked();
            IOperationNode node = (IOperationNode)event.getElement();
            node.setChecked(checked);
        }
    }

    public class TreeViewerListener
    implements ITreeViewerListener {
        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    }

    public class SelectionChangedListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
            Object element = structuredSelection.getFirstElement();
            String text = "";
            if (element instanceof IOperationNode) {
                text = ((IOperationNode)element).getDescription();
            }
            WTPActionDialog.this.descriptionText.setText(text != null ? text : "");
        }
    }
}

