/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards.shared;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionDisplayProperty;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

public class ExistingConnectionsWizardPage
extends WizardPage
implements Listener {
    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
    private Button newConnectionRadioButton;
    private Button existingConnectionRadioButton;
    private Group existingConnectionsGroup;
    private List existingConnectionsList;
    private Label propertiesLabel;
    private Table connectionPropertiesTable;
    private Hashtable existingConnections;
    private int lastSelectedConnection = -1;

    public ExistingConnectionsWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public ExistingConnectionsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(resource.queryString("_UI_PAGE_TITLE_EXISTING_CONNECTIONS"));
        this.setMessage(resource.queryString("_UI_PAGE_DESCRIPTION_EXISTING_CONNECTIONS"));
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.newConnectionRadioButton) {
            this.enableExistingConnectionsControls(this.existingConnectionRadioButton.getSelection());
        } else if (source == this.existingConnectionsList) {
            this.updateConnectionProperties();
            this.setPageComplete(true);
        }
    }

    private void updateConnectionProperties() {
        ConnectionDisplayProperty[] properties;
        ConnectionInfo selectedConnection;
        this.connectionPropertiesTable.removeAll();
        if (this.existingConnectionsList.getSelectionIndex() > -1 && (selectedConnection = (ConnectionInfo)this.existingConnections.get(this.existingConnectionsList.getSelection()[0])) != null && (properties = this.getConnectionDisplayProperties(selectedConnection)) != null) {
            int propertyCount = properties.length;
            int index = 0;
            while (index < propertyCount) {
                TableItem tableItem = new TableItem(this.connectionPropertiesTable, 0);
                tableItem.setText(new String[]{properties[index].getPropertyName(), properties[index].getValue()});
                ++index;
            }
        }
    }

    private ConnectionDisplayProperty[] getConnectionDisplayProperties(ConnectionInfo connectionInfo) {
        Object[] properties = null;
        Vector<ConnectionDisplayProperty> propertiesCollection = new Vector<ConnectionDisplayProperty>();
        propertiesCollection.add(new ConnectionDisplayProperty(resource.queryString("_UI_DATABASE_CONNECTION_PROPERTY_NAME"), String.valueOf(connectionInfo.getDatabaseDefinition().getProduct()) + " " + connectionInfo.getDatabaseDefinition().getVersion()));
        propertiesCollection.add(new ConnectionDisplayProperty(resource.queryString("_UI_JDBC_DRIVER_CLASS_CONNECTION_PROPERTY_NAME"), connectionInfo.getDriverClassName()));
        propertiesCollection.add(new ConnectionDisplayProperty(resource.queryString("_UI_CLASS_LOCATION_CONNECTION_PROPERTY_NAME"), connectionInfo.getLoadingPath()));
        propertiesCollection.add(new ConnectionDisplayProperty(resource.queryString("_UI_URL_CONNECTION_PROPERTY_NAME"), connectionInfo.getURL()));
        propertiesCollection.add(new ConnectionDisplayProperty(resource.queryString("_UI_USER_ID_CONNECTION_PROPERTY_NAME"), connectionInfo.getUserName()));
        properties = new ConnectionDisplayProperty[propertiesCollection.size()];
        propertiesCollection.copyInto(properties);
        properties = this.updateConnectionDisplayProperties(connectionInfo, (ConnectionDisplayProperty[])properties);
        return properties;
    }

    protected ConnectionDisplayProperty[] updateConnectionDisplayProperties(ConnectionInfo connectionInfo, ConnectionDisplayProperty[] defaultDisplayProperties) {
        return defaultDisplayProperties;
    }

    private void enableExistingConnectionsControls(boolean isEnabled) {
        this.existingConnectionsGroup.setEnabled(isEnabled);
        this.existingConnectionsList.setEnabled(isEnabled);
        this.propertiesLabel.setEnabled(isEnabled);
        this.connectionPropertiesTable.setEnabled(isEnabled);
        if (isEnabled) {
            this.existingConnectionsList.select(this.lastSelectedConnection);
            this.updateConnectionProperties();
        } else {
            this.lastSelectedConnection = this.existingConnectionsList.getSelectionIndex();
            this.existingConnectionsList.deselectAll();
            this.updateConnectionProperties();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.newConnectionRadioButton = new Button(composite, 16);
        this.newConnectionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_NEW_CONNECTION"));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.newConnectionRadioButton.setLayoutData((Object)gd);
        this.existingConnectionRadioButton = new Button(composite, 16);
        this.existingConnectionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_EXISTING_CONNECTION"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.existingConnectionRadioButton.setLayoutData((Object)gd);
        Composite indentationComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        indentationComposite.setLayout((Layout)layout);
        indentationComposite.setLayoutData((Object)new GridData(1808));
        this.existingConnectionsGroup = new Group(indentationComposite, 0);
        this.existingConnectionsGroup.setText(resource.queryString("_UI_GROUP_EXISTING_CONNECTIONS"));
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        this.existingConnectionsGroup.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.existingConnectionsGroup.setLayoutData((Object)gd);
        this.existingConnectionsList = new List((Composite)this.existingConnectionsGroup, 2560);
        gd = new GridData(768);
        gd.heightHint = 100;
        this.existingConnectionsList.setLayoutData((Object)gd);
        this.propertiesLabel = new Label((Composite)this.existingConnectionsGroup, 0);
        this.propertiesLabel.setText(resource.queryString("_UI_LABEL_PROPERTIES"));
        gd = new GridData();
        this.propertiesLabel.setLayoutData((Object)gd);
        this.connectionPropertiesTable = new Table((Composite)this.existingConnectionsGroup, 2048);
        gd = new GridData(1808);
        this.connectionPropertiesTable.setLayoutData((Object)gd);
        this.connectionPropertiesTable.setLinesVisible(true);
        this.connectionPropertiesTable.setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this.connectionPropertiesTable, 0);
        tc1.setText(resource.queryString("_UI_TABLE_COLUMN_PROPERTY"));
        tc1.setResizable(true);
        tc1.setWidth(140);
        TableColumn tc2 = new TableColumn(this.connectionPropertiesTable, 0);
        tc2.setText(resource.queryString("_UI_TABLE_COLUMN_VALUE"));
        tc2.setResizable(true);
        tc2.setWidth(250);
        this.initializeDialogUnits((Control)composite);
        this.setControl((Control)composite);
        this.newConnectionRadioButton.addListener(13, (Listener)this);
        this.newConnectionRadioButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExistingConnectionsWizardPage.this.onCreateNewConnectionSelectionChanged();
            }
        });
        this.existingConnectionRadioButton.addListener(13, (Listener)this);
        this.existingConnectionsList.addListener(13, (Listener)this);
        this.newConnectionRadioButton.setSelection(true);
        this.enableExistingConnectionsControls(false);
        this.initializeValues();
        this.setPageComplete(true);
    }

    private void initializeValues() {
        this.existingConnectionsList.removeAll();
        ConnectionInfo[] connInfos = this.getConnectionsToDisplay();
        if (connInfos != null) {
            this.existingConnections = new Hashtable();
            Iterator<ConnectionInfo> connections = Arrays.asList(connInfos).iterator();
            while (connections.hasNext()) {
                ConnectionInfo con = connections.next();
                this.existingConnections.put(con.getName(), con);
            }
            Enumeration existingConnectionNames = this.existingConnections.keys();
            while (existingConnectionNames.hasMoreElements()) {
                this.existingConnectionsList.add(existingConnectionNames.nextElement().toString());
            }
        }
        if (this.existingConnectionsList.getItemCount() > 0) {
            this.existingConnectionsList.select(0);
            this.updateConnectionProperties();
            this.enableExistingConnectionsControls(false);
            this.existingConnectionRadioButton.setEnabled(true);
        } else {
            this.enableExistingConnectionsControls(false);
            this.existingConnectionRadioButton.setEnabled(false);
        }
        this.newConnectionRadioButton.setSelection(true);
        this.existingConnectionRadioButton.setSelection(false);
    }

    public ConnectionInfo getSelectedConnection() {
        ConnectionInfo connection = null;
        if (this.existingConnectionRadioButton.getSelection()) {
            connection = (ConnectionInfo)this.existingConnections.get(this.existingConnectionsList.getSelection()[0]);
        }
        return connection;
    }

    protected ConnectionInfo[] getConnectionsToDisplay() {
        return RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
    }

    public boolean isNewConnectionSelected() {
        return this.newConnectionRadioButton.getSelection();
    }

    public boolean isExistingConnectionSelected() {
        return this.existingConnectionRadioButton.getSelection();
    }

    protected void onCreateNewConnectionSelectionChanged() {
        this.getContainer().updateButtons();
    }

    public void setDefaultConnection(String connectionName) {
        if (this.existingConnectionsList.indexOf(connectionName) > -1) {
            this.existingConnectionRadioButton.setSelection(true);
            this.existingConnectionRadioButton.setFocus();
            this.newConnectionRadioButton.setSelection(false);
            this.enableExistingConnectionsControls(true);
            this.existingConnectionsList.setSelection(new String[]{connectionName});
            this.updateConnectionProperties();
            this.setPageComplete(true);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeValues();
            if (this.newConnectionRadioButton.getSelection()) {
                this.newConnectionRadioButton.setFocus();
            } else {
                this.existingConnectionRadioButton.setFocus();
            }
        }
    }
}

