/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.eclipse;

import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.command.internal.env.plugin.EnvPlugin;
import org.eclipse.wst.command.internal.provisional.env.core.common.Log;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class EclipseLog
implements Log {
    public boolean isEnabled() {
        return EnvPlugin.getInstance().isDebugging();
    }

    public boolean isEnabled(String option) {
        return "true".equals(Platform.getDebugOption((String)("org.eclipse.wst.command.env/trace/" + option)));
    }

    public void log(int severity, int messageNum, Object caller, String method, Object object) {
        if (this.isEnabled()) {
            switch (severity) {
                case 4: {
                    if (!this.isEnabled("error")) break;
                    System.out.println(String.valueOf(this.getMessageNumString(messageNum)) + "E " + caller + "::" + method + ": object=" + object);
                    break;
                }
                case 2: {
                    if (!this.isEnabled("warning")) break;
                    System.out.println(String.valueOf(this.getMessageNumString(messageNum)) + "W " + caller + "::" + method + ": object=" + object);
                    break;
                }
                case 1: {
                    if (!this.isEnabled("info")) break;
                    System.out.println(String.valueOf(this.getMessageNumString(messageNum)) + "I " + caller + "::" + method + ": object=" + object);
                }
            }
        }
    }

    public void log(int severity, int messageNum, Object caller, String method, Status status) {
        this.log(severity, messageNum, caller, method, (Object)status);
    }

    public void log(int severity, int messageNum, Object caller, String method, Throwable throwable) {
        this.log(severity, messageNum, caller, method, (Object)null);
        throwable.printStackTrace();
    }

    public void log(int severity, String option, int messageNum, Object caller, String method, Object object) {
        if (this.isEnabled(option)) {
            System.out.println(String.valueOf(this.getMessageNumString(messageNum)) + "I " + caller + "::" + method + ": object=" + object);
        }
    }

    public void log(int severity, String option, int messageNum, Object caller, String method, Throwable throwable) {
        if (this.isEnabled(option)) {
            System.out.println(String.valueOf(this.getMessageNumString(messageNum)) + "I " + caller + "::" + method);
            throwable.printStackTrace();
        }
    }

    public void log(int severity, String option, int messageNum, Object caller, String method, Status status) {
        this.log(severity, option, messageNum, caller, method, (Object)status);
    }

    private String getMessageNumString(int messageNum) {
        String messageNumString = "IWAB";
        if (messageNum > 9999 || messageNum < 0) {
            messageNum = 9999;
        }
        messageNumString = String.valueOf(messageNumString) + new Integer(messageNum).toString();
        return messageNumString;
    }
}

