/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class UpdateWEBXMLCommand
extends SimpleCommand {
    private String LABEL = "TASK_LABEL_UPDATE_WEB_XML";
    private String DESCRIPTION = "TASK_DESC_UPDATE_WEB_XML";
    private MessageUtils msgUtils_;
    private IProject serverProject;
    private String moduleName_;

    public UpdateWEBXMLCommand(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.moduleName_ = moduleName;
    }

    public Status execute(Environment environment) {
        if (this.serverProject != null) {
            Status status = null;
            status = this.addServlet(this.serverProject, this.moduleName_, this.getAxisServletDescriptor());
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            this.addServlet(this.serverProject, this.moduleName_, this.getAdmintServletDescriptor());
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        return new SimpleStatus("");
    }

    private ServletDescriptor getAxisServletDescriptor() {
        ServletDescriptor sd = new ServletDescriptor();
        sd._name = "AxisServlet";
        sd._displayName = "Apache-Axis Servlet";
        sd._className = "org.apache.axis.transport.http.AxisServlet";
        sd._mappings = new String[]{"/servlet/AxisServlet", "*.jws", "/services/*"};
        return sd;
    }

    private ServletDescriptor getAdmintServletDescriptor() {
        ServletDescriptor sd = new ServletDescriptor();
        sd._name = "AdminServlet";
        sd._displayName = "Axis Admin Servlet";
        sd._className = "org.apache.axis.transport.http.AdminServlet";
        sd._mappings = new String[]{"/servlet/AdminServlet"};
        sd._loadOnStartup = new Integer(100);
        return sd;
    }

    private ServletDescriptor getSoapMonitorServletDescriptor() {
        ServletDescriptor sd = new ServletDescriptor();
        sd._name = "SOAPMonitorService";
        sd._displayName = "SOAPMonitorService";
        sd._className = "org.apache.axis.monitor.SOAPMonitorService";
        sd._mappings = new String[]{"/SOAPMonitor"};
        sd._loadOnStartup = new Integer(100);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SOAPMonitorPort", "5001");
        sd._params = params;
        return sd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status addServlet(IProject webProject, String moduleName, ServletDescriptor servletDescriptor) {
        SimpleStatus simpleStatus;
        WebArtifactEdit webEdit;
        block14: {
            SimpleStatus simpleStatus2;
            block13: {
                new Object();
                webEdit = null;
                try {
                    try {
                        WebApp webapp = null;
                        IVirtualComponent vc = ComponentCore.createComponent((IProject)webProject, (String)moduleName);
                        webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)vc);
                        if (webEdit != null) {
                            webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
                            boolean foundServlet = false;
                            EList theServlets = webapp.getServlets();
                            int i = 0;
                            while (true) {
                                if (i >= theServlets.size()) {
                                    if (!foundServlet) break;
                                    simpleStatus2 = new SimpleStatus("");
                                    Object var14_16 = null;
                                    if (webEdit == null) return simpleStatus2;
                                    break block13;
                                }
                                Servlet aServlet = (Servlet)theServlets.get(i);
                                if (aServlet.getServletName().equals(servletDescriptor._name)) {
                                    foundServlet = true;
                                }
                                ++i;
                            }
                            WebapplicationFactory factory = WebapplicationFactory.eINSTANCE;
                            Servlet servlet = factory.createServlet();
                            ServletType servletType = factory.createServletType();
                            servlet.setWebType((WebType)servletType);
                            servlet.setServletName(servletDescriptor._name);
                            servletType.setClassName(servletDescriptor._className);
                            if (servletDescriptor._displayName != null) {
                                servlet.setDisplayName(servletDescriptor._displayName);
                            }
                            if (servletDescriptor._loadOnStartup != null) {
                                servlet.setLoadOnStartup(servletDescriptor._loadOnStartup);
                            }
                            if (servletDescriptor._params != null) {
                                Properties properties = servlet.getParamsAsProperties();
                                properties.putAll((Map<?, ?>)servletDescriptor._params);
                            }
                            webapp.getServlets().add((Object)servlet);
                            if (servletDescriptor._mappings != null) {
                                int i2 = 0;
                                while (i2 < servletDescriptor._mappings.length) {
                                    ServletMapping servletMapping = factory.createServletMapping();
                                    servletMapping.setServlet(servlet);
                                    servletMapping.setUrlPattern(servletDescriptor._mappings[i2]);
                                    webapp.getServletMappings().add((Object)servletMapping);
                                    ++i2;
                                }
                            }
                            webEdit.save((IProgressMonitor)new NullProgressMonitor());
                        }
                        simpleStatus = new SimpleStatus("");
                        break block14;
                    }
                    catch (Exception e) {
                        SimpleStatus simpleStatus3 = new SimpleStatus("UpdateWEBXMLCommand.addServlet", this.msgUtils_.getMessage("MSG_ERROR_UPDATE_WEB_XML"), 4, (Throwable)e);
                        Object var14_18 = null;
                        if (webEdit == null) return simpleStatus3;
                        webEdit.dispose();
                        return simpleStatus3;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    if (webEdit == null) throw throwable;
                    webEdit.dispose();
                    throw throwable;
                }
            }
            webEdit.dispose();
            return simpleStatus2;
        }
        Object var14_17 = null;
        if (webEdit == null) return simpleStatus;
        webEdit.dispose();
        return simpleStatus;
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }

    public class ServletDescriptor {
        String _name;
        String _className;
        String _displayName;
        Map _params;
        String[] _mappings;
        Integer _loadOnStartup;
    }
}

