/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.FileUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class MoveDeploymentFilesTask
extends SimpleCommand {
    private final String LABEL = "TASK_LABEL_MOVE_DEPLOYMENT_FILES";
    private final String DESCRIPTION = "TASK_DESC_MOVE_DEPLOYMENT_FILES";
    private final String WEB_INF = "WEB-INF";
    private final String META_INF = "META-INF";
    private MessageUtils msgUtils_;
    private MessageUtils coreMsgUtils_;
    private IProject serverProject;
    private String moduleName_;
    private JavaWSDLParameter javaWSDLParam_;

    public MoveDeploymentFilesTask(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setDescription(this.msgUtils_.getMessage("TASK_DESC_MOVE_DEPLOYMENT_FILES"));
        this.setName(this.msgUtils_.getMessage("TASK_LABEL_MOVE_DEPLOYMENT_FILES"));
        this.moduleName_ = moduleName;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        if (this.javaWSDLParam_ == null) {
            status = new SimpleStatus("", this.coreMsgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        IProject project = this.serverProject;
        String projectURL = ServerUtils.getEncodedWebComponentURL((IProject)project, (String)this.moduleName_);
        if (projectURL == null) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_PROJECT_URL", (Object[])new String[]{project.toString()}), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        this.javaWSDLParam_.setProjectURL(projectURL);
        try {
            String[] deployFiles = this.javaWSDLParam_.getDeploymentFiles();
            String javaOutput = this.javaWSDLParam_.getJavaOutput();
            if (deployFiles == null || javaOutput == null) {
                return status;
            }
            IPath webinfPath = J2EEUtils.getWebInfPath((IProject)project, (String)this.moduleName_);
            int i = 0;
            while (i < deployFiles.length) {
                File f = new File(deployFiles[i]);
                String resourceToMove = f.getName();
                String targetFileName = ResourceUtils.getWorkspaceRoot().getFile(webinfPath.addTrailingSeparator().append(resourceToMove)).getLocation().toString();
                FileUtil.createTargetFile((String)deployFiles[i], (String)targetFileName, (boolean)true);
                File deploymentFile = new File(deployFiles[i]);
                deploymentFile.delete();
                deployFiles[i] = targetFileName;
                ++i;
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_MOVE_RESOURCE", (Object[])new String[]{e.getLocalizedMessage()}), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        return status;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }
}

