/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.FileUtil;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.jst.ws.internal.axis.creation.ui.plugin.WebServiceAxisCreationUIPlugin;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CopyWSDLCommand;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class Skeleton2WSDLCommand
extends SimpleCommand {
    private static final String LABEL = "TASK_LABEL_SKELETON_WSDL";
    private static final String DESCRIPTION = "TASK_DESC_SKELETON_WSDL";
    private static final String IMPL = "Impl";
    private static final String SERVICE_EXT = "/services/";
    private static final String WSDL_EXT = "wsdl";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String PROTOCOL_SUFFIX = "://";
    private final String WSDL_FOLDER = "wsdl";
    private WebServicesParser webServicesParser;
    private JavaWSDLParameter javaWSDLParam;
    private IProject serverProject;
    private HashMap visitedLinks;
    private MessageUtils msgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.creation.ui.plugin", (Object)this);
    private String moduleName_;

    public Skeleton2WSDLCommand(String moduleName) {
        super(WebServiceAxisCreationUIPlugin.getMessage(LABEL), WebServiceAxisCreationUIPlugin.getMessage(DESCRIPTION));
        this.setName(LABEL);
        this.setDescription(DESCRIPTION);
        this.moduleName_ = moduleName;
    }

    public Status execute(Environment env) {
        if (!(env instanceof EclipseEnvironment)) {
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.axis.creation.ui", this.msgUtils_.getMessage("MSG_ERROR_NOT_IN_ECLIPSE_ENVIRONMENT", (Object[])new String[]{"Skeleton2WSDLCommand"}), 4, null);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        if (this.javaWSDLParam == null) {
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.axis.creation.ui", this.msgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4, null);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        Definition definition = null;
        String wsdlURL = this.javaWSDLParam.getInputWsdlLocation();
        try {
            URL url = new URL(wsdlURL);
            definition = this.webServicesParser.getWSDLDefinition(url.toString());
        }
        catch (MalformedURLException malformedURLException) {
            wsdlURL = PlatformUtils.getFileURLFromPath((IPath)new Path(wsdlURL));
            definition = this.webServicesParser.getWSDLDefinition(wsdlURL);
        }
        Service service = null;
        Port port = null;
        if (definition != null) {
            StringBuffer beanName = new StringBuffer();
            beanName.append(WSDLUtils.getPackageName((Definition)definition));
            beanName.append(DOT);
            try {
                service = (Service)definition.getServices().values().iterator().next();
                port = (Port)service.getPorts().values().iterator().next();
                Binding binding = port.getBinding();
                beanName.append(binding.getQName().getLocalPart());
                beanName.append(IMPL);
                this.javaWSDLParam.setBeanName(beanName.toString());
                this.javaWSDLParam.setPortTypeName(WSDLUtils.getPortTypeName((Definition)definition));
                this.javaWSDLParam.setServiceName(WSDLUtils.getServiceElementName((Definition)definition));
                this.javaWSDLParam.setBeanPackage(WSDLUtils.getPackageName((Definition)definition));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.axis.creation.ui", this.msgUtils_.getMessage("MSG_ERROR_WSDL_NO_DEFINITION", (Object[])new String[]{wsdlURL}), 4, null);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        if (port == null) {
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.axis.creation.ui", this.msgUtils_.getMessage("MSG_ERROR_WSDL_NO_PORT", (Object[])new String[]{wsdlURL}), 4, null);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        Map services = definition.getServices();
        Iterator servicesIt = services.values().iterator();
        while (servicesIt.hasNext()) {
            Service s = (Service)servicesIt.next();
            Map ports = s.getPorts();
            Iterator portsIt = ports.values().iterator();
            while (portsIt.hasNext()) {
                Port p = (Port)portsIt.next();
                this.modifyEndpoint(p);
            }
        }
        this.visitedLinks = new HashMap();
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        String wsdlLocation = this.javaWSDLParam.getOutputWsdlLocation();
        IPath wsdlPath = null;
        IFile outputFile = null;
        try {
            if (wsdlLocation != null) {
                outputFile = workspace.getFileForLocation((IPath)new Path(wsdlLocation));
            } else {
                wsdlPath = J2EEUtils.getWebContentPath((IProject)this.serverProject, (String)this.moduleName_);
                IPath wsdlFilePath = wsdlPath.append(WSDL_EXT).append(port.getName()).addFileExtension(WSDL_EXT);
                IFolder folder = ResourceUtils.getWorkspaceRoot().getFolder(wsdlPath.append(WSDL_EXT));
                FileUtil.createFolder((IFolder)folder, (boolean)true, (boolean)true);
                outputFile = workspace.getFile(wsdlFilePath);
                wsdlLocation = outputFile.getLocation().toString();
                this.javaWSDLParam.setOutputWsdlLocation(wsdlLocation);
            }
            CopyWSDLCommand copyWSDLCommand = new CopyWSDLCommand();
            copyWSDLCommand.setWebServicesParser(this.webServicesParser);
            copyWSDLCommand.setWsdlURI(wsdlURL);
            copyWSDLCommand.setDestinationURI(outputFile.getLocation().toFile().toURL().toString());
            copyWSDLCommand.setDefinition(definition);
            Status status = copyWSDLCommand.execute(env);
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
        }
        catch (Exception e) {
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.axis.creation.ui", this.msgUtils_.getMessage("MSG_ERROR_WRITE_WSDL", (Object[])new String[]{wsdlLocation}), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        return new SimpleStatus("");
    }

    private Status modifyEndpoint(Port port) {
        Iterator it = port.getExtensibilityElements().iterator();
        SOAPAddress soapAddress = null;
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof SOAPAddress)) continue;
            soapAddress = (SOAPAddress)obj;
            break;
        }
        if (soapAddress != null) {
            String projectURL = ServerUtils.getEncodedWebComponentURL((IProject)this.serverProject, (String)this.moduleName_);
            if (projectURL == null) {
                return new SimpleStatus("org.eclipse.jst.ws.axis.creation.ui", this.msgUtils_.getMessage("MSG_ERROR_PROJECT_URL", (Object[])new String[]{this.serverProject.toString()}), 4, null);
            }
            StringBuffer serviceURL = new StringBuffer(projectURL);
            serviceURL.append(SERVICE_EXT).append(port.getName());
            this.javaWSDLParam.setUrlLocation(serviceURL.toString());
            soapAddress.setLocationURI(serviceURL.toString());
        }
        return new SimpleStatus("");
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public String getWsdlURI() {
        File file = new File(this.getJavaWSDLParam().getOutputWsdlLocation());
        String url = "";
        try {
            url = file.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {}
        return url;
    }
}

