/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.skeleton;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;

public class SkeletonConfigWidget
extends SimpleWidgetDataContributor {
    private JavaWSDLParameter javaWSDLParam;
    private static final String INFOPOP_PBSC_PAGE = "PBSC0001";
    private static final String TOOLTIP_PBSC_PAGE = "TOOLTIP_PBSC_PAGE";
    private final String INFOPOP_PBCF_TEXT_URI = "PBCF0002";
    private final String TOOLTIP_PBCF_TEXT_URI = "TOOLTIP_PBCF_TEXT_URI";
    private Text wsdlFolderText_;
    private final String INFOPOP_PBCF_TEXT_WSDL_FOLDER = "PBCF0006";
    private final String TOOLTIP_PBCF_TEXT_WSDL_FOLDER = "TOOLTIP_PBCF_TEXT_WSDL_FOLDER";
    private Text wsdlFileText_;
    private final String INFOPOP_PBCF_TEXT_WSDL_FILE = "PBCF0007";
    private final String TOOLTIP_PBCF_TEXT_WSDL_FILE = "TOOLTIP_PBCF_TEXT_WSDL_FILE";
    private Combo skeletonFolderText_;
    private static final String INFOPOP_PBSC_TEXT_SKELETON_FOLDER = "PBSC0004";
    private static final String TOOLTIP_PBSC_TEXT_SKELETON_FOLDER = "TOOLTIP_PBSC_TEXT_SKELETON_FOLDER";
    private Button showMappingsCheckbox_;
    private String INFOPOP_N2P_SHOW_MAPPINGS = "PBSC0016";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        String conPluginId = "org.eclipse.jst.ws.axis.consumption.ui";
        String baseConPluginId = "org.eclipse.jst.ws.consumption.ui";
        MessageUtils msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        MessageUtils conMsgUtils = new MessageUtils(String.valueOf(conPluginId) + ".plugin", (Object)this);
        MessageUtils baseConMsgUtils = new MessageUtils(String.valueOf(baseConPluginId) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(msgUtils, pluginId);
        UIUtils conUiUtils = new UIUtils(conMsgUtils, pluginId);
        UIUtils baseConUiUtils = new UIUtils(baseConMsgUtils, pluginId);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(pluginId) + "." + INFOPOP_PBSC_PAGE);
        parent.setToolTipText(msgUtils.getMessage(TOOLTIP_PBSC_PAGE));
        Composite textGroup = uiUtils.createComposite(parent, 2, 0, 0);
        this.wsdlFolderText_ = uiUtils.createText(textGroup, "LABEL_OUTPUT_FOLDER_NAME", "TOOLTIP_PBCF_TEXT_WSDL_FOLDER", "PBCF0006", 2060);
        this.wsdlFileText_ = uiUtils.createText(textGroup, "LABEL_OUTPUT_FILE_NAME", "TOOLTIP_PBCF_TEXT_WSDL_FILE", "PBCF0007", 2060);
        this.skeletonFolderText_ = baseConUiUtils.createCombo(textGroup, "LABEL_SKELETON_ROOT_NAME", TOOLTIP_PBSC_TEXT_SKELETON_FOLDER, INFOPOP_PBSC_TEXT_SKELETON_FOLDER, 2060);
        uiUtils.createHorizontalSeparator(parent, 5);
        this.showMappingsCheckbox_ = conUiUtils.createCheckbox(parent, "LABEL_EXPLORE_MAPPINGS_XML2BEAN", "TOOLTIP_N2P_SHOW_MAPPINGS", this.INFOPOP_N2P_SHOW_MAPPINGS);
        return this;
    }

    public void setEndpointURI(String endpointURI) {
    }

    public void setOutputWSDLFolder(String outputWSDLFolder) {
        if (outputWSDLFolder != null) {
            this.wsdlFolderText_.setText(outputWSDLFolder);
        }
    }

    public void setOutputWSDLFile(String outputWSDLFile) {
        if (outputWSDLFile != null) {
            this.wsdlFileText_.setText(outputWSDLFile);
        }
    }

    public void setOutputJavaFolder(String outputJavaFolder) {
        if (outputJavaFolder != null) {
            int index = this.skeletonFolderText_.indexOf(outputJavaFolder);
            if (index != -1) {
                this.skeletonFolderText_.select(index);
            } else if (this.skeletonFolderText_.getItemCount() <= 0) {
                String root = this.getWorkspaceRootLocation();
                if (outputJavaFolder.startsWith(root)) {
                    this.skeletonFolderText_.setText(outputJavaFolder.substring(root.length()));
                } else {
                    this.skeletonFolderText_.setText(outputJavaFolder);
                }
            }
        }
    }

    public void setShowMapping(boolean showMapping) {
        this.showMappingsCheckbox_.setSelection(showMapping);
    }

    public boolean getShowMapping() {
        return this.showMappingsCheckbox_.getSelection();
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        String root = this.getWorkspaceRootLocation();
        File file = new File(root);
        try {
            root = file.toURL().toString();
            char lastChar = root.charAt(root.length() - 1);
            if (lastChar == '/' || lastChar == '\\') {
                root = root.substring(0, root.length() - 1);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        this.javaWSDLParam.setOutput(String.valueOf(root) + this.wsdlFolderText_.getText());
        this.javaWSDLParam.setJavaOutput(String.valueOf(root) + this.skeletonFolderText_.getText());
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServerProject(IProject serviceProject) {
        String originalSkeletonFolder = this.skeletonFolderText_.getText();
        this.skeletonFolderText_.removeAll();
        IPath[] paths = ResourceUtils.getAllJavaSourceLocations((IProject)serviceProject);
        int i = 0;
        while (i < paths.length) {
            this.skeletonFolderText_.add(paths[i].toString());
            ++i;
        }
        int index = this.skeletonFolderText_.indexOf(originalSkeletonFolder);
        if (index != -1) {
            this.skeletonFolderText_.select(index);
        } else {
            this.skeletonFolderText_.select(0);
        }
    }

    private String getWorkspaceRootLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().removeTrailingSeparator().toString();
    }
}

