/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.classpath;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;

public final class WebAppContainer
extends FlexibleProjectContainer {
    private static final IPath[] paths = new IPath[]{new Path("WEB-INF/lib"), new Path("WEB-INF/classes")};
    private static final FlexibleProjectContainer.PathType[] types = new FlexibleProjectContainer.PathType[]{FlexibleProjectContainer.PathType.LIB_DIRECTORY, FlexibleProjectContainer.PathType.CLASSES_DIRECTORY};
    public static final String CONTAINER_ID = "org.eclipse.jst.j2ee.internal.web.container";

    public WebAppContainer(IPath path, IJavaProject jproject) {
        super(path, jproject, jproject.getProject(), path.segment(1), paths, types);
    }

    public String getDescription() {
        return WebAppContainer.resource("WEB_CONT_DESCRIPTION", this.component);
    }

    public void install() {
        IJavaProject[] projects = new IJavaProject[]{this.owner};
        IClasspathContainer[] conts = new IClasspathContainer[]{this};
        try {
            JavaCore.setClasspathContainer((IPath)this.path, (IJavaProject[])projects, (IClasspathContainer[])conts, null);
        }
        catch (JavaModelException e) {
            WebPlugin.log((Exception)((Object)e));
        }
    }

    public void refresh() {
        new WebAppContainer(this.path, this.owner).install();
    }

    public static IClasspathEntry convert(String component) {
        IPath path = new Path(CONTAINER_ID).append(component);
        return JavaCore.newContainerEntry((IPath)path);
    }

    public static String convert(IClasspathEntry cpe) {
        return cpe.getPath().segment(1);
    }

    public static boolean check(IClasspathEntry cpe) {
        IPath p;
        return cpe.getEntryKind() == 5 && (p = cpe.getPath()).segmentCount() >= 1 && p.segment(0).equals(CONTAINER_ID);
    }

    private static String resource(String key, String arg) {
        return WebMessages.getResourceString(key, new String[]{arg});
    }
}

