/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.deployables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.internal.deployables.LooseArchiveDeployable;
import org.eclipse.jst.j2ee.internal.deployables.LooseArchiveDeployableFactory;
import org.eclipse.jst.server.core.ILooseArchive;
import org.eclipse.jst.server.core.ILooseArchiveSupport;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.web.internal.operation.ILibModule;

public class J2EEFlexProjWebDeployable
extends J2EEFlexProjDeployable
implements IWebModule,
ILooseArchiveSupport,
IModuleType {
    protected String contextRoot;
    protected ILooseArchive[] archives;
    public IPath rootfolder = null;
    protected Map uris = new HashMap();
    public static final String WEB_MODULE_TYPE = "jst.web";

    public J2EEFlexProjWebDeployable(IProject project, String aFactoryId, IVirtualComponent aComponent) {
        super(project, aFactoryId, aComponent);
        this.contextRoot = this.getUncachedContextRoot();
    }

    public String getId() {
        return this.getProject().getName();
    }

    public String getContextRoot() {
        Properties props = this.component.getMetaProperties();
        if (props.containsKey("context-root")) {
            return props.getProperty("context-root");
        }
        return this.component.getName();
    }

    public String getUncachedContextRoot() {
        return this.project.getName();
    }

    public String getJ2EESpecificationVersion() {
        if (this.component != null) {
            return J2EEVersionUtil.convertVersionIntToString((int)J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)this.component.getVersion()));
        }
        return null;
    }

    public String getJSPFileMapping(String jspFile) {
        return null;
    }

    public String getJSPSpecificationVersion() {
        String ret = "1.2";
        String stringVersion = this.getServletSpecificationVersion();
        int nVersion = J2EEVersionUtil.convertVersionStringToInt((String)stringVersion);
        switch (nVersion) {
            case 22: {
                ret = "1.1";
                break;
            }
            case 23: {
                ret = "1.2";
                break;
            }
            case 24: {
                ret = "2.0";
                break;
            }
            default: {
                ret = "1.1";
            }
        }
        return ret;
    }

    public String getServletSpecificationVersion() {
        if (this.component != null) {
            return this.component.getVersion();
        }
        return null;
    }

    public String getServletMapping(String className) {
        return null;
    }

    public boolean isPublishRequired() {
        return false;
    }

    protected LooseArchiveDeployableFactory getLooseArchiveDeployableFactory() {
        return null;
    }

    protected ILibModule[] getLibModules() {
        return null;
    }

    public ILooseArchive[] getUncachedLooseArchives() {
        ILibModule[] libModules = this.getLibModules();
        if (libModules == null) {
            return null;
        }
        LooseArchiveDeployableFactory fact = this.getLooseArchiveDeployableFactory();
        if (fact == null) {
            return null;
        }
        ArrayList arcs = new ArrayList(libModules.length);
        int i = 0;
        while (i < libModules.length) {
            ILibModule libModule = libModules[i];
            libModule.getProject();
            ++i;
        }
        ILooseArchive[] result = new ILooseArchive[arcs.size()];
        arcs.toArray(result);
        return result;
    }

    public String getURI(ILooseArchive jar) {
        try {
            return (String)this.uris.get(jar);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getUncachedURI(ILooseArchive jar) {
        if (!(jar instanceof LooseArchiveDeployable)) {
            return null;
        }
        LooseArchiveDeployable dep = (LooseArchiveDeployable)jar;
        IProject proj = dep.getProject();
        return this.getURI(proj);
    }

    protected String getURI(IProject looseJARProject) {
        return null;
    }

    public boolean isBinary() {
        return false;
    }

    protected void update() {
        Object[] oldArchives = this.archives;
        this.archives = this.getUncachedLooseArchives();
        if (this.archives == null) {
            this.archives = new ILooseArchive[0];
        }
        String oldContextRoot = this.contextRoot;
        this.contextRoot = this.getUncachedContextRoot();
        boolean changed = false;
        if (oldContextRoot == null && this.contextRoot != null) {
            changed = true;
        } else if (oldContextRoot != null && !oldContextRoot.equals(this.contextRoot)) {
            changed = true;
        }
        ArrayList add = new ArrayList(2);
        J2EEFlexProjWebDeployable.addRemovedObjects(add, oldArchives, this.archives);
        ArrayList remove = new ArrayList(2);
        J2EEFlexProjWebDeployable.addAddedObjects(remove, oldArchives, this.archives);
        int size = this.archives.length;
        ArrayList<ILooseArchive> change = new ArrayList<ILooseArchive>(size);
        int i = 0;
        while (i < size) {
            String newURI = this.getUncachedURI(this.archives[i]);
            String oldURI = this.getURI(this.archives[i]);
            if (oldURI != null && !oldURI.equals(newURI)) {
                change.add(this.archives[i]);
            }
            this.uris.put(this.archives[i], newURI);
            ++i;
        }
        if (!add.isEmpty() || !remove.isEmpty() || !change.isEmpty() || changed) {
            IModule[] added = new IModule[add.size()];
            add.toArray(added);
            IModule[] changed2 = new IModule[change.size()];
            change.toArray(changed2);
            IModule[] removed = new IModule[remove.size()];
            remove.toArray(removed);
        }
    }

    protected static void addAddedObjects(List list, Object[] a, Object[] b) {
        if (b == null) {
            return;
        }
        if (a == null) {
            int size = b.length;
            int i = 0;
            while (i < size) {
                list.add(b[i]);
                ++i;
            }
            return;
        }
        int size = b.length;
        int i = 0;
        while (i < size) {
            Object obj = b[i];
            boolean found = false;
            if (a != null) {
                int size2 = a.length;
                int j = 0;
                while (!found && j < size2) {
                    if (obj != null && obj.equals(a[j])) {
                        found = true;
                    }
                    ++j;
                }
            }
            if (!found) {
                list.add(obj);
            }
            ++i;
        }
    }

    protected static void addRemovedObjects(List list, Object[] a, Object[] b) {
        if (a == null) {
            return;
        }
        if (b == null) {
            int size = a.length;
            int i = 0;
            while (i < size) {
                list.add(a[i]);
                ++i;
            }
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            Object obj = a[i];
            boolean found = false;
            if (b != null) {
                int size2 = b.length;
                int j = 0;
                while (!found && j < size2) {
                    if (obj != null && obj.equals(b[j])) {
                        found = true;
                    }
                    ++j;
                }
            }
            if (!found) {
                list.add(obj);
            }
            ++i;
        }
    }

    public String getType() {
        return "j2ee.web";
    }

    public String getVersion() {
        return "1.2";
    }

    public IModule[] getChildModules() {
        ArrayList<ILooseArchive> list = new ArrayList<ILooseArchive>();
        if (this.archives != null) {
            int size = this.archives.length;
            int i = 0;
            while (i < size) {
                list.add(this.archives[i]);
                ++i;
            }
        }
        IModule[] children = new IModule[list.size()];
        list.toArray(children);
        return children;
    }

    public String getModuleTypeName() {
        return this.getName();
    }

    public String getModuleTypeVersion() {
        return this.getVersion();
    }

    public IModule[] getLooseArchives() {
        return null;
    }
}

