/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.web.operations.WebPropertiesUtil;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;

public class WebContentResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta());
    }

    private void processDelta(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
                int i = 0;
                while (i < affectedChildren.length) {
                    this.processDelta(affectedChildren[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                return;
            }
            default: {
                return;
            }
        }
    }

    private void processWebProject(IResourceDelta delta, IProject project) {
        IResourceDelta[] removedChildren;
        IResourceDelta[] changedChildren = delta.getAffectedChildren(4);
        if (changedChildren.length == 1) {
            WebPropertiesUtil.synch(project, (IProgressMonitor)new NullProgressMonitor());
        }
        if ((removedChildren = delta.getAffectedChildren(2)).length != 1 || !removedChildren[0].getResource().equals((Object)this.getModuleServerRoot(project))) {
            return;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        if (addedChildren.length != 1) {
            return;
        }
        IPath newPath = addedChildren[0].getProjectRelativePath();
        if (newPath.segmentCount() != 1) {
            return;
        }
        String newName = newPath.segment(0);
        try {
            WebPropertiesUtil.updateWebContentNamePropertiesOnly(project, newName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    protected IResource getModuleServerRoot(IProject project) {
        IResource iResource;
        block2: {
            WebArtifactEdit webEdit = null;
            try {
                iResource = (IResource)webEdit.getDeploymentDescriptorResource();
                Object var3_4 = null;
                if (webEdit == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_5 = null;
                    if (webEdit == null) break block3;
                    webEdit.dispose();
                }
                throw throwable;
            }
            webEdit.dispose();
        }
        return iResource;
    }
}

