/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.taglib.registry;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.web.locator.JavaProjectTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibLocator;
import org.eclipse.jst.j2ee.internal.web.taglib.registry.AbstractTaglibRegistry;

public class JavaTaglibRegistry
extends AbstractTaglibRegistry {
    protected IPath classpathFilePath;

    public JavaTaglibRegistry(IProject project) {
        super(project);
    }

    protected void initialize() {
        this.locators = new ITaglibLocator[]{new JavaProjectTaglibLocator(this.project)};
    }

    protected boolean isWebXMLFile(IPath filePath) {
        return false;
    }

    protected IPath getClasspathFilePath() {
        if (this.classpathFilePath == null) {
            this.classpathFilePath = this.getProject().getFullPath().append(".classpath");
        }
        return this.classpathFilePath;
    }

    protected IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.getProject());
    }

    protected IResource getRefreshRoot() {
        try {
            return this.getProject().getWorkspace().getRoot().findMember(this.getJavaProject().getOutputLocation());
        }
        catch (JavaModelException javaModelException) {
            return this.getProject();
        }
    }

    protected boolean requiresFullUpdate(IResourceDelta delta) {
        return delta.getResource().getFullPath().equals((Object)this.getClasspathFilePath());
    }
}

