/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.internet.cache.internal.CachePlugin;
import org.eclipse.wst.internet.cache.internal.LicenseAcceptanceDialog;

public class LicenseRegistry {
    protected static Integer LICENSE_UNSPECIFIED = new Integer(0);
    protected static Integer LICENSE_AGREE = new Integer(1);
    protected static Integer LICENSE_DISAGREE = new Integer(2);
    protected static Integer LICENSE_DISAGREE_THIS_SESSION = new Integer(3);
    protected static final String _LOG_INFO_WTP_NO_USER_INTERACTION = "_LOG_INFO_WTP_NO_USER_INTERACTION";
    protected static final String WTP_NO_USER_INTERACTION_SYSTEM_PROP = CachePlugin.getResourceString("WTP_NO_USER_INTERACTION_SYSTEM_PROP");
    protected static LicenseRegistry instance = null;
    private boolean DO_NOT_PROMPT = false;
    protected Hashtable licenses = new Hashtable();

    protected LicenseRegistry() {
        if (System.getProperty(WTP_NO_USER_INTERACTION_SYSTEM_PROP, "false").equals("true")) {
            CachePlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.wst.internet.cache", 0, CachePlugin.getResourceString(_LOG_INFO_WTP_NO_USER_INTERACTION, WTP_NO_USER_INTERACTION_SYSTEM_PROP), null));
            this.DO_NOT_PROMPT = true;
        }
    }

    public static LicenseRegistry getInstance() {
        if (instance == null) {
            instance = new LicenseRegistry();
        }
        return instance;
    }

    public void addLicense(String url) {
        if (url != null && !this.licenses.containsKey(url)) {
            this.licenses.put(url, LICENSE_UNSPECIFIED);
        }
    }

    protected void agreeLicense(String url) {
        if (this.licenses.containsKey(url)) {
            this.licenses.put(url, LICENSE_AGREE);
        }
    }

    protected void disagreeLicense(String url) {
        if (this.licenses.containsKey(url)) {
            this.licenses.put(url, LICENSE_DISAGREE);
        }
    }

    private void disagreeLicenseThisSession(String url) {
        if (this.licenses.containsKey(url)) {
            this.licenses.put(url, LICENSE_DISAGREE_THIS_SESSION);
        }
    }

    public boolean hasLicenseBeenAccepted(String url, String licenseURL) {
        if (this.DO_NOT_PROMPT) {
            return true;
        }
        if (this.licenses.containsKey(licenseURL)) {
            Integer agreed = (Integer)this.licenses.get(licenseURL);
            if (agreed == LICENSE_AGREE) {
                return true;
            }
            if (agreed == LICENSE_DISAGREE) {
                if (!CachePlugin.getDefault().shouldPrompt()) {
                    return false;
                }
                this.licenses.put(licenseURL, LICENSE_DISAGREE_THIS_SESSION);
            } else if (agreed == LICENSE_DISAGREE_THIS_SESSION) {
                return false;
            }
            if (this.promptToAcceptLicense(url, licenseURL)) {
                this.agreeLicense(licenseURL);
                return true;
            }
            this.disagreeLicenseThisSession(licenseURL);
            return false;
        }
        return true;
    }

    protected boolean promptToAcceptLicense(final String url, final String licenseURL) {
        final Accepted accepted = new Accepted();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                accepted.accepted = LicenseAcceptanceDialog.promptForLicense(null, url, licenseURL);
            }
        });
        return accepted.accepted;
    }

    protected String[] getLicenses() {
        return this.licenses.keySet().toArray(new String[this.licenses.keySet().size()]);
    }

    protected Integer getLicenseState(String url) {
        return (Integer)this.licenses.get(url);
    }

    private class Accepted {
        public boolean accepted = false;

        Accepted() {
        }
    }
}

