/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.dtd.core.internal.validation.DTDValidationMessages;
import org.eclipse.wst.dtd.ui.internal.validation.DTDValidator;
import org.eclipse.wst.dtd.ui.internal.validation.ValidateDTDAction;

public class ValidateDTDActionDelegate
implements IActionDelegate {
    protected ISelection selection;

    public void run(IAction action) {
        try {
            Class<?> theClass = Class.forName("org.apache.xerces.xni.parser.XMLParserConfiguration", true, this.getClass().getClassLoader());
            if (theClass == null) {
                throw new Exception("Missing Xerces jars in plugin's 'jars' folder");
            }
            IFile fileResource = null;
            if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
                Object element = structuredSelection.getFirstElement();
                if (element instanceof IFile) {
                    fileResource = (IFile)element;
                } else {
                    return;
                }
            }
            ValidateDTDAction validateaction = new ValidateDTDAction(fileResource, true);
            validateaction.setValidator(new DTDValidator());
            validateaction.run();
        }
        catch (Exception exception) {
            String xercesLine1 = DTDValidationMessages.Missing_required_files_1;
            String xercesLine2 = DTDValidationMessages.Missing_required_files_2;
            String xercesLine3 = DTDValidationMessages.Missing_required_files_3;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)DTDValidationMessages.Missing_required_files_4, (String)(String.valueOf(xercesLine1) + xercesLine2 + xercesLine3));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

