/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.views.contentoutline;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.NodeList;
import org.eclipse.wst.dtd.core.internal.document.DTDModelImpl;
import org.eclipse.wst.dtd.core.internal.util.LabelValuePair;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;
import org.eclipse.wst.dtd.ui.internal.editor.DTDEditorPluginImageHelper;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddAttributeAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddAttributeListAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddCommentAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddElementAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddElementToContentModelAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddEntityAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddGroupToContentModelAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddNotationAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddParameterEntityReferenceAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.DeleteAction;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;

public class DTDContextMenuHelper {
    private AddAttributeAction addAttributeAction;
    private AddAttributeListAction addAttributeListAction;
    private AddCommentAction addCommentAction;
    private AddElementAction addElementAction;
    private AddElementToContentModelAction addElementToContentModelAction;
    private AddEntityAction addEntityAction;
    private AddGroupToContentModelAction addGroupToContentModelAction;
    private AddNotationAction addNotationAction;
    private AddParameterEntityReferenceAction addParameterEntityReferenceAction;
    private DeleteAction deleteAction;
    StructuredTextEditor fEditor;
    private IMenuListener fMenuListener;
    private IAction redoAction;
    private IAction undoAction;

    public DTDContextMenuHelper(StructuredTextEditor editor) {
        this.fEditor = editor;
        this.fMenuListener = new DTDMenuListener();
        this.addNotationAction = new AddNotationAction(editor, DTDUIMessages._UI_ACTION_ADD_DTD_NOTATION);
        this.addEntityAction = new AddEntityAction(editor, DTDUIMessages._UI_ACTION_ADD_DTD_ENTITY);
        this.addElementAction = new AddElementAction(editor, DTDUIMessages._UI_ACTION_ADD_DTD_ELEMENT);
        this.addCommentAction = new AddCommentAction(editor, DTDUIMessages._UI_ACTION_ADD_DTD_COMMENT);
        this.addParameterEntityReferenceAction = new AddParameterEntityReferenceAction(editor, DTDUIMessages._UI_ACTION_ADD_PARAM_ENTITY_REF);
        this.deleteAction = new DeleteAction(DTDUIMessages._UI_ACTION_DTD_DELETE);
        this.addAttributeAction = new AddAttributeAction(editor, DTDUIMessages._UI_ACTION_ADD_ATTRIBUTE);
        this.addAttributeListAction = new AddAttributeListAction(editor, DTDUIMessages._UI_ACTION_ADD_ATTRIBUTELIST);
        this.addGroupToContentModelAction = new AddGroupToContentModelAction(editor, DTDUIMessages._UI_ACTION_GROUP_ADD_GROUP);
        this.addElementToContentModelAction = new AddElementToContentModelAction(editor, DTDUIMessages._UI_ACTION_ADD_ELEMENT);
        this.addNotationAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Notation.gif"));
        this.addEntityAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Entity.gif"));
        this.addCommentAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Comment.gif"));
        this.addParameterEntityReferenceAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Entity_Reference.gif"));
        this.addElementAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_Element.gif"));
        this.addElementAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_Element.gif"));
        this.addElementAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_Element.gif"));
        this.addAttributeAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_Attribute.gif"));
        this.addAttributeAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_Attribute.gif"));
        this.addAttributeAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_Attribute.gif"));
        this.addAttributeListAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_Attribute.gif"));
        this.addAttributeListAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_Attribute.gif"));
        this.addAttributeListAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_Attribute.gif"));
        this.addGroupToContentModelAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_GroupToConModel.gif"));
        this.addGroupToContentModelAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_GroupToConModel.gif"));
        this.addGroupToContentModelAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_GroupToConModel.gif"));
        this.addElementToContentModelAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_ElementToConModel.gif"));
        this.addElementToContentModelAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_ElementToConModel.gif"));
        this.addElementToContentModelAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_ElementToConModel.gif"));
    }

    public void addActionItemsForSelection(Object selectedObject, IMenuManager menu) {
        if (this.undoAction == null) {
            this.undoAction = this.fEditor.getAction(ActionFactory.UNDO.getId());
            this.redoAction = this.fEditor.getAction(ActionFactory.REDO.getId());
        }
        menu.add(this.undoAction);
        menu.add(this.redoAction);
        menu.add((IContributionItem)new Separator());
        if (selectedObject instanceof NodeList) {
            NodeList folder = (NodeList)selectedObject;
            if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_TAG")) {
                menu.add((IAction)this.addNotationAction);
            } else if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG")) {
                menu.add((IAction)this.addEntityAction);
            } else if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG")) {
                LabelValuePair[] availableEntities = ((DTDModelImpl)this.fEditor.getModel()).createParmEntityContentItems(null);
                this.addParameterEntityReferenceAction.setEnabled(availableEntities.length > 0);
                menu.add((IAction)this.addElementAction);
                menu.add((IAction)this.addParameterEntityReferenceAction);
            } else if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG")) {
                menu.add((IAction)this.addAttributeAction);
            }
        }
        if (selectedObject instanceof DTDFile || selectedObject == null) {
            LabelValuePair[] availableEntities = ((DTDModelImpl)this.fEditor.getModel()).createParmEntityContentItems(null);
            this.addParameterEntityReferenceAction.setEnabled(availableEntities.length > 0);
            menu.add((IAction)this.addElementAction);
            menu.add((IAction)this.addEntityAction);
            menu.add((IAction)this.addNotationAction);
            menu.add((IAction)this.addParameterEntityReferenceAction);
            menu.add((IAction)this.addCommentAction);
            menu.add((IAction)this.addAttributeListAction);
            menu.add((IContributionItem)new Separator());
        }
        if (selectedObject instanceof Element) {
            Element dtdElement = (Element)selectedObject;
            if (dtdElement.getContentModel() == null) {
                menu.add((IAction)this.addGroupToContentModelAction);
                menu.add((IAction)this.addElementToContentModelAction);
            }
            menu.add((IAction)this.addAttributeAction);
        } else if (selectedObject instanceof CMGroupNode) {
            menu.add((IAction)this.addElementToContentModelAction);
            menu.add((IAction)this.addGroupToContentModelAction);
        } else if (selectedObject instanceof AttributeList) {
            menu.add((IAction)this.addAttributeAction);
        }
        menu.add((IContributionItem)new Separator());
        this.addEditActions(menu);
        menu.add((IContributionItem)new Separator());
        if (!(!(selectedObject instanceof DTDNode) || selectedObject instanceof CMNode && ((CMNode)selectedObject).isRootElementContent())) {
            menu.add((IAction)this.deleteAction);
            this.deleteAction.setEnabled(true);
        }
    }

    public void addEditActions(IMenuManager menu) {
    }

    public void createMenuListenersFor(Viewer viewer) {
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addNotationAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addEntityAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addElementAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addCommentAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addParameterEntityReferenceAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addAttributeAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addAttributeListAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addGroupToContentModelAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.addElementToContentModelAction);
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        this.addNotationAction.selectionChanged(selection);
        this.addEntityAction.selectionChanged(selection);
        this.addElementAction.selectionChanged(selection);
        this.addParameterEntityReferenceAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
        this.addAttributeAction.selectionChanged(selection);
        this.addAttributeListAction.selectionChanged(selection);
        this.addGroupToContentModelAction.selectionChanged(selection);
        this.addElementToContentModelAction.selectionChanged(selection);
    }

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public IMenuListener getMenuListener() {
        return this.fMenuListener;
    }

    public void removeMenuListenersFor(Viewer viewer) {
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addNotationAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addEntityAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addElementAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addCommentAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addParameterEntityReferenceAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addAttributeAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addAttributeListAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addGroupToContentModelAction);
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this.addElementToContentModelAction);
    }

    public void updateActions() {
    }

    public void updateEditActions(IActionBars actionBars) {
    }

    class DTDMenuListener
    implements IMenuListener {
        static /* synthetic */ Class class$0;

        DTDMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            IContentOutlinePage outline;
            ISelection selection;
            DTDContextMenuHelper.this.updateActions();
            Object node = null;
            StructuredTextEditor structuredTextEditor = DTDContextMenuHelper.this.fEditor;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((selection = (outline = (IContentOutlinePage)structuredTextEditor.getAdapter((Class)clazz)).getSelection()) instanceof IStructuredSelection) {
                node = ((IStructuredSelection)selection).getFirstElement();
            }
            if (node == null && selection instanceof ITextSelection) {
                node = DTDContextMenuHelper.this.fEditor.getModel().getIndexedRegion(((ITextSelection)selection).getOffset());
            }
            if (node != null) {
                DTDContextMenuHelper.this.addActionItemsForSelection(node, manager);
            }
        }
    }
}

