/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.AbstractRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContributedClasspathEntriesEntry
extends AbstractRuntimeClasspathEntry {
    public static final String TYPE_ID = "org.eclipse.ant.ui.classpathentry.extraClasspathEntries";
    public static List fgSWTEntries = null;

    protected void buildMemento(Document document, Element memento) throws CoreException {
    }

    public void initializeFrom(Element memento) throws CoreException {
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public IRuntimeClasspathEntry[] getRuntimeClasspathEntries(ILaunchConfiguration configuration) throws CoreException {
        IAntClasspathEntry entry;
        boolean separateVM = AntUtil.isSeparateJREAntBuild(configuration);
        boolean setInputHandler = configuration.getAttribute("org.eclipse.ant.uiSET_INPUTHANDLER", true);
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        IAntClasspathEntry[] antClasspathEntries = prefs.getContributedClasspathEntries();
        IAntClasspathEntry[] userEntries = prefs.getAdditionalClasspathEntries();
        ArrayList<IRuntimeClasspathEntry> rtes = new ArrayList<IRuntimeClasspathEntry>(antClasspathEntries.length + userEntries.length);
        int i = 0;
        while (i < antClasspathEntries.length) {
            entry = antClasspathEntries[i];
            if (!separateVM || separateVM && !entry.isEclipseRuntimeRequired()) {
                rtes.add(JavaRuntime.newStringVariableClasspathEntry((String)entry.getLabel()));
            }
            ++i;
        }
        boolean haveToolsEntry = false;
        int i2 = 0;
        while (i2 < userEntries.length) {
            entry = userEntries[i2];
            String path = entry.getLabel();
            if (path.endsWith("tools.jar")) {
                haveToolsEntry = true;
                this.addToolsJar(configuration, rtes, path);
            } else {
                rtes.add(JavaRuntime.newStringVariableClasspathEntry((String)path));
            }
            ++i2;
        }
        if (!haveToolsEntry) {
            this.addToolsJar(configuration, rtes, null);
        }
        if (setInputHandler && separateVM) {
            this.addSWTJars(rtes);
        }
        return rtes.toArray(new IRuntimeClasspathEntry[rtes.size()]);
    }

    private void addToolsJar(ILaunchConfiguration configuration, List rtes, String path) {
        IRuntimeClasspathEntry tools = this.getToolsJar(configuration);
        if (tools == null) {
            if (path != null) {
                rtes.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(path)));
            } else {
                IAntClasspathEntry entry;
                IVMInstall install = JavaRuntime.getDefaultVMInstall();
                if (install != null && (entry = AntCorePlugin.getPlugin().getPreferences().getToolsJarEntry((IPath)new Path(install.getInstallLocation().getAbsolutePath()))) != null) {
                    rtes.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(entry.getEntryURL().getPath())));
                }
            }
        } else {
            rtes.add(tools);
        }
    }

    private void addSWTJars(List rtes) {
        if (fgSWTEntries == null) {
            fgSWTEntries = new ArrayList();
            Bundle bundle = Platform.getBundle((String)"org.eclipse.swt");
            BundleDescription description = Platform.getPlatformAdmin().getState(false).getBundle(bundle.getBundleId());
            BundleDescription[] fragments = description.getFragments();
            int i = 0;
            while (i < fragments.length) {
                block11: {
                    Path fragmentPath;
                    String urlFileName;
                    block12: {
                        URL bundleURL;
                        Bundle fragmentBundle = Platform.getBundle((String)fragments[i].getName());
                        try {
                            bundleURL = Platform.resolve((URL)fragmentBundle.getEntry("/"));
                        }
                        catch (IOException e) {
                            AntUIPlugin.log(e);
                            break block11;
                        }
                        urlFileName = bundleURL.getFile();
                        if (urlFileName.startsWith("file:")) {
                            try {
                                urlFileName = new URL(urlFileName).getFile();
                                if (!urlFileName.endsWith("!/")) break block12;
                                urlFileName = urlFileName.substring(0, urlFileName.length() - 2);
                            }
                            catch (MalformedURLException e) {
                                AntUIPlugin.log(e);
                                break block11;
                            }
                        }
                    }
                    if ((fragmentPath = new Path(urlFileName)).getFileExtension() != null) {
                        fgSWTEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)fragmentPath));
                    } else {
                        File bundleFolder = fragmentPath.toFile();
                        if (bundleFolder.isDirectory()) {
                            String[] names = bundleFolder.list(new FilenameFilter(){

                                public boolean accept(File dir, String name) {
                                    return name.endsWith(".jar");
                                }
                            });
                            int j = 0;
                            while (j < names.length) {
                                String jarName = names[j];
                                fgSWTEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)fragmentPath.append(jarName)));
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        rtes.addAll(fgSWTEntries);
    }

    private IRuntimeClasspathEntry getToolsJar(ILaunchConfiguration configuration) {
        try {
            IAntClasspathEntry entry;
            IVMInstall install = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
            if (install != null && (entry = AntCorePlugin.getPlugin().getPreferences().getToolsJarEntry((IPath)new Path(install.getInstallLocation().getAbsolutePath()))) != null) {
                return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(entry.getEntryURL().getPath()));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public String getName() {
        return AntLaunchConfigurationMessages.ContributedClasspathEntriesEntry_1;
    }

    public int getType() {
        return 5;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof ContributedClasspathEntriesEntry;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

