/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPCompletionProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JavaParameterListValidator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.sse.ui.internal.contentassist.IResourceDependentProcessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;

public class JSPJavaContentAssistProcessor
implements IContentAssistProcessor,
IResourceDependentProcessor,
IReleasable {
    protected IResource fResource;
    protected char[] completionProposalAutoActivationCharacters = new char[]{'.'};
    protected char[] contextInformationAutoActivationCharacters = null;
    protected static final String UNKNOWN_CONTEXT = JSPUIMessages.Content_Assist_not_availab_UI_;
    protected String fErrorMessage = null;
    protected JSPCompletionProcessor fJspCompletionProcessor = null;

    public JSPJavaContentAssistProcessor() {
    }

    public JSPJavaContentAssistProcessor(IResource file) {
        this.fResource = file;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentPosition) {
        ITextRegionList v;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((StructuredTextViewer)((StructuredTextViewer)viewer), (int)documentPosition);
        this.fJspCompletionProcessor = this.getJspCompletionProcessor();
        ICompletionProposal[] results = this.fJspCompletionProcessor.computeCompletionProposals(viewer, documentPosition);
        this.fErrorMessage = this.fJspCompletionProcessor.getErrorMessage();
        if (results.length == 0 && (this.fErrorMessage == null || this.fErrorMessage.length() == 0)) {
            this.fErrorMessage = UNKNOWN_CONTEXT;
        }
        IDOMNode xNode = null;
        IStructuredDocumentRegion flat = null;
        if (treeNode instanceof IDOMNode && (flat = (xNode = (IDOMNode)treeNode).getFirstStructuredDocumentRegion()) != null && flat.getType() == "JSP_CONTENT") {
            flat = flat.getPrevious();
        }
        ITextRegion openRegion = null;
        if (flat != null && flat instanceof ITextRegionContainer && (v = ((ITextRegionContainer)flat).getRegions()).size() > 0) {
            openRegion = v.get(0);
        }
        if (flat != null && flat.getType() != "JSP_SCRIPTLET_OPEN" && flat.getType() != "JSP_DECLARATION_OPEN" && flat.getType() != "JSP_EXPRESSION_OPEN" && flat.getType() != "BLOCK_TEXT" && openRegion != null && openRegion.getType() != "JSP_DIRECTIVE_OPEN" && !this.inAttributeRegion(flat, documentPosition)) {
            int adjustedDocPosition = documentPosition;
            int realCaretPosition = viewer.getTextWidget().getCaretOffset();
            int selectionLength = viewer.getSelectedRange().y;
            if (documentPosition > realCaretPosition) {
                adjustedDocPosition -= selectionLength;
            }
            CustomCompletionProposal cdataProposal = this.createCDATAProposal(adjustedDocPosition, selectionLength);
            ICompletionProposal[] newResults = new ICompletionProposal[results.length + 1];
            System.arraycopy(results, 0, newResults, 0, results.length);
            newResults[results.length] = cdataProposal;
            results = newResults;
        }
        return results;
    }

    private CustomCompletionProposal createCDATAProposal(int adjustedDocPosition, int selectionLength) {
        return new CustomCompletionProposal("<![CDATA[]]>", adjustedDocPosition, selectionLength, 9, SharedXMLEditorPluginImageHelper.getImage((String)"icons/full/obj16/cdatasection.gif"), "CDATA Section", null, null, 400);
    }

    private boolean inAttributeRegion(IStructuredDocumentRegion flat, int documentPosition) {
        ITextRegion attrContainer = flat.getRegionAtCharacterOffset(documentPosition);
        return attrContainer != null && attrContainer instanceof ITextRegionContainer && attrContainer.getType() == "XML_TAG_ATTRIBUTE_VALUE";
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.contextInformationAutoActivationCharacters;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void release() {
        if (this.fJspCompletionProcessor != null) {
            this.fJspCompletionProcessor.release();
            this.fJspCompletionProcessor = null;
        }
        this.fResource = null;
    }

    public void initialize(IResource resource) {
        this.fResource = resource;
        this.getJspCompletionProcessor().initialize(resource);
    }

    protected JSPCompletionProcessor getJspCompletionProcessor() {
        if (this.fJspCompletionProcessor == null) {
            this.fJspCompletionProcessor = new JSPCompletionProcessor(this.fResource);
            this.fJspCompletionProcessor.initialize(this.fResource);
        }
        return this.fJspCompletionProcessor;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        ArrayList<IContextInformation> results = new ArrayList<IContextInformation>();
        IDocumentPartitioner dp = viewer.getDocument().getDocumentPartitioner();
        String type = dp.getPartition(documentOffset).getType();
        if (type == "org.eclipse.jst.jsp.DEFAULT_JSP" || type == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            ICompletionProposal[] proposals = this.computeCompletionProposals(viewer, documentOffset);
            int i = 0;
            while (i < proposals.length) {
                IContextInformation ci = proposals[i].getContextInformation();
                if (ci != null) {
                    results.add(ci);
                }
                ++i;
            }
        }
        return results.toArray(new IContextInformation[results.size()]);
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new JavaParameterListValidator();
    }
}

