/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.java.refactoring.JSPJavaSelectionProvider;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public class JSPMoveElementAction
extends TextEditorAction {
    public JSPMoveElementAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public boolean isEnabled() {
        return true;
    }

    public void update() {
        super.update();
        PlatformStatusLineUtil.clearStatusLine();
    }

    private IJavaElement[] getSelectedElements() {
        IJavaElement[] elements = new IJavaElement[]{};
        if (this.getTextEditor() != null) {
            elements = JSPJavaSelectionProvider.getSelection(this.getTextEditor());
        }
        return elements;
    }

    private IResource[] getResources(IJavaElement[] elements) {
        IResource[] resources = new IResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            try {
                resources[i] = elements[i].getPrimaryElement().getCorrespondingResource();
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
            ++i;
        }
        return resources;
    }

    public void run() {
        IJavaElement[] elements = this.getSelectedElements();
        if (elements.length > 0) {
            try {
                JavaMoveProcessor processor = JavaMoveProcessor.create((IResource[])this.getResources(elements), (IJavaElement[])elements);
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
                RefactoringWizard wizard = this.createWizard(refactoring);
                processor.setCreateTargetQueries((ICreateTargetQueries)new CreateTargetQueries((Wizard)wizard));
                processor.setReorgQueries((IReorgQueries)new ReorgQueries((Wizard)wizard));
                String openRefactoringWizMsg = JSPUIMessages.MoveElementWizard;
                new RefactoringStarter().activate((Refactoring)refactoring, wizard, parent, openRefactoringWizMsg, true);
                PlatformStatusLineUtil.clearStatusLine();
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
        } else {
            PlatformStatusLineUtil.displayErrorMessage((String)JSPUIMessages.JSPMoveElementAction_0);
        }
    }

    public static CodeGenerationSettings getCodeGenerationSettings() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.createComments = store.getBoolean("org.eclipse.jdt.ui.javadoc");
        res.useKeywordThis = store.getBoolean("org.eclipse.jdt.ui.keywordthis");
        res.importOrder = JSPMoveElementAction.getImportOrderPreference(store);
        res.importThreshold = JSPMoveElementAction.getImportNumberThreshold(store);
        res.tabWidth = CodeFormatterUtil.getTabWidth();
        return res;
    }

    public static int getImportNumberThreshold(IPreferenceStore prefs) {
        int threshold = prefs.getInt("org.eclipse.jdt.ui.ondemandthreshold");
        if (threshold < 0) {
            threshold = Integer.MAX_VALUE;
        }
        return threshold;
    }

    public static String[] getImportOrderPreference(IPreferenceStore prefs) {
        String str = prefs.getString("org.eclipse.jdt.ui.importorder");
        if (str != null) {
            return JSPMoveElementAction.unpackList(str, ";");
        }
        return new String[0];
    }

    private static String[] unpackList(String str, String separator) {
        StringTokenizer tok = new StringTokenizer(str, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < nTokens) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    private RefactoringWizard createWizard(MoveRefactoring refactoring) {
        return new ReorgMoveWizard(refactoring);
    }
}

