/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.StringTokenizer;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BP2202
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private boolean importFound = false;
    private final char[] OMMITED_XML_DECLARATION_DELIMITERS = new char[]{' ', '\t', '\r', '\n', '\'', '\"'};
    private final char[] XML_DECLARATION_DELIMITERS = new char[]{'='};
    private final String UTF_8_ENCODING = "UTF-8";
    private final String UTF_16_ENCODING = "UTF-16";
    private final String ENCODING_TOKEN = "encoding";
    private final String VERSION_TOKEN = "version";

    public BP2202(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "notApplicable";
        this.result = "notApplicable";
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        List exts = null;
        if (types != null) {
            exts = types.getExtensibilityElements();
        }
        if (exts != null) {
            Definition definition = null;
            definition = this.validator.analyzerContext.getCandidateInfo().getDefinition(types);
            if (definition == null) {
                throw new WSIException("Could not find types definition in any WSDL document.");
            }
            Iterator it = exts.iterator();
            while (it.hasNext()) {
                ExtensibilityElement el = (ExtensibilityElement)it.next();
                if (!(el instanceof UnknownExtensibilityElement) || !el.getElementType().equals(ELEM_XSD_SCHEMA)) continue;
                this.searchForSchema(((UnknownExtensibilityElement)el).getElement(), definition.getDocumentBaseURI());
            }
        }
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.importFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void searchForSchema(Node n, String context) {
        while (n != null) {
            if (1 == n.getNodeType()) {
                if (XMLUtils.equals(n, ELEM_XSD_SCHEMA)) {
                    this.processSchema(n, context);
                } else if (XMLUtils.equals(n, ELEM_XSD_IMPORT)) {
                    this.importFound = true;
                    this.loadSchema(n, context);
                } else {
                    this.searchForSchema(n.getFirstChild(), context);
                }
            }
            n = n.getNextSibling();
        }
    }

    private void loadSchema(Node importNode, String context) {
        Element im = (Element)importNode;
        Attr schemaLocation = XMLUtils.getAttribute(im, ATTR_XSD_SCHEMALOCATION);
        if (schemaLocation != null && schemaLocation.getValue() != null) {
            try {
                Document schema;
                String decl = this.readXMLDeclarationStatement(schemaLocation.getValue(), context);
                if (!this.validDeclaration(decl, "encoding", new String[]{"UTF-8", "UTF-16"})) {
                    Attr a = XMLUtils.getAttribute(im, ATTR_XSD_NAMESPACE);
                    this.errors.add(a != null ? a.getValue() : "");
                }
                if (!this.validDeclaration(decl, "version", new String[]{"1.0"})) {
                    this.errors.add("Version number in XML declaration is not 1.0.  XML schema file: " + schemaLocation.getValue());
                }
                if (XMLUtils.equals((schema = this.validator.parseXMLDocumentURL(schemaLocation.getValue(), context)).getDocumentElement(), ELEM_XSD_SCHEMA)) {
                    Attr a = XMLUtils.getAttribute(im, ATTR_XSD_NAMESPACE);
                    String string = a != null ? a.getValue() : "";
                    this.processSchema(schema.getDocumentElement(), XMLUtils.createURLString(schemaLocation.getValue(), context));
                }
                this.result = "passed";
                this.result = "passed";
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * Exception decompiling
     */
    private String readXMLDeclarationStatement(String location, String baseURI) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 309->312)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean validEncoding(String xmlDecl) {
        boolean result = true;
        if (xmlDecl != null) {
            StringTokenizer st = new StringTokenizer(this.OMMITED_XML_DECLARATION_DELIMITERS, this.XML_DECLARATION_DELIMITERS);
            Enumeration tokens = st.parse(xmlDecl);
            boolean found = false;
            while (tokens.hasMoreElements() && !found) {
                String token = (String)tokens.nextElement();
                if (!token.equals("encoding")) continue;
                found = true;
                tokens.nextElement();
                String enc = (String)tokens.nextElement();
                boolean bl = result = "UTF-8".equalsIgnoreCase(enc) || "UTF-16".equalsIgnoreCase(enc);
            }
        }
        return result;
    }

    private boolean validDeclaration(String xmlDecl, String tokenName, String[] checkValueList) {
        boolean result = true;
        if (xmlDecl != null) {
            StringTokenizer st = new StringTokenizer(this.OMMITED_XML_DECLARATION_DELIMITERS, this.XML_DECLARATION_DELIMITERS);
            Enumeration tokens = st.parse(xmlDecl);
            if (tokens.hasMoreElements()) {
                boolean found = false;
                while (tokens.hasMoreElements() && !found) {
                    String token = (String)tokens.nextElement();
                    if (!token.equals(tokenName)) continue;
                    found = true;
                    result = false;
                    tokens.nextElement();
                    String tokenValue = (String)tokens.nextElement();
                    int i = 0;
                    while (i < checkValueList.length && !result) {
                        if (checkValueList[i].equalsIgnoreCase(tokenValue)) {
                            result = true;
                        }
                        ++i;
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private void processSchema(Node schema, String context) {
        Node n = schema.getFirstChild();
        while (n != null) {
            if (1 == n.getNodeType() && XMLUtils.equals(n, ELEM_XSD_IMPORT)) {
                this.importFound = true;
                this.loadSchema(n, context);
            }
            n = n.getNextSibling();
        }
    }
}

