/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl.xsd;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.FileEntityResolver;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.InlineSchemaGenerator;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.InlineXSDResolver;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.XMLCatalogResolver;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.XMLEntityResolverChain;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.XSDValidator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class InlineSchemaValidator {
    List elements = null;

    public Map validate(Object element, List parents, String filename) throws Exception {
        this.elements = new Vector();
        UnknownExtensibilityElement elem = (UnknownExtensibilityElement)element;
        Definition wsdlDefinition = (Definition)parents.get(parents.size() - 1);
        Element w3celement = elem.getElement();
        Hashtable parentnamespaces = this.getNamespaceDeclarationsFromParents(wsdlDefinition, w3celement);
        String targetNamespace = w3celement.getAttribute("targetNamespace");
        String xsd = InlineSchemaGenerator.createXSDString(w3celement, this.elements, filename, parentnamespaces);
        String namespace = w3celement.getNamespaceURI();
        if (namespace.equals("http://www.w3.org/1999/XMLSchema") || namespace.equals("http://www.w3.org/2000/10/XMLSchema")) {
            throw new Exception("An old version of the schema namespace is specified.");
        }
        XSDValidator schemav = new XSDValidator();
        InlineXSDResolver inlineEntityResolver = this.getEntityResolver(wsdlDefinition, (Types)parents.get(0), filename, targetNamespace);
        XMLEntityResolverChain entityResolverChain = new XMLEntityResolverChain();
        entityResolverChain.addEntityResolver(inlineEntityResolver);
        entityResolverChain.addEntityResolver(new FileEntityResolver());
        entityResolverChain.addEntityResolver(XMLCatalogResolver.getInstance());
        schemav.validateInlineSchema(xsd, targetNamespace, filename, entityResolverChain, inlineEntityResolver);
        if (InlineSchemaGenerator.soapEncodingRequiredNotImported(elem.getElement(), filename, parentnamespaces)) {
            throw new Exception("The inline schema uses an element or type from the SOAP encoding namespace but the namespace has not been imported. The SOAP encoding namespace should be imported with an import statement before it is used.");
        }
        if (!schemav.isValid()) {
            StringBuffer exception = new StringBuffer();
            Iterator i = schemav.getErrors().iterator();
            while (i.hasNext()) {
                exception.append(i.next()).append('\n');
            }
            throw new Exception(exception.toString());
        }
        HashMap<String, XSModel> map = new HashMap<String, XSModel>(1);
        map.put(targetNamespace, schemav.getXSModel());
        return map;
    }

    protected InlineXSDResolver getEntityResolver(Definition wsdlDefinition, Types types, String referenceLocation, String targetNamespace) {
        InlineXSDResolver entityResolver = new InlineXSDResolver();
        List schemas = types.getExtensibilityElements();
        if (schemas != null) {
            Iterator iSchemas = schemas.iterator();
            while (iSchemas.hasNext()) {
                UnknownExtensibilityElement extElem = (UnknownExtensibilityElement)iSchemas.next();
                String thisNamespace = extElem.getElement().getAttribute("targetNamespace");
                if (thisNamespace == null || thisNamespace.equalsIgnoreCase(targetNamespace)) continue;
                Element element = extElem.getElement();
                Hashtable parentnamespaces = this.getNamespaceDeclarationsFromParents(wsdlDefinition, element);
                String xsd = InlineSchemaGenerator.createXSDString(element, this.elements, referenceLocation, parentnamespaces);
                entityResolver.add(thisNamespace, xsd);
            }
        }
        return entityResolver;
    }

    protected Hashtable getNamespaceDeclarationsFromParents(Definition wsdlDefinition, Element element) {
        Hashtable<String, String> nss = new Hashtable<String, String>();
        Iterator nameSpaces = wsdlDefinition.getNamespaces().keySet().iterator();
        String XMLNS = "xmlns";
        while (nameSpaces.hasNext()) {
            String nsprefix = XMLNS;
            String ns = (String)nameSpaces.next();
            if (!ns.equalsIgnoreCase("")) {
                nsprefix = String.valueOf(nsprefix) + ":";
            }
            if (element.hasAttribute(String.valueOf(nsprefix) + ns)) continue;
            nss.put(String.valueOf(nsprefix) + ns, wsdlDefinition.getNamespace(ns));
        }
        NamedNodeMap atts = element.getParentNode().getAttributes();
        int attslength = atts.getLength();
        int i = 0;
        while (i < attslength) {
            Node tempnode = atts.item(i);
            String nodename = tempnode.getNodeName();
            if (nodename.indexOf(XMLNS) != -1) {
                nss.put(nodename, tempnode.getNodeValue());
            }
            ++i;
        }
        return nss;
    }

    public Object getObjectAtLine(int line) {
        if (line < 0 || line >= this.elements.size()) {
            line = 0;
        }
        return this.elements.get(line);
    }

    private String replaceNamespace(String message, String namespace) {
        String xsd2001 = "http://www.w3.org/2001/XMLSchema";
        int start = message.indexOf(xsd2001);
        int end = start + xsd2001.length();
        if (start < 0) {
            return message;
        }
        String startString = message.substring(0, start);
        String endString = message.substring(end, message.length());
        return String.valueOf(startString) + namespace + endString;
    }
}

