/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.eclipse;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalogEntityHolder;
import org.osgi.framework.Bundle;

class ExtXMLCatalogPluginRegistryReader {
    protected static final String PLUGIN_ID = "org.eclipse.wst.wsdl.validation";
    protected static final String EXTENSION_POINT_ID = "xmlcatalog";
    protected static final String EXT_CATALOG_TAG_NAME = "xmlcatalog";
    protected static final String ATT_CLASS = "class";
    protected static final String ENTITY_TAG_NAME = "entity";
    protected static final String ATT_PUBLIC_ID = "publicId";
    protected static final String ATT_SYSTEM_ID = "location";
    protected static final String SCHEMA_DIR_TAG_NAME = "schemadir";
    protected static final String ATT_LOCATION = "location";
    protected String pluginId;
    protected String extensionPointId;

    ExtXMLCatalogPluginRegistryReader() {
    }

    public void readRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint(PLUGIN_ID, "xmlcatalog");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        String location;
        String elementname = element.getName();
        if (elementname.equals("xmlcatalog")) {
            String xmlCatalogClass = element.getAttribute(ATT_CLASS);
            if (xmlCatalogClass != null) {
                try {
                    ClassLoader pluginLoader = element.getDeclaringExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
                    XMLCatalog.setExtensionXMLCatalog((String)xmlCatalogClass, (ClassLoader)pluginLoader);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        } else if (elementname.equals(ENTITY_TAG_NAME)) {
            String publicid = element.getAttribute(ATT_PUBLIC_ID);
            String systemid = element.getAttribute("location");
            if (publicid == null || systemid == null) {
                return;
            }
            Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
            systemid = this.getAbsoluteLocation(systemid, bundle);
            XMLCatalog.addEntity((XMLCatalogEntityHolder)new XMLCatalogEntityHolder(publicid, systemid));
        } else if (elementname.equals(SCHEMA_DIR_TAG_NAME) && (location = element.getAttribute("location")) != null) {
            Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
            location = this.getAbsoluteLocation(location, bundle);
            XMLCatalog.addSchemaDir((String)location);
        }
    }

    private String getAbsoluteLocation(String location, Bundle bundle) {
        URL url = null;
        if (bundle != null) {
            url = bundle.getEntry(location);
        }
        if (url != null) {
            try {
                url = Platform.resolve((URL)url);
                return url.toExternalForm();
            }
            catch (IOException iOException) {}
        }
        return location;
    }
}

