/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.views.DebugViewDecoratingLabelProvider;
import org.eclipse.debug.internal.ui.views.DebugViewInterimLabelProvider;
import org.eclipse.debug.internal.ui.views.DebugViewLabelDecorator;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewer;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.ide.StringMatcher;

public class FindVariableDialog
extends Dialog {
    private TableViewer fViewer;
    private VariablesView fView;
    private Text fText;
    private StringMatcher fMatcher;
    private int fTextLength;

    protected FindVariableDialog(Shell parentShell, VariablesView view) {
        super(parentShell);
        this.fView = view;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        label.setText(ActionMessages.FindVariableDialog_1);
        this.fText = new Text(composite, 2052);
        this.fText.setLayoutData((Object)new GridData(768));
        this.fText.setFont(parent.getFont());
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindVariableDialog.this.textModified();
            }
        });
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        label.setText(ActionMessages.FindVariableDialog_2);
        this.fViewer = new TableViewer(composite, 2820);
        Table table = this.fViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        table.setLayoutData((Object)gridData);
        table.setFont(parent.getFont());
        this.fViewer.setContentProvider((IContentProvider)new FindVariableContentProvider());
        this.fViewer.addFilter((ViewerFilter)new FindVariableFilter());
        this.fViewer.setInput(new Object());
        FindVariableModelPresentation presentation = new FindVariableModelPresentation();
        DebugViewDecoratingLabelProvider provider = new DebugViewDecoratingLabelProvider((StructuredViewer)this.fViewer, new DebugViewInterimLabelProvider(presentation), new DebugViewLabelDecorator(presentation));
        this.fViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FindVariableDialog.this.selectionChanged();
            }
        });
        return composite;
    }

    private void textModified() {
        Table table;
        StringBuffer text = new StringBuffer(this.fText.getText());
        if (text.length() == 0 || text.charAt(text.length() - 1) != '*') {
            text.append("*");
        }
        this.fMatcher = new StringMatcher(text.toString(), true, false);
        this.fTextLength = text.length();
        this.fViewer.refresh(false);
        if (((IStructuredSelection)this.fViewer.getSelection()).isEmpty() && (table = this.fViewer.getTable()).getItemCount() > 0) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(table.getItem(0).getData()));
            this.selectionChanged();
        }
    }

    private void selectionChanged() {
        this.fView.getViewer().setSelection(this.fViewer.getSelection(), true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(ActionMessages.FindVariableDialog_3);
        super.configureShell(newShell);
    }

    private class FindVariableContentProvider
    implements IStructuredContentProvider {
        FindVariableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getVariables(((VariablesViewer)FindVariableDialog.this.fView.getViewer()).getTree().getItems());
        }

        private IVariable[] getVariables(TreeItem[] items) {
            ArrayList variables = new ArrayList();
            this.getVariables(items, variables);
            return variables.toArray(new IVariable[variables.size()]);
        }

        private void getVariables(TreeItem[] items, List variables) {
            int i = 0;
            while (i < items.length) {
                Object data = items[i].getData();
                if (data instanceof IVariable) {
                    variables.add(data);
                }
                this.getVariables(items[i].getItems(), variables);
                ++i;
            }
        }
    }

    private class FindVariableFilter
    extends ViewerFilter {
        FindVariableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (FindVariableDialog.this.fMatcher == null) {
                return true;
            }
            try {
                String name = ((IVariable)element).getName();
                FindVariableDialog.this.fMatcher.match(name, 0, FindVariableDialog.this.fTextLength - 1);
                return FindVariableDialog.this.fMatcher.match(name);
            }
            catch (DebugException debugException) {
                return false;
            }
        }
    }

    private class FindVariableModelPresentation
    implements IDebugModelPresentation {
        FindVariableModelPresentation() {
        }

        public Image getImage(Object element) {
            IVariable variable = (IVariable)element;
            IDebugModelPresentation presentation = FindVariableDialog.this.fView.getPresentation(variable.getModelIdentifier());
            return presentation.getImage(element);
        }

        public String getText(Object element) {
            try {
                return ((IVariable)element).getName();
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e.getStatus());
                return ActionMessages.FindVariableDialog_0;
            }
        }

        public void setAttribute(String attribute, Object value) {
        }

        public void computeDetail(IValue value, IValueDetailListener listener) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public IEditorInput getEditorInput(Object element) {
            return null;
        }

        public String getEditorId(IEditorInput input, Object element) {
            return null;
        }
    }
}

