/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.IRemoteTreeViewerUpdateListener;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class VariablesViewer
extends RemoteTreeViewer {
    private ArrayList fUpdateListeners = new ArrayList();
    private StateRestorationJob fStateRestorationJob = new StateRestorationJob(DebugUIViewsMessages.RemoteTreeViewer_0);
    private VariablesView fView = null;

    public VariablesViewer(Composite parent, int style, VariablesView view) {
        super(parent, style);
        this.fView = view;
    }

    protected Item newItem(Widget parent, int style, int index) {
        Item item = super.newItem(parent, style, index);
        if (index != -1 && this.getSelection(this.getControl()).length == 0) {
            this.showItem(item);
        }
        return item;
    }

    public void setExpandedElements(Object[] elements) {
        this.getControl().setRedraw(false);
        super.setExpandedElements(elements);
        this.getControl().setRedraw(true);
    }

    protected void runDeferredUpdates() {
        super.runDeferredUpdates();
        this.fStateRestorationJob.schedule();
    }

    public void collapseAll() {
        if (this.getRoot() != null) {
            super.collapseAll();
        }
    }

    protected synchronized void restoreExpansionState() {
        this.cancelJobs();
        Iterator i = this.fUpdateListeners.iterator();
        while (i.hasNext()) {
            IRemoteTreeViewerUpdateListener listener = (IRemoteTreeViewerUpdateListener)i.next();
            listener.treeUpdated();
        }
    }

    public void addUpdateListener(IRemoteTreeViewerUpdateListener listener) {
        this.fUpdateListeners.add(listener);
    }

    public void removeUpdateListener(IRemoteTreeViewerUpdateListener listener) {
        this.fUpdateListeners.remove(listener);
    }

    public synchronized void replace(Object parent, Object[] children, int offset) {
        if (this.fView != null) {
            if (children.length == 1 && children[0] instanceof DebugException) {
                String message;
                IStatus status = ((DebugException)((Object)children[0])).getStatus();
                if (status != null && (message = status.getMessage()) != null) {
                    this.fView.showMessage(message);
                }
                return;
            }
            this.fView.showViewer();
        }
        super.replace(parent, children, offset);
    }

    private class StateRestorationJob
    extends UIJob {
        public StateRestorationJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            VariablesViewer.this.restoreExpansionState();
            return Status.OK_STATUS;
        }
    }
}

