/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.command;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class AddAxisJARToBuildPathCommand
extends SimpleCommand {
    private String pluginId_ = "org.eclipse.jst.ws.axis.consumption.ui";
    private MessageUtils msgUtils;
    private String jarPluginId = "org.apache.axis";
    private String jarPluginRelPath = "lib";
    private String jarName = "axis.jar";
    private IProject project;

    public Status execute(Environment environment) {
        IClasspathEntry[] oldClasspath;
        IJavaProject javaProject;
        this.msgUtils = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        SimpleStatus status = new SimpleStatus("");
        try {
            javaProject = JavaCore.create((IProject)this.project);
            if (javaProject == null) {
                SimpleStatus wStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_WARNING_NOT_COMPILE"), 2);
                return wStatus;
            }
            oldClasspath = javaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            SimpleStatus wStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_WARNING_NOT_COMPILE"), 2);
            return wStatus;
        }
        boolean found = false;
        int i = 0;
        while (i < oldClasspath.length) {
            found = found || oldClasspath[i].getPath().toString().toLowerCase().endsWith(this.jarName.toLowerCase());
            ++i;
        }
        if (found) {
            return status;
        }
        IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length + 1];
        i = 0;
        i = 0;
        while (i < oldClasspath.length) {
            newClasspath[i] = oldClasspath[i];
            ++i;
        }
        IClasspathEntry newEntry = this.getClasspathEntry();
        if (newEntry == null) {
            SimpleStatus wStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_WARNING_NOT_COMPILE"), 2);
            return wStatus;
        }
        newClasspath[i] = newEntry;
        try {
            javaProject.setRawClasspath(newClasspath, null);
        }
        catch (JavaModelException javaModelException) {
            SimpleStatus wStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_WARNING_NOT_COMPILE"), 2);
            return wStatus;
        }
        return status;
    }

    private IClasspathEntry getClasspathEntry() {
        try {
            IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
            IPluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor(this.jarPluginId);
            StringBuffer theJar = new StringBuffer();
            theJar.append(this.jarPluginRelPath);
            if (this.jarPluginRelPath.length() > 0) {
                theJar.append('/');
            }
            theJar.append(this.jarName);
            URL localURL = Platform.asLocalURL((URL)new URL(pluginDescriptor.getInstallURL(), theJar.toString()));
            Path jarPath = new Path(localURL.getFile());
            IClasspathEntry cpEntry = JavaCore.newLibraryEntry((IPath)jarPath, null, null);
            return cpEntry;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

