/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.provisional.env.core.context.TransientResourceContext;

public class CopyAxisJarCommand
extends SimpleCommand {
    public static String AXIS_RUNTIME_PLUGIN_ID = "org.apache.axis";
    public static String[] JARLIST = new String[]{"axis-ant.jar", "axis.jar", "commons-discovery-0.2.jar", "commons-logging-1.0.4.jar", "jaxrpc.jar", "log4j-1.2.8.jar", "saaj.jar", "wsdl4j-1.5.1.jar"};
    private String DESCRIPTION = "TASK_DESC_COPY_JARS_TO_PROJECT";
    private String LABEL = "TASK_LABEL_COPY_JARS_TO_PROJECT";
    private MessageUtils msgUtils_;
    private MessageUtils baseConMsgUtils_;
    private IProject project;
    private Boolean projectRestartRequired_ = Boolean.FALSE;
    private String moduleName_;

    public CopyAxisJarCommand(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.baseConMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.consumption.plugin", (Object)this);
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.moduleName_ = moduleName;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        env.getProgressMonitor().report(this.msgUtils_.getMessage("PROGRESS_INFO_COPY_AXIS_CFG"));
        this.copyAxisJarsToProject(this.project, (Status)status, env);
        return status;
    }

    private void copyAxisJarsToProject(IProject project, Status status, Environment env) {
        IPath webModulePath = J2EEUtils.getWebContentPath((IProject)project, (String)this.moduleName_);
        if (webModulePath == null) {
            status = new SimpleStatus("", this.baseConMsgUtils_.getMessage("MSG_ERROR_PROJECT_NOT_FOUND"), 4);
            env.getStatusHandler().reportError(status);
            return;
        }
        int i = 0;
        while (i < JARLIST.length) {
            this.copyIFile("lib/" + JARLIST[i], webModulePath, "WEB-INF/lib/" + JARLIST[i++], status, env);
            if (status.getSeverity() != 4) continue;
            return;
        }
    }

    private void copyIFile(String source, IPath targetPath, String targetFile, Status status, Environment env) {
        IPath target = targetPath.append((IPath)new Path(targetFile));
        env.getProgressMonitor().report(this.baseConMsgUtils_.getMessage("PROGRESS_INFO_COPYING_FILE"));
        try {
            TransientResourceContext context = new TransientResourceContext();
            context.setOverwriteFilesEnabled(true);
            context.setCreateFoldersEnabled(true);
            context.setCheckoutFilesEnabled(true);
            IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
            IPluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor(AXIS_RUNTIME_PLUGIN_ID);
            Plugin axisrt_plugin = pluginDescriptor.getPlugin();
            IFile resource = ResourceUtils.getWorkspaceRoot().getFile(target);
            if (!resource.exists()) {
                IFile file = FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)axisrt_plugin.openStream((IPath)new Path(source)), (ProgressMonitor)env.getProgressMonitor(), (StatusHandler)env.getStatusHandler());
                if (!this.projectRestartRequired_.booleanValue() && file.exists()) {
                    this.projectRestartRequired_ = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_FILECOPY"), 4, (Throwable)e);
            env.getStatusHandler().reportError(status);
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean getProjectRestartRequired() {
        return this.projectRestartRequired_;
    }
}

