/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.rdb.internal.derby.connection.DerbyShutdownService;
import org.osgi.framework.BundleContext;

public class DerbyPlugin
extends Plugin {
    private static DerbyPlugin plugin;
    protected DerbyShutdownService shutdownService;

    public DerbyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.shutdownService = new DerbyShutdownService();
        File dir = this.getStateLocation().append("sample").toFile();
        if (!dir.exists()) {
            String location = this.getBundle().getLocation();
            location = location.substring(location.indexOf(64) + 1);
            File f = new File(location);
            f = new File(f, "sample");
            try {
                this.copyDir(f, dir);
            }
            catch (Exception exception) {}
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownService.dispose();
        super.stop(context);
    }

    public static DerbyPlugin getDefault() {
        return plugin;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(File source, File dest) throws IOException {
        AbstractInterruptibleChannel out;
        block4: {
            FileChannel in = null;
            out = null;
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                long size = in.size();
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ((FileChannel)out).write(buf);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (in != null) {
                    in.close();
                }
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            {
                Object var8_9 = null;
                if (in == null) break block4;
            }
            in.close();
        }
        if (out == null) return;
        out.close();
    }

    private void copyDir(File source, File dest) throws IOException {
        dest.mkdir();
        File[] files = source.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            File target = new File(dest, file.getName());
            if (file.isDirectory()) {
                this.copyDir(file, target);
            } else {
                this.copyFile(file, target);
            }
            ++i;
        }
    }
}

