/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.sse.ui.internal.IExtendedContributor;
import org.eclipse.wst.sse.ui.internal.IExtendedEditorAction;
import org.eclipse.wst.sse.ui.internal.IExtendedSimpleEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.extension.ActionDescriptor;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;

public class ExtendedEditorActionBuilder
extends RegistryReader {
    public static final String ATT_ID = "id";
    public static final String ATT_LABEL = "label";
    public static final String ATT_NAME = "name";
    public static final String ATT_PATH = "path";
    public static final String ATT_TARGET_ID = "targetID";
    protected static final boolean debugContributeTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/extendededitoractionbuilder/contributetime"));
    protected static final boolean debugMenu = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/extendededitoractionbuilder/debugmenu"));
    protected static final boolean debugPopup = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/extendededitoractionbuilder/debugpopup"));
    protected static final boolean debugReadTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/extendededitoractionbuilder/readtime"));
    protected static final boolean debugToolbar = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/extendededitoractionbuilder/debugtoolbar"));
    private static final String EXTENDED_EDITOR = "extendedEditor";
    public static final String PL_EXTENDED_EDITOR_ACTIONS = "extendedEditorActions";
    public static final String PLUGIN_ID = "org.eclipse.wst.sse.ui";
    public static final String TAG_ACTION = "action";
    public static final String TAG_CONTRIBUTION_TYPE = "editorContribution";
    public static final String TAG_MENU = "menu";
    public static final String TAG_POPUPMENU = "popupmenu";
    public static final String TAG_RULERMENU = "rulermenu";
    public static final String TAG_SEPARATOR = "separator";
    protected List readingCache;
    protected String targetContributionTag;
    protected List targetIDs;

    protected void contributeMenu(IConfigurationElement menuElement, IMenuManager mng, boolean appendIfMissing) {
        IMenuManager newMenu;
        IContributionItem sep;
        String id = menuElement.getAttribute(ATT_ID);
        String label = menuElement.getAttribute(ATT_LABEL);
        String path = menuElement.getAttribute(ATT_PATH);
        if (label == null) {
            Logger.log(4, "Invalid Menu Extension (label == null): " + id);
            return;
        }
        String group = null;
        if (path != null) {
            int loc = path.lastIndexOf(47);
            if (loc != -1) {
                group = path.substring(loc + 1);
                path = path.substring(0, loc);
            } else {
                group = path;
                path = null;
            }
        }
        IMenuManager parent = mng;
        if (path != null) {
            parent = mng.findMenuUsingPath(path);
            if (parent == null) {
                return;
            }
            parent.setVisible(true);
        }
        if (group == null) {
            group = "additions";
        }
        if ((sep = parent.find(group)) == null) {
            if (appendIfMissing) {
                parent.add((IContributionItem)new Separator(group));
            } else {
                Logger.log(4, "Invalid Menu Extension (Group is invalid): " + id);
                return;
            }
        }
        if ((newMenu = parent.findMenuUsingPath(id)) == null) {
            newMenu = new MenuManager(label, id);
        }
        IConfigurationElement[] children = menuElement.getChildren(TAG_SEPARATOR);
        int i = 0;
        while (i < children.length) {
            this.contributeSeparator(newMenu, children[i]);
            ++i;
        }
        try {
            parent.insertAfter(group, (IContributionItem)newMenu);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.log(4, "Invalid Menu Extension (Group is missing): " + id);
        }
    }

    protected IMenuManager contributeMenuAction(ActionDescriptor ad, IMenuManager menu, boolean appendIfMissing, boolean popupmenu) {
        IContributionItem sep;
        IContributionItem item;
        String mgroup;
        if (ad.getContributionItem() == null || ad.getAction() == null) {
            return null;
        }
        String mpath = popupmenu ? ad.getPopupMenuPath() : ad.getMenuPath();
        String string = mgroup = popupmenu ? ad.getPopupMenuGroup() : ad.getMenuGroup();
        if (mpath == null && mgroup == null) {
            return null;
        }
        IMenuManager parent = menu;
        if (mpath != null) {
            if ((parent = parent.findMenuUsingPath(mpath)) == null) {
                return null;
            }
            parent.setVisible(true);
        }
        if ((item = parent.find(ad.getId())) != null) {
            parent.remove(ad.getId());
        }
        if (mgroup == null) {
            mgroup = "additions";
        }
        if ((sep = parent.find(mgroup)) == null) {
            if (appendIfMissing) {
                sep = new Separator(mgroup);
                parent.add(sep);
            } else {
                Logger.log(4, "Invalid Menu Extension (Group is invalid): " + ad.getId());
                return null;
            }
        }
        try {
            if (popupmenu) {
                if (sep != null && sep.isGroupMarker()) {
                    parent.appendToGroup(sep.getId(), ad.getAction());
                } else {
                    parent.insertAfter(mgroup, ad.getAction());
                }
            } else if (sep != null && sep.isGroupMarker()) {
                parent.appendToGroup(sep.getId(), ad.getContributionItem());
            } else {
                parent.insertAfter(mgroup, ad.getContributionItem());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.log(4, "Invalid Menu Extension (Group is missing): " + ad.getId());
            parent = null;
        }
        return parent;
    }

    protected boolean contributeSeparator(IMenuManager menu, IConfigurationElement element) {
        String id = element.getAttribute(ATT_NAME);
        if (id == null || id.length() <= 0) {
            return false;
        }
        IContributionItem sep = menu.find(id);
        if (sep != null) {
            return false;
        }
        menu.add((IContributionItem)new Separator(id));
        return true;
    }

    protected boolean contributeToolbarAction(ActionDescriptor ad, IToolBarManager toolbar, boolean appendIfMissing) {
        IContributionItem sep;
        if (ad.getContributionItem() == null || ad.getAction() == null) {
            return false;
        }
        String tpath = ad.getToolbarPath();
        String tgroup = ad.getToolbarGroup();
        if (tpath == null && tgroup == null) {
            return false;
        }
        IContributionItem item = toolbar.find(ad.getId());
        if (item != null) {
            toolbar.remove(ad.getId());
        }
        if (tgroup == null) {
            tgroup = "additions";
        }
        if ((sep = toolbar.find(tgroup)) == null) {
            if (appendIfMissing) {
                toolbar.add((IContributionItem)new Separator(tgroup));
            } else {
                Logger.log(4, "Invalid Toolbar Extension (Group is invalid): " + ad.getId());
                return false;
            }
        }
        try {
            if (sep != null && sep.isGroupMarker()) {
                toolbar.appendToGroup(sep.getId(), ad.getAction());
            } else {
                toolbar.insertAfter(tgroup, ad.getAction());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.log(4, "Invalid Toolbar Extension (Group is missing): " + ad.getId());
            return false;
        }
        return true;
    }

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        ActionDescriptor ad = null;
        try {
            ad = new ActionDescriptor(element);
            if (ad != null && ad.getAction() == null) {
                ad = null;
            }
        }
        catch (Exception e) {
            Logger.traceException(EXTENDED_EDITOR, e);
            ad = null;
        }
        return ad;
    }

    protected String getTargetID(IConfigurationElement element) {
        String value = element.getAttribute(ATT_TARGET_ID);
        return value != null ? value : "???";
    }

    public IExtendedContributor readActionExtensions(String editorId) {
        return this.readActionExtensions(new String[]{editorId});
    }

    public IExtendedContributor readActionExtensions(String[] ids) {
        long time0 = System.currentTimeMillis();
        ExtendedContributor ext = null;
        this.readContributions(ids, TAG_CONTRIBUTION_TYPE, PL_EXTENDED_EDITOR_ACTIONS);
        if (debugReadTime) {
            String idlist = "";
            if (ids.length > 0) {
                int i = 0;
                while (i < ids.length) {
                    idlist = String.valueOf(idlist) + ids[i];
                    if (i < ids.length - 1) {
                        idlist = String.valueOf(idlist) + ",";
                    }
                    ++i;
                }
            }
            System.out.println(String.valueOf(this.getClass().getName()) + "#readActionExtensions(" + idlist + "): read in " + (System.currentTimeMillis() - time0) + "ms [" + (this.readingCache != null ? this.readingCache.size() : 0) + " contributions]");
        }
        if (this.readingCache != null) {
            ext = new ExtendedContributor(this.readingCache);
            this.readingCache = null;
        }
        return ext;
    }

    protected void readContributions(String[] ids, String tag, String extensionPoint) {
        this.readingCache = null;
        this.targetIDs = Arrays.asList(ids);
        this.targetContributionTag = tag;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, PLUGIN_ID, extensionPoint);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            String id = this.getTargetID(element);
            if (id == null || !this.targetIDs.contains(id)) {
                return true;
            }
        } else {
            if (tag.equals(TAG_MENU)) {
                if (this.readingCache == null) {
                    this.readingCache = new ArrayList();
                }
                this.readingCache.add(element);
                return true;
            }
            if (tag.equals(TAG_POPUPMENU)) {
                if (this.readingCache == null) {
                    this.readingCache = new ArrayList();
                }
                this.readingCache.add(element);
                return true;
            }
            if (tag.equals(TAG_RULERMENU)) {
                if (this.readingCache == null) {
                    this.readingCache = new ArrayList();
                }
                this.readingCache.add(element);
                return true;
            }
            if (tag.equals(TAG_ACTION)) {
                ActionDescriptor ad;
                if (this.readingCache == null) {
                    this.readingCache = new ArrayList();
                }
                if ((ad = this.createActionDescriptor(element)) != null) {
                    this.readingCache.add(ad);
                }
                return true;
            }
            return false;
        }
        this.readElementChildren(element);
        return true;
    }

    public class ExtendedContributor
    implements IExtendedContributor,
    IMenuListener {
        private IExtendedSimpleEditor activeExtendedEditor = null;
        private List cache;
        private Map map = new HashMap();
        private IMenuManager menuBar = null;
        private Set menus = new HashSet();
        static /* synthetic */ Class class$0;

        public ExtendedContributor(List cache) {
            this.cache = cache;
        }

        private IExtendedSimpleEditor computeExtendedEditor(IEditorPart editor) {
            IExtendedSimpleEditor simpleEditor = null;
            if (editor instanceof IExtendedSimpleEditor) {
                simpleEditor = (IExtendedSimpleEditor)editor;
            }
            if (editor != null && simpleEditor == null) {
                ISourceEditingTextTools tools;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((tools = (ISourceEditingTextTools)editor.getAdapter((Class)clazz)) != null) {
                    simpleEditor = new IExtendedSimpleEditor(this, tools){
                        final /* synthetic */ ExtendedContributor this$1;
                        private final /* synthetic */ ISourceEditingTextTools val$tools;
                        {
                            this.this$1 = extendedContributor;
                            this.val$tools = iSourceEditingTextTools;
                        }

                        public int getCaretPosition() {
                            return this.val$tools.getCaretOffset();
                        }

                        public IDocument getDocument() {
                            return this.val$tools.getDocument();
                        }

                        public IEditorPart getEditorPart() {
                            return this.val$tools.getEditorPart();
                        }

                        public Point getSelectionRange() {
                            ITextSelection selection = this.val$tools.getSelection();
                            return new Point(selection.getOffset(), selection.getOffset() + selection.getLength());
                        }

                        public IStatus validateEdit(Shell context) {
                            return Status.OK_STATUS;
                        }
                    };
                }
            }
            return simpleEditor;
        }

        public void contributeToMenu(IMenuManager menu) {
            this.menuBar = menu;
            long time0 = System.currentTimeMillis();
            int i = 0;
            while (i < this.cache.size()) {
                Object obj = this.cache.get(i);
                if (obj instanceof IConfigurationElement) {
                    IConfigurationElement menuElement = (IConfigurationElement)obj;
                    if (menuElement.getName().equals(ExtendedEditorActionBuilder.TAG_MENU)) {
                        ExtendedEditorActionBuilder.this.contributeMenu(menuElement, menu, true);
                        if (debugMenu) {
                            System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToMenu() added: " + menuElement.getAttribute(ExtendedEditorActionBuilder.ATT_ID));
                        }
                    }
                } else if (obj instanceof ActionDescriptor) {
                    try {
                        ActionDescriptor ad = (ActionDescriptor)obj;
                        IMenuManager mm = ExtendedEditorActionBuilder.this.contributeMenuAction(ad, menu, true, false);
                        if (mm != null) {
                            this.map.put(ad.getContributionItem(), mm);
                            mm.addMenuListener((IMenuListener)this);
                            this.menus.add(mm);
                            if (debugMenu) {
                                System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToMenu() added: " + ad.getId());
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("contributing to menu", e);
                    }
                }
                ++i;
            }
            if (debugContributeTime) {
                System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToMenu(): ran in " + (System.currentTimeMillis() - time0) + "ms");
            }
        }

        public void contributeToPopupMenu(IMenuManager menu) {
            long time0 = System.currentTimeMillis();
            int i = 0;
            while (i < this.cache.size()) {
                block13: {
                    Object obj = this.cache.get(i);
                    if (obj instanceof IConfigurationElement) {
                        IConfigurationElement menuElement = (IConfigurationElement)obj;
                        if (menuElement.getName().equals(ExtendedEditorActionBuilder.TAG_POPUPMENU)) {
                            ExtendedEditorActionBuilder.this.contributeMenu(menuElement, menu, true);
                        }
                    } else if (obj instanceof ActionDescriptor) {
                        try {
                            ActionDescriptor ad = (ActionDescriptor)obj;
                            IAction a = ad.getAction();
                            if (a instanceof IExtendedEditorAction) {
                                try {
                                    IExtendedEditorAction eea = (IExtendedEditorAction)a;
                                    eea.setActiveExtendedEditor(this.activeExtendedEditor);
                                    eea.update();
                                    if (!eea.isVisible()) break block13;
                                    IMenuManager parent = ExtendedEditorActionBuilder.this.contributeMenuAction(ad, menu, true, true);
                                    if (debugPopup && parent != null) {
                                        System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToPopupMenu() added: " + ad.getId());
                                    }
                                    break block13;
                                }
                                catch (Exception e) {
                                    Logger.logException(e);
                                }
                                break block13;
                            }
                            IMenuManager parent = ExtendedEditorActionBuilder.this.contributeMenuAction(ad, menu, true, true);
                            if (debugPopup && parent != null) {
                                System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToPopupMenu() added: " + ad.getId());
                            }
                        }
                        catch (Exception e) {
                            Logger.logException("contributing to popup", e);
                        }
                    }
                }
                ++i;
            }
            if (debugContributeTime) {
                System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToPopupMenu(): ran in " + (System.currentTimeMillis() - time0) + "ms");
            }
        }

        public void contributeToStatusLine(IStatusLineManager manager) {
        }

        public void contributeToToolBar(IToolBarManager manager) {
            long time0 = System.currentTimeMillis();
            int i = 0;
            while (i < this.cache.size()) {
                Object obj = this.cache.get(i);
                if (obj instanceof ActionDescriptor) {
                    try {
                        ActionDescriptor ad = (ActionDescriptor)obj;
                        IAction a = ad.getAction();
                        if (a instanceof IExtendedEditorAction) {
                            IExtendedEditorAction eea = (IExtendedEditorAction)a;
                            eea.setActiveExtendedEditor(this.activeExtendedEditor);
                            eea.update();
                            if (eea.isVisible()) {
                                boolean contributed = ExtendedEditorActionBuilder.this.contributeToolbarAction(ad, manager, true);
                                if (debugToolbar && contributed) {
                                    System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToToolBar() added: " + ad.getId());
                                }
                            } else if (debugToolbar) {
                                System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToToolBar(): [skipped] " + ad.getId());
                            }
                        } else {
                            boolean contributed = ExtendedEditorActionBuilder.this.contributeToolbarAction(ad, manager, true);
                            if (debugToolbar && contributed) {
                                System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToToolBar() added: " + ad.getId());
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("contributing to toolbar", e);
                    }
                }
                ++i;
            }
            if (debugContributeTime) {
                System.out.println(String.valueOf(this.getClass().getName()) + "#contributeToToolBar(): ran in " + (System.currentTimeMillis() - time0) + "ms");
            }
        }

        public void dispose() {
            Iterator it = this.menus.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof IMenuManager)) continue;
                ((IMenuManager)o).removeMenuListener((IMenuListener)this);
            }
        }

        public void init(IActionBars bars, IWorkbenchPage page) {
        }

        public void menuAboutToShow(IMenuManager menu) {
            MultiPageEditorPart multiPageEditor;
            IEditorSite site = null;
            boolean activeEditorIsVisible = false;
            if (this.activeExtendedEditor != null && this.activeExtendedEditor.getEditorPart() != null) {
                site = this.activeExtendedEditor.getEditorPart().getEditorSite();
            }
            if (site == null) {
                return;
            }
            activeEditorIsVisible = site instanceof MultiPageEditorSite ? (multiPageEditor = ((MultiPageEditorSite)site).getMultiPageEditor()).equals(site.getPage().getActiveEditor()) || multiPageEditor.equals(site.getPage().getActivePart()) : site.getWorkbenchWindow().getPartService().getActivePart().equals(this.activeExtendedEditor.getEditorPart());
            if (!activeEditorIsVisible) {
                return;
            }
            IContributionItem[] items = menu.getItems();
            if (items == null || items.length == 0) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof IMenuManager) {
                    ((IMenuManager)items[i]).addMenuListener((IMenuListener)this);
                    this.menus.add(items[i]);
                }
                ++i;
            }
            Set keys = this.map.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                IContributionItem item = (IContributionItem)it.next();
                IMenuManager mm = (IMenuManager)this.map.get(item);
                if (menu.getId() == null || !menu.getId().equals(mm.getId()) || !(item instanceof ActionContributionItem)) continue;
                try {
                    IAction action = ((ActionContributionItem)item).getAction();
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    boolean visible = true;
                    if (action instanceof IExtendedEditorAction) {
                        visible = ((IExtendedEditorAction)action).isVisible();
                    }
                    item.setVisible(visible);
                }
                catch (Exception e) {
                    Logger.logException("updating actions", e);
                }
            }
            menu.update(false);
        }

        public void setActiveEditor(IEditorPart editor) {
            this.activeExtendedEditor = this.computeExtendedEditor(editor);
            IKeyBindingService svc = editor != null ? editor.getEditorSite().getKeyBindingService() : null;
            int i = 0;
            while (i < this.cache.size()) {
                Object obj = this.cache.get(i);
                if (obj instanceof ActionDescriptor) {
                    ActionDescriptor ad = (ActionDescriptor)obj;
                    try {
                        IAction action = ad.getAction();
                        if (action instanceof IExtendedEditorAction) {
                            ((IExtendedEditorAction)action).setActiveExtendedEditor(this.activeExtendedEditor);
                            ((IExtendedEditorAction)action).update();
                            if (!((IExtendedEditorAction)action).isVisible() && ad.getContributionItem() != null) {
                                ad.getContributionItem().setVisible(false);
                            }
                            if (svc != null && action.getActionDefinitionId() != null) {
                                svc.registerAction(action);
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("setting active editor on actions", e);
                    }
                }
                ++i;
            }
            if (this.menuBar != null && editor != null && ExtendedEditorActionBuilder.this.targetIDs.contains(editor.getEditorSite().getId())) {
                this.contributeToMenu(this.menuBar);
            }
            this.updateToolbarActions();
        }

        public void updateToolbarActions() {
            int i = 0;
            while (i < this.cache.size()) {
                Object obj = this.cache.get(i);
                if (obj instanceof ActionDescriptor) {
                    try {
                        IAction action;
                        ActionDescriptor ad = (ActionDescriptor)obj;
                        if (ad.getToolbarPath() != null && (action = ad.getAction()) instanceof IUpdate) {
                            ((IUpdate)action).update();
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("updating toolbar actions", e);
                    }
                }
                ++i;
            }
        }
    }
}

