/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.sse.core.internal.IExecutionDelegate;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.IExecutionDelegatable;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorActionBuilder;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorDropTargetAdapter;
import org.eclipse.wst.sse.ui.internal.IExtendedConfiguration;
import org.eclipse.wst.sse.ui.internal.IExtendedContributor;
import org.eclipse.wst.sse.ui.internal.IModelProvider;
import org.eclipse.wst.sse.ui.internal.IPopupMenuContributor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.ReadOnlyAwareDropTargetAdapter;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StorageModelProvider;
import org.eclipse.wst.sse.ui.internal.StructuredLineChangeHover;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.contentoutline.StructuredTextEditorContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;
import org.eclipse.wst.sse.ui.internal.debug.EditBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ManageBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointsTarget;
import org.eclipse.wst.sse.ui.internal.editor.EditorExecutionContext;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.sse.ui.internal.editor.StructuredModelDocumentProvider;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.hyperlink.OpenHyperlinkAction;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.eclipse.wst.sse.ui.internal.properties.ConfigurablePropertySheetPage;
import org.eclipse.wst.sse.ui.internal.properties.ShowPropertiesAction;
import org.eclipse.wst.sse.ui.internal.provisional.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ConfigurationPointCalculator;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.NullSourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline.StructuredContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.views.properties.PropertySheetConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.views.properties.StructuredPropertySheetConfiguration;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectEnclosingAction;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectHistoryAction;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectNextAction;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectPreviousAction;
import org.eclipse.wst.sse.ui.internal.util.Assert;
import org.osgi.framework.Bundle;

public class StructuredTextEditor
extends TextEditor {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private static final long BUSY_STATE_DELAY = 1000L;
    protected static final String DOT = ".";
    private static final String EDITOR_CONTEXT_MENU_ID = "org.eclipse.wst.sse.ui.StructuredTextEditor.context";
    private static final String EDITOR_KEYBINDING_SCOPE_ID = "org.eclipse.wst.sse.ui.structuredTextEditorScope";
    public static final String GROUP_NAME_ADDITIONS = "additions";
    public static final String GROUP_NAME_FORMAT = "Format";
    public static final String GROUP_NAME_FORMAT_EXT = "Format.ext";
    private static final String REDO_ACTION_DESC = SSEUIMessages.Redo___0___UI_;
    private static final String REDO_ACTION_DESC_DEFAULT = SSEUIMessages.Redo_Text_Change__UI_;
    private static final String REDO_ACTION_TEXT = SSEUIMessages._Redo__0___Ctrl_Y_UI_;
    private static final String REDO_ACTION_TEXT_DEFAULT = SSEUIMessages._Redo_Text_Change__Ctrl_Y_UI_;
    protected static final String SSE_MODEL_ID = "org.eclipse.wst.sse.core";
    protected static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.wst.sse.ui", 1, "ERROR", null);
    protected static final IStatus STATUS_OK = new Status(0, "org.eclipse.wst.sse.ui", 0, "OK", null);
    private static final String UNDERSCORE = "_";
    private static final String UNDO_ACTION_DESC = SSEUIMessages.Undo___0___UI_;
    private static final String UNDO_ACTION_DESC_DEFAULT = SSEUIMessages.Undo_Text_Change__UI_;
    private static final String UNDO_ACTION_TEXT = SSEUIMessages._Undo__0___Ctrl_Z_UI_;
    private static final String UNDO_ACTION_TEXT_DEFAULT = SSEUIMessages._Undo_Text_Change__Ctrl_Z_UI_;
    private int adapterRequests;
    private long adapterTime;
    private boolean fBackgroundJobEnded;
    private boolean fBusyState;
    private Timer fBusyTimer;
    Runnable fCurrentRunnable = null;
    boolean fDirtyBeforeDocumentEvent = false;
    private ExtendedEditorDropTargetAdapter fDropAdapter;
    private DropTarget fDropTarget;
    private boolean fEditorDisposed = false;
    private IEditorPart fEditorPart;
    private IDocumentListener fInternalDocumentListener;
    private InternalModelStateListener fInternalModelStateListener;
    private MouseTracker fMouseTracker;
    protected IContentOutlinePage fOutlinePage;
    private IStructuredTextFoldingProvider fProjectionModelUpdater;
    private ProjectionSupport fProjectionSupport;
    protected IPropertySheetPage fPropertySheetPage;
    private String fRememberTitle;
    String[] fShowInTargetIds = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private IAction fShowPropertiesAction = null;
    private IStructuredModel fStructuredModel;
    private boolean fUpdateMenuTextPending;
    int hoverX = -1;
    int hoverY = -1;
    private InternalElementStateListener internalElementStateListener = new InternalElementStateListener();
    private boolean shouldClose = false;
    private long startPerfTime;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public StructuredTextEditor() {
        this.initializeDocumentProvider(null);
    }

    private void aboutToSaveModel() {
        if (this.getInternalModel() != null) {
            this.getInternalModel().aboutToChangeModel();
        }
    }

    private void abstractTextEditorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator(GROUP_NAME_ADDITIONS));
        menu.add((IContributionItem)new Separator("group.save"));
        if (this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            this.addAction(menu, "group.undo", ITextEditorActionConstants.REVERT_TO_SAVED);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
            this.addAction(menu, "group.save", ITextEditorActionConstants.SAVE);
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
        IAction preferencesAction = this.getAction("Preferences.ContextAction");
        menu.appendToGroup(GROUP_NAME_ADDITIONS, (IContributionItem)new Separator("settings"));
        menu.appendToGroup("settings", preferencesAction);
    }

    protected void addContextMenuActions(IMenuManager menu) {
        boolean enableFormatMenu;
        IAction formatAll = this.getAction("FormatDocument");
        IAction formatSelection = this.getAction("FormatActiveElements");
        IAction cleanupAll = this.getAction("CleanupDocument");
        boolean bl = enableFormatMenu = formatAll != null && formatAll.isEnabled() || formatSelection != null && formatSelection.isEnabled() || cleanupAll != null && cleanupAll.isEnabled();
        if (this.getSourceViewer().isEditable() && enableFormatMenu) {
            String label = SSEUIMessages.FormatMenu_label;
            MenuManager subMenu = new MenuManager(label, GROUP_NAME_FORMAT);
            subMenu.add((IContributionItem)new GroupMarker(GROUP_NAME_FORMAT_EXT));
            this.addAction((IMenuManager)subMenu, "FormatDocument");
            this.addAction((IMenuManager)subMenu, "FormatActiveElements");
            subMenu.add((IContributionItem)new GroupMarker(GROUP_NAME_ADDITIONS));
            this.addAction(menu, "group.edit", "CleanupDocument");
            menu.appendToGroup("group.edit", (IContributionItem)subMenu);
        }
        menu.appendToGroup("group.add", this.fShowPropertiesAction);
    }

    private void addExtendedContextMenuActions(IMenuManager menu) {
        IEditorActionBarContributor c = this.getEditorSite().getActionBarContributor();
        if (c instanceof IPopupMenuContributor) {
            ((IPopupMenuContributor)c).contributeToPopupMenu(menu);
        } else {
            ExtendedEditorActionBuilder builder = new ExtendedEditorActionBuilder();
            IExtendedContributor pmc = builder.readActionExtensions(this.getConfigurationPoints());
            if (pmc != null) {
                pmc.setActiveEditor((IEditorPart)this);
                pmc.contributeToPopupMenu(menu);
            }
        }
    }

    protected void addExtendedRulerContextMenuActions(IMenuManager menu) {
    }

    public void beginBackgroundOperation() {
        this.fBackgroundJobEnded = false;
        if (!this.inBusyState()) {
            this.beginBusyStateInternal();
        }
    }

    private void beginBusyStateInternal() {
        this.fBusyState = true;
        this.startBusyTimer();
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof StructuredTextViewer) {
            ((StructuredTextViewer)viewer).beginBackgroundUpdate();
        }
        this.showBusy(true);
    }

    public void close(final boolean save) {
        if (this.getSite() == null) {
            this.shouldClose = true;
        } else if (this.getEditorPart() != null) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    StructuredTextEditor.this.getSite().getPage().closeEditor(StructuredTextEditor.this.getEditorPart(), save);
                }
            });
        } else {
            super.close(save);
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        ArrayList<String> allIds = new ArrayList<String>(0);
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] configurationIds = this.getConfigurationPoints();
        int i = 0;
        while (i < configurationIds.length) {
            String[] definitions = builder.getDefinitions("preferencepages", configurationIds[i]);
            int j = 0;
            while (j < definitions.length) {
                String someIds = definitions[j];
                if (someIds != null && someIds.length() > 0) {
                    String[] ids = StringUtils.unpack((String)someIds);
                    int k = 0;
                    while (k < ids.length) {
                        String id = ids[k].trim();
                        if (!allIds.contains(id)) {
                            allIds.add(id);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        String[] superPages = super.collectContextMenuPreferencePages();
        int m = 0;
        while (m < superPages.length) {
            String id = superPages[m].trim();
            if (!allIds.contains(id)) {
                allIds.add(id);
            }
            ++m;
        }
        return allIds.toArray(new String[0]);
    }

    private void computeAndSetDoubleClickAction(IStructuredModel model) {
        if (model == null) {
            return;
        }
        String ext = BreakpointRulerAction.getFileExtension(this.getEditorInput());
        if (BreakpointProviderBuilder.getInstance().isAvailable(model.getContentTypeIdentifier(), ext)) {
            this.setAction("RulerDoubleClick", this.getAction("org.eclipse.wst.sse.ui.breakpoints.toggle"));
        } else {
            this.setAction("RulerDoubleClick", this.getAction(IDEActionFactory.BOOKMARK.getId()));
        }
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher(this.createCharacterPairMatcher());
        support.setMatchingCharacterPainterPreferenceKeys(EditorPreferenceNames.MATCHING_BRACKETS, EditorPreferenceNames.MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = SSEUIMessages.getResourceBundle();
        IWorkbenchHelpSystem helpSystem = SSEUIPlugin.getDefault().getWorkbench().getHelpSystem();
        Object action = new TextOperationAction(resourceBundle, "Editor_Cut_", (ITextEditor)this, 3, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        helpSystem.setHelp((IAction)action, IAbstractTextEditorHelpContextIds.CUT_ACTION);
        action = new TextOperationAction(resourceBundle, "Editor_Paste_", (ITextEditor)this, 5, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        helpSystem.setHelp((IAction)action, IAbstractTextEditorHelpContextIds.PASTE_ACTION);
        action = new TextOperationAction(resourceBundle, "Editor_Delete_", (ITextEditor)this, 6, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction(ITextEditorActionConstants.DELETE, (IAction)action);
        helpSystem.setHelp((IAction)action, IAbstractTextEditorHelpContextIds.DELETE_ACTION);
        action = new TextOperationAction(SSEUIMessages.getResourceBundle(), "ShowTooltipDesc_", (ITextEditor)this, 16, true);
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.show.javadoc");
        this.setAction("ShowTooltipDesc", (IAction)action);
        this.markAsStateDependentAction("ShowTooltipDesc", true);
        action = new TextOperationAction(resourceBundle, "ContentAssistProposals_", (ITextEditor)this, 13, true);
        helpSystem.setHelp((IAction)action, "org.eclipse.wst.sse.ui.xmlm1010");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposals", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposals", true);
        action = new TextOperationAction(SSEUIMessages.getResourceBundle(), "ContentAssistContextInformation_", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        action = new TextOperationAction(resourceBundle, "QuickFix_", (ITextEditor)this, 24, true);
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.edit.text.java.correction.assist.proposals");
        this.setAction("QuickFix", (IAction)action);
        this.markAsStateDependentAction("QuickFix", true);
        action = new TextOperationAction(resourceBundle, "FormatDocument_", (ITextEditor)this, 22);
        helpSystem.setHelp((IAction)action, "org.eclipse.wst.sse.ui.xmlm1030");
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.format.document");
        this.setAction("FormatDocument", (IAction)action);
        this.markAsStateDependentAction("FormatDocument", true);
        this.markAsSelectionDependentAction("FormatDocument", true);
        action = new TextOperationAction(resourceBundle, "FormatActiveElements_", (ITextEditor)this, 23);
        helpSystem.setHelp((IAction)action, "org.eclipse.wst.sse.ui.xmlm1040");
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.format.active.elements");
        this.setAction("FormatActiveElements", (IAction)action);
        this.markAsStateDependentAction("FormatActiveElements", true);
        this.markAsSelectionDependentAction("FormatActiveElements", true);
        action = new ToggleBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.toggle", (IAction)action);
        action = new ManageBreakpointAction((ITextEditor)this, this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.manage", (IAction)action);
        action = new EditBreakpointAction((ITextEditor)this, this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.edit", (IAction)action);
        action = new OpenHyperlinkAction(resourceBundle, "OpenFileFromSource_", (ITextEditor)this, (ITextViewer)this.getSourceViewer());
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.open.file.from.source");
        this.setAction("OpenFileFromSource", (IAction)action);
        this.fShowPropertiesAction = new ShowPropertiesAction();
        SelectionHistory selectionHistory = new SelectionHistory((ITextEditor)this);
        action = new StructureSelectEnclosingAction(this, selectionHistory);
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.enclosing");
        this.setAction("StructureSelectEnclosing", (IAction)action);
        action = new StructureSelectNextAction(this, selectionHistory);
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.next");
        this.setAction("StructureSelectNext", (IAction)action);
        action = new StructureSelectPreviousAction(this, selectionHistory);
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.previous");
        this.setAction("StructureSelectPrevious", (IAction)action);
        action = new StructureSelectHistoryAction(this, selectionHistory);
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.last");
        this.setAction("StructureSelectHistory", (IAction)action);
        selectionHistory.setHistoryAction((StructureSelectHistoryAction)((Object)action));
    }

    protected LineChangeHover createChangeHover() {
        return new StructuredLineChangeHover();
    }

    protected ICharacterPairMatcher createCharacterPairMatcher() {
        ICharacterPairMatcher matcher = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (matcher == null && i < ids.length) {
            matcher = (ICharacterPairMatcher)builder.getConfiguration("characterpairmatcher", ids[i]);
            ++i;
        }
        if (matcher == null) {
            matcher = new ICharacterPairMatcher(){

                public void clear() {
                }

                public void dispose() {
                }

                public int getAnchor() {
                    return 1;
                }

                public IRegion match(IDocument iDocument, int i) {
                    return null;
                }
            };
        }
        return matcher;
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs});
    }

    private ContentOutlineConfiguration createContentOutlineConfiguration() {
        ContentOutlineConfiguration cfg = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (cfg == null && i < ids.length) {
            cfg = (ContentOutlineConfiguration)builder.getConfiguration("contentoutlineconfiguration", ids[i]);
            ++i;
        }
        return cfg;
    }

    protected void createModelDependentFields() {
    }

    public void createPartControl(Composite parent) {
        if (this.getSourceViewerConfiguration() == null) {
            StructuredTextViewerConfiguration newViewerConfiguration = this.createSourceViewerConfiguration();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)newViewerConfiguration);
        }
        super.createPartControl(parent);
        this.initializeSourceViewer();
    }

    protected PropertySheetConfiguration createPropertySheetConfiguration() {
        PropertySheetConfiguration cfg = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (cfg == null && i < ids.length) {
            cfg = (PropertySheetConfiguration)builder.getConfiguration("propertysheetconfiguration", ids[i]);
            ++i;
        }
        return cfg;
    }

    private String[] createShowInTargetIds() {
        ArrayList<String> allIds = new ArrayList<String>(0);
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] configurationIds = this.getConfigurationPoints();
        int i = 0;
        while (i < configurationIds.length) {
            String[] definitions = builder.getDefinitions("showintarget", configurationIds[i]);
            int j = 0;
            while (j < definitions.length) {
                String someIds = definitions[j];
                if (someIds != null && someIds.length() > 0) {
                    String[] ids = StringUtils.unpack((String)someIds);
                    int k = 0;
                    while (k < ids.length) {
                        String id = ids[k].trim();
                        if (!allIds.contains(id)) {
                            allIds.add(id);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!allIds.contains("org.eclipse.ui.views.ResourceNavigator")) {
            allIds.add("org.eclipse.ui.views.ResourceNavigator");
        }
        if (!allIds.contains("org.eclipse.ui.views.ContentOutline")) {
            allIds.add("org.eclipse.ui.views.ContentOutline");
        }
        return allIds.toArray(new String[0]);
    }

    private ISourceEditingTextTools createSourceEditingTextTools() {
        ISourceEditingTextTools tools = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (tools == null && i < ids.length) {
            tools = (ISourceEditingTextTools)builder.getConfiguration("sourceeditingtexttools", ids[i]);
            ++i;
        }
        if (tools == null) {
            tools = NullSourceEditingTextTools.getInstance();
        }
        try {
            Class<?> clazz = tools.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.StructuredTextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("setTextEditor", classArray);
            if (method == null) {
                Class<?> clazz3 = tools.getClass();
                Class[] classArray2 = new Class[1];
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz4;
                method = clazz3.getMethod("setTextEditor", classArray2);
            }
            if (method == null) {
                Class<?> clazz5 = tools.getClass();
                Class[] classArray3 = new Class[1];
                Class<?> clazz6 = class$2;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$2 = Class.forName("org.eclipse.ui.IEditorPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray3[0] = clazz6;
                method = clazz5.getMethod("setTextEditor", classArray3);
            }
            if (method != null) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)tools, new Object[]{this});
            }
        }
        catch (Exception e) {
            Logger.logException("Problem creating ISourceEditingTextTools implementation", e);
        }
        return tools;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StructuredTextViewer sourceViewer = this.createStructedTextViewer(parent, verticalRuler, styles);
        this.initSourceViewer(sourceViewer);
        return sourceViewer;
    }

    private StructuredTextViewerConfiguration createSourceViewerConfiguration() {
        StructuredTextViewerConfiguration cfg = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (cfg == null && i < ids.length) {
            cfg = (StructuredTextViewerConfiguration)builder.getConfiguration("textviewerconfiguration", ids[i]);
            ++i;
        }
        if (cfg == null) {
            cfg = new StructuredTextViewerConfiguration();
            cfg.setDeclaringID(String.valueOf(((Object)((Object)this)).getClass().getName()) + "#default");
        }
        this.initializeSourceViewerConfiguration(cfg);
        return cfg;
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new StructuredTextViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    public void dispose() {
        IDocument doc;
        Logger.trace("Source Editor", "StructuredTextEditor::dispose entry");
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fMouseTracker != null) {
            this.fMouseTracker.stop();
            this.fMouseTracker = null;
        }
        if (this.getDocumentProvider() != null) {
            this.getDocumentProvider().removeElementStateListener((IElementStateListener)this.internalElementStateListener);
        }
        if (this.fStructuredModel != null) {
            if (this.fStructuredModel.getStructuredDocument() != null) {
                this.fStructuredModel.getStructuredDocument().removeDocumentListener(this.getInternalDocumentListener());
            }
            this.fStructuredModel.removeModelStateListener((IModelStateListener)this.getInternalModelStateListener());
        }
        if ((doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) != null) {
            doc.removeDocumentListener(this.getInternalDocumentListener());
            if (doc instanceof IExecutionDelegatable) {
                ((IExecutionDelegatable)doc).setExecutionDelegate(null);
            }
        }
        this.fEditorDisposed = true;
        this.disposeModelDependentFields();
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        if (config instanceof StructuredTextViewerConfiguration) {
            ((StructuredTextViewerConfiguration)config).unConfigure(this.getSourceViewer());
        }
        if (this.fDropTarget != null) {
            this.fDropTarget.dispose();
        }
        this.setPreferenceStore(null);
        this.fDropAdapter = null;
        this.fDropTarget = null;
        super.dispose();
        Logger.trace("Source Editor", "StructuredTextEditor::dispose exit");
    }

    protected void disposeDocumentProvider() {
        if (this.fStructuredModel != null && !(this.getDocumentProvider() instanceof IModelProvider)) {
            this.fStructuredModel.releaseFromEdit();
        }
        super.disposeDocumentProvider();
    }

    private void disposeModelDependentFields() {
    }

    public void doRevertToSaved() {
        IDocument doc;
        super.doRevertToSaved();
        if (this.fOutlinePage != null && this.fOutlinePage instanceof IUpdate) {
            ((IUpdate)this.fOutlinePage).update();
        }
        if ((doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) instanceof IStructuredDocument) {
            ((IStructuredDocument)doc).getUndoManager().getCommandStack().flush();
        }
        this.updateMenuText();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor progressMonitor) {
        try {
            this.aboutToSaveModel();
            this.updateEncodingMemento();
            super.doSave(progressMonitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.savedModel();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.savedModel();
            return;
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        try {
            IDocument olddoc;
            IEditorInput oldInput = this.getEditorInput();
            if (oldInput != null && (olddoc = this.getDocumentProvider().getDocument((Object)oldInput)) != null && olddoc instanceof IExecutionDelegatable) {
                ((IExecutionDelegatable)olddoc).setExecutionDelegate(null);
            }
            if (this.fStructuredModel != null && !(this.getDocumentProvider() instanceof IModelProvider)) {
                this.fStructuredModel.releaseFromEdit();
            }
            super.doSetInput(input);
            IDocument newDocument = this.getDocumentProvider().getDocument((Object)input);
            if (newDocument instanceof IExecutionDelegatable) {
                ((IExecutionDelegatable)newDocument).setExecutionDelegate((IExecutionDelegate)new EditorExecutionContext(this));
            }
            IStructuredModel model = null;
            if (this.getDocumentProvider() instanceof IModelProvider) {
                model = ((IModelProvider)this.getDocumentProvider()).getModel(this.getEditorInput());
                if (!model.isShared()) {
                    EditorModelUtil.addFactoriesTo(model);
                }
            } else if (newDocument instanceof IStructuredDocument) {
                model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)newDocument);
                EditorModelUtil.addFactoriesTo(model);
            } else {
                this.logUnexpectedDocumentKind(input);
            }
            if (this.fStructuredModel != null || model != null) {
                this.setModel(model);
            }
            if (this.getInternalModel() != null) {
                String contentType = this.getInternalModel().getContentTypeIdentifier();
                this.setEditorContextMenuId(String.valueOf(contentType) + ".source.EditorContext");
                this.setRulerContextMenuId(String.valueOf(contentType) + ".source.RulerContext");
                this.setHelpContextId(String.valueOf(contentType) + ".source.HelpId");
                if (this.getHelpContextId() != null && this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
                    IWorkbenchHelpSystem helpSystem = SSEUIPlugin.getDefault().getWorkbench().getHelpSystem();
                    helpSystem.setHelp((Control)this.getSourceViewer().getTextWidget(), this.getHelpContextId());
                }
            }
            if (this.fProjectionModelUpdater != null) {
                this.fProjectionModelUpdater.initialize();
            }
            this.setInsertMode(SMART_INSERT);
        }
        catch (CoreException exception) {
            this.dispose();
            throw new CoreException(exception.getStatus());
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        this.abstractTextEditorContextMenuAboutToShow(menu);
        this.addContextMenuActions(menu);
        this.addExtendedContextMenuActions(menu);
    }

    public void endBackgroundOperation() {
        this.fBackgroundJobEnded = true;
        this.resetBusyState();
    }

    private void endBusyStateInternal() {
        if (this.fBackgroundJobEnded) {
            this.fBusyTimer.cancel();
            this.showBusy(false);
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer instanceof StructuredTextViewer) {
                ((StructuredTextViewer)viewer).endBackgroundUpdate();
            }
            this.fBusyState = false;
        }
    }

    public Object getAdapter(Class required) {
        Object result = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            result = this;
        } else {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(required)) {
                IWorkbenchPartSite iWorkbenchPartSite = this.getEditorPart().getSite();
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return iWorkbenchPartSite.getAdapter((Class)clazz3);
            }
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz4.equals(required)) {
                ContentOutlineConfiguration cfg;
                if ((this.fOutlinePage == null || this.fOutlinePage.getControl() == null || this.fOutlinePage.getControl().isDisposed()) && (cfg = this.createContentOutlineConfiguration()) != null) {
                    if (cfg instanceof StructuredContentOutlineConfiguration) {
                        ((StructuredContentOutlineConfiguration)cfg).setEditor(this);
                    }
                    StructuredTextEditorContentOutlinePage outlinePage = new StructuredTextEditorContentOutlinePage();
                    outlinePage.setConfiguration(cfg);
                    outlinePage.setViewerSelectionManager(this.getViewerSelectionManager());
                    outlinePage.setModel(this.getInternalModel());
                    this.fOutlinePage = outlinePage;
                }
                result = this.fOutlinePage;
            } else {
                Class<?> clazz5 = class$5;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$5 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz5.equals(required) && this.isEditable()) {
                    PropertySheetConfiguration cfg;
                    if ((this.fPropertySheetPage == null || this.fPropertySheetPage.getControl() == null || this.fPropertySheetPage.getControl().isDisposed()) && (cfg = this.createPropertySheetConfiguration()) != null) {
                        if (cfg instanceof StructuredPropertySheetConfiguration) {
                            ((StructuredPropertySheetConfiguration)cfg).setEditor((IEditorPart)this);
                        }
                        ConfigurablePropertySheetPage propertySheetPage = new ConfigurablePropertySheetPage();
                        propertySheetPage.setConfiguration(cfg);
                        propertySheetPage.setViewerSelectionManager(this.getViewerSelectionManager());
                        propertySheetPage.setModel(this.getInternalModel());
                        this.fPropertySheetPage = propertySheetPage;
                    }
                    result = this.fPropertySheetPage;
                } else {
                    Class<?> clazz6 = class$6;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$6 = Class.forName("org.eclipse.wst.sse.ui.internal.ViewerSelectionManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz6.equals(required)) {
                        result = this.getViewerSelectionManager();
                    } else {
                        Class<?> clazz7 = class$7;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$7 = Class.forName("org.eclipse.jface.text.IDocument");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7.equals(required)) {
                            result = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                        } else {
                            Class<?> clazz8 = class$8;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$8 = Class.forName("org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz8.equals(required)) {
                                result = this.createSourceEditingTextTools();
                            } else {
                                Class<?> clazz9 = class$9;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = class$9 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz9.equals(required)) {
                                    result = ToggleBreakpointsTarget.getInstance();
                                } else {
                                    Class<?> clazz10 = class$10;
                                    if (clazz10 == null) {
                                        try {
                                            clazz10 = class$10 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz10.equals(required)) {
                                        return new ShowInTargetListAdapter();
                                    }
                                    if (result == null) {
                                        result = this.getInternalModel() != null ? this.getInternalModel().getAdapter(required) : super.getAdapter(required);
                                    }
                                    if (result == null) {
                                        result = super.getAdapter(required);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private String[] getConfigurationPoints() {
        Class<?> clazz;
        String contentTypeIdentifierID = null;
        if (this.getInternalModel() != null) {
            contentTypeIdentifierID = this.getInternalModel().getContentTypeIdentifier();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.StructuredTextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ConfigurationPointCalculator.getConfigurationPoints((IEditorPart)this, contentTypeIdentifierID, ".source", clazz);
    }

    protected String getCursorPosition() {
        String result = null;
        result = this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null && !this.getSourceViewer().getTextWidget().isDisposed() ? super.getCursorPosition() : "0:0";
        return result;
    }

    Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public IEditorPart getEditorPart() {
        if (this.fEditorPart == null) {
            return this;
        }
        return this.fEditorPart;
    }

    public IFile getFileInEditor() {
        IFile result = null;
        IStructuredModel model = this.getInternalModel();
        if (model != null) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(model.getBaseLocation()));
        }
        return result;
    }

    private IDocumentListener getInternalDocumentListener() {
        if (this.fInternalDocumentListener == null) {
            this.fInternalDocumentListener = new InternalDocumentListener();
        }
        return this.fInternalDocumentListener;
    }

    private IStructuredModel getInternalModel() {
        return this.fStructuredModel;
    }

    private InternalModelStateListener getInternalModelStateListener() {
        if (this.fInternalModelStateListener == null) {
            this.fInternalModelStateListener = new InternalModelStateListener();
        }
        return this.fInternalModelStateListener;
    }

    public IStructuredModel getModel() {
        if (this.getDocumentProvider() == null) {
            Logger.trace(((Object)((Object)this)).getClass().getName(), "Program Info Only: document provider was null when model requested");
        }
        boolean initialModelNull = false;
        if (this.fStructuredModel == null) {
            initialModelNull = true;
        }
        if (this.fStructuredModel == null) {
            if (this.getDocumentProvider() instanceof IModelProvider) {
                this.fStructuredModel = ((IModelProvider)this.getDocumentProvider()).getModel(this.getEditorInput());
            } else {
                IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                if (doc instanceof IStructuredDocument) {
                    IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
                    if (model == null) {
                        model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)doc);
                    }
                    this.fStructuredModel = model;
                }
            }
            EditorModelUtil.addFactoriesTo(this.fStructuredModel);
            if (initialModelNull && this.fStructuredModel != null) {
                this.update();
            }
        }
        return this.fStructuredModel;
    }

    public int getOrientation() {
        return 0x2000000;
    }

    private IStatusLineManager getStatusLineManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorActionBarContributor contributor = editor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public StructuredTextViewer getTextViewer() {
        return (StructuredTextViewer)this.getSourceViewer();
    }

    public ViewerSelectionManager getViewerSelectionManager() {
        if (this.getTextViewer() != null) {
            return this.getTextViewer().getViewerSelectionManager();
        }
        return null;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.updateStatusField("Offset");
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (EditorPreferenceNames.EDITOR_TEXT_HOVER_MODIFIERS.equals(property)) {
            this.updateHoverBehavior();
        }
        if ("foldingEnabled".equals(property)) {
            if (this.getSourceViewer() instanceof ProjectionViewer) {
                ProjectionViewer pv;
                if (this.isFoldingEnabled() && this.fProjectionSupport == null && this.fProjectionModelUpdater == null) {
                    this.installProjectionSupport();
                }
                if ((pv = (ProjectionViewer)this.getSourceViewer()).isProjectionMode() != this.isFoldingEnabled() && pv.canDoOperation(19)) {
                    pv.doOperation(19);
                }
            }
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    private boolean inBusyState() {
        return this.fBusyState;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.shouldClose) {
            this.setSite((IWorkbenchPartSite)site);
            this.close(false);
        } else {
            super.init(site, input);
        }
    }

    public void initializeDocumentProvider(IDocumentProvider documentProvider) {
        if (this.getDocumentProvider() != null) {
            this.getDocumentProvider().removeElementStateListener((IElementStateListener)this.internalElementStateListener);
        }
        if (documentProvider != null) {
            this.setDocumentProvider(documentProvider);
        }
        if (documentProvider != null) {
            documentProvider.addElementStateListener((IElementStateListener)this.internalElementStateListener);
        }
    }

    protected void initializeDrop(ITextViewer textViewer) {
        int operations = 3;
        this.fDropTarget = new DropTarget((Control)textViewer.getTextWidget(), operations);
        this.fDropAdapter = new ReadOnlyAwareDropTargetAdapter();
        this.fDropAdapter.setTargetEditor((IEditorPart)this);
        this.fDropAdapter.setTargetIDs(this.getConfigurationPoints());
        this.fDropAdapter.setTextViewer(textViewer);
        this.fDropTarget.setTransfer(this.fDropAdapter.getTransfers());
        this.fDropTarget.addDropListener((DropTargetListener)this.fDropAdapter);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.fEncodingSupport = null;
        this.setPreferenceStore(this.createCombinedPreferenceStore());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId(EDITOR_CONTEXT_MENU_ID);
        this.initializeDocumentProvider(null);
        String helpId = this.getHelpContextId();
        if (helpId == null || "org.eclipse.ui.text_editor_context".equals(helpId)) {
            helpId = "org.eclipse.wst.sse.ui.xmlm2000";
        }
        this.setHelpContextId(helpId);
        this.configureInsertMode(SMART_INSERT, true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{EDITOR_KEYBINDING_SCOPE_ID});
    }

    private void initializeSourceViewer() {
        IAction openHyperlinkAction;
        if (this.getViewerSelectionManager() != null) {
            this.getViewerSelectionManager().setModel(this.getInternalModel());
        }
        this.computeAndSetDoubleClickAction(this.getInternalModel());
        IAction contentAssistAction = this.getAction("ContentAssistProposals");
        if (contentAssistAction instanceof IUpdate) {
            ((IUpdate)contentAssistAction).update();
        }
        if ((openHyperlinkAction = this.getAction("OpenFileFromSource")) instanceof OpenHyperlinkAction) {
            ((OpenHyperlinkAction)openHyperlinkAction).setHyperlinkDetectors(this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer()));
        }
        if (this.isFoldingEnabled()) {
            this.installProjectionSupport();
        }
    }

    void initializeSourceViewerConfiguration(StructuredTextViewerConfiguration configuration) {
        IFile file;
        configuration.setEditorPart((IEditorPart)this);
        configuration.setPreferenceStore(this.getPreferenceStore());
        IProject resource = null;
        IEditorInput iEditorInput = this.getEditorInput();
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)iEditorInput.getAdapter((Class)clazz)) != null) {
            resource = file.getProject();
        }
        configuration.configureOn((IResource)resource);
    }

    protected void initSourceViewer(StructuredTextViewer sourceViewer) {
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        this.fMouseTracker = new MouseTracker();
        this.fMouseTracker.start((Control)sourceViewer.getTextWidget());
        this.initializeDrop((ITextViewer)sourceViewer);
    }

    protected void installEncodingSupport() {
    }

    private void installProjectionSupport() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        this.fProjectionSupport.install();
        IStructuredTextFoldingProvider updater = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (updater == null && i < ids.length) {
            updater = (IStructuredTextFoldingProvider)builder.getConfiguration("structuredtextfoldingprovider", ids[i]);
            ++i;
        }
        this.fProjectionModelUpdater = updater;
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install(projectionViewer);
        }
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("foldingEnabled") && System.getProperty("org.eclipse.wst.sse.ui.foldingenabled") != null;
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.getInternalModel() == null) {
            return false;
        }
        return this.getInternalModel().isSaveNeeded();
    }

    private void logUnexpectedDocumentKind(IEditorInput input) {
        Logger.log(2, "StructuredTextEditor being used without StructuredDocument");
        String name = null;
        name = input != null ? input.getName() : "input was null";
        Logger.log(2, "         Input Name: " + name);
        String implClass = null;
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        implClass = document != null ? document.getClass().getName() : "document was null";
        Logger.log(2, "        Unexpected IDocument implementation: " + implClass);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install(projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            projectionViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        projectionViewer.setRedraw(true);
    }

    public void rememberSelection() {
        super.rememberSelection();
    }

    private void resetBusyState() {
        if (this.fBusyTimer != null) {
            this.fBusyTimer.cancel();
        }
        this.startBusyTimer();
    }

    public void restoreSelection() {
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            super.restoreSelection();
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        IStructuredModel internalModel = this.getInternalModel();
        if (internalModel != null) {
            boolean debuggingAvailable = BreakpointProviderBuilder.getInstance().isAvailable(internalModel.getContentTypeIdentifier(), BreakpointRulerAction.getFileExtension(this.getEditorInput()));
            if (debuggingAvailable) {
                menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.toggle"));
                menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.manage"));
                menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.edit"));
                menu.add((IContributionItem)new Separator());
            }
            super.rulerContextMenuAboutToShow(menu);
            this.addExtendedRulerContextMenuActions(menu);
        }
    }

    public void safelySanityCheckState(IEditorInput input) {
        super.safelySanityCheckState(input);
    }

    private void savedModel() {
        if (this.getInternalModel() != null) {
            this.getInternalModel().changedModel();
        }
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        super.selectAndReveal(selectionStart, selectionLength, revealStart, revealLength);
        this.getTextViewer().notifyViewerSelectionManager(selectionStart, selectionLength);
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IStructuredModel) {
            this.setDocumentProvider(StructuredModelDocumentProvider.getInstance());
        } else if (input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput)) {
            this.setDocumentProvider(StorageModelProvider.getInstance());
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.fEditorPart = editorPart;
    }

    public void setHelpContextId(String helpContextId) {
        super.setHelpContextId(helpContextId);
        if (this.getHelpContextId() != null && this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            IWorkbenchHelpSystem helpSystem = SSEUIPlugin.getDefault().getWorkbench().getHelpSystem();
            helpSystem.setHelp((Control)this.getSourceViewer().getTextWidget(), this.getHelpContextId());
        }
    }

    public void setModel(IFileEditorInput input) {
        this.setInput((IEditorInput)input);
    }

    private void setModel(IStructuredModel newModel) {
        Assert.isNotNull(this.getDocumentProvider(), "document provider can not be null when setting model");
        if (this.fStructuredModel != null) {
            if (this.fStructuredModel.getStructuredDocument() != null) {
                this.fStructuredModel.getStructuredDocument().removeDocumentListener(this.getInternalDocumentListener());
            }
            this.fStructuredModel.removeModelStateListener((IModelStateListener)this.getInternalModelStateListener());
        }
        this.fStructuredModel = newModel;
        if (this.fStructuredModel != null) {
            if (this.fStructuredModel.getStructuredDocument() != null) {
                this.fStructuredModel.getStructuredDocument().addDocumentListener(this.getInternalDocumentListener());
            }
            this.fStructuredModel.addModelStateListener((IModelStateListener)this.getInternalModelStateListener());
        }
        this.update();
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration config) {
        super.setSourceViewerConfiguration(config);
        StructuredTextViewer stv = this.getTextViewer();
        if (stv != null) {
            stv.unconfigure();
            stv.configure(config);
        }
    }

    public void showBusy(boolean busy) {
        if (busy) {
            this.fRememberTitle = this.getPartName();
            this.setPartName(SSEUIMessages.busy);
        } else {
            this.setPartName(this.fRememberTitle);
        }
    }

    private void startBusyTimer() {
        this.fBusyTimer = new Timer(true);
        this.fBusyTimer.schedule((TimerTask)new TimeOutExpired(), 1000L);
    }

    private void statusError(IStatus status) {
        this.statusError(status.getMessage());
        ErrorDialog.openError((Shell)this.getSite().getShell(), null, null, (IStatus)status);
    }

    private void statusError(String message) {
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager == null) {
            return;
        }
        manager.setErrorMessage(message);
        this.getSite().getShell().getDisplay().beep();
    }

    public void update() {
        IExtendedConfiguration cfg;
        if (this.fOutlinePage != null && this.fOutlinePage instanceof StructuredTextEditorContentOutlinePage) {
            cfg = this.createContentOutlineConfiguration();
            if (cfg instanceof StructuredContentOutlineConfiguration) {
                ((StructuredContentOutlineConfiguration)cfg).setEditor(this);
            }
            ((StructuredTextEditorContentOutlinePage)this.fOutlinePage).setModel(this.getInternalModel());
            ((StructuredTextEditorContentOutlinePage)this.fOutlinePage).setViewerSelectionManager(this.getViewerSelectionManager());
            ((StructuredTextEditorContentOutlinePage)this.fOutlinePage).setConfiguration((ContentOutlineConfiguration)cfg);
        }
        if (this.fPropertySheetPage != null && this.fPropertySheetPage instanceof ConfigurablePropertySheetPage) {
            cfg = this.createPropertySheetConfiguration();
            if (cfg instanceof StructuredPropertySheetConfiguration) {
                ((StructuredPropertySheetConfiguration)cfg).setEditor((IEditorPart)this);
            }
            ((ConfigurablePropertySheetPage)this.fPropertySheetPage).setModel(this.getInternalModel());
            ((ConfigurablePropertySheetPage)this.fPropertySheetPage).setViewerSelectionManager(this.getViewerSelectionManager());
            ((ConfigurablePropertySheetPage)this.fPropertySheetPage).setConfiguration((PropertySheetConfiguration)cfg);
        }
        if (this.getViewerSelectionManager() != null) {
            this.getViewerSelectionManager().setModel(this.getInternalModel());
        }
        this.disposeModelDependentFields();
        this.fShowInTargetIds = this.createShowInTargetIds();
        this.updateSourceViewerConfiguration();
        this.createModelDependentFields();
        this.computeAndSetDoubleClickAction(this.getInternalModel());
    }

    protected void updateContentDependentActions() {
        super.updateContentDependentActions();
        if (!this.fEditorDisposed) {
            this.updateMenuText();
        }
    }

    private void updateEncodingMemento() {
        boolean failed = false;
        IStructuredModel internalModel = this.getInternalModel();
        if (internalModel != null) {
            IStructuredDocument doc = internalModel.getStructuredDocument();
            EncodingMemento memento = doc.getEncodingMemento();
            IDocumentCharsetDetector detector = internalModel.getModelHandler().getEncodingDetector();
            if (memento != null && detector != null) {
                detector.set((IDocument)doc);
            }
            try {
                detector.getEncoding();
            }
            catch (IOException iOException) {
                failed = true;
            }
            if (!failed) {
                doc.setEncodingMemento(memento);
            }
        }
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    protected void updateMenuText() {
        if (this.fStructuredModel != null && !this.fStructuredModel.isModelStateChanging() && this.getTextViewer().getTextWidget() != null) {
            String previousUndoText = null;
            String previousUndoDesc = null;
            String previousRedoText = null;
            String previousRedoDesc = null;
            boolean updateActions = false;
            IAction undoAction = this.getAction(ITextEditorActionConstants.UNDO);
            IAction redoAction = this.getAction(ITextEditorActionConstants.REDO);
            if (undoAction != null) {
                previousUndoText = undoAction.getText();
                previousUndoDesc = undoAction.getDescription();
                updateActions = updateActions || previousUndoText == null || previousUndoDesc == null;
                undoAction.setText(UNDO_ACTION_TEXT_DEFAULT);
                undoAction.setDescription(UNDO_ACTION_DESC_DEFAULT);
            }
            if (redoAction != null) {
                previousRedoText = redoAction.getText();
                previousRedoDesc = redoAction.getDescription();
                updateActions = updateActions || previousRedoText == null || previousRedoDesc == null;
                redoAction.setText(REDO_ACTION_TEXT_DEFAULT);
                redoAction.setDescription(REDO_ACTION_DESC_DEFAULT);
            }
            if (this.fStructuredModel.getUndoManager() != null) {
                IStructuredTextUndoManager undoManager = this.fStructuredModel.getUndoManager();
                Command undoCommand = undoManager.getUndoCommand();
                undoAction.setEnabled(undoManager.undoable());
                if (undoCommand != null) {
                    String desc;
                    String label = undoCommand.getLabel();
                    if (label != null) {
                        String customText = MessageFormat.format(UNDO_ACTION_TEXT, label);
                        updateActions = updateActions || customText == null || previousUndoText == null || !customText.equals(previousUndoText);
                        undoAction.setText(customText);
                    }
                    if ((desc = undoCommand.getDescription()) != null) {
                        String customDesc = MessageFormat.format(UNDO_ACTION_DESC, desc);
                        updateActions = updateActions || customDesc == null || previousRedoDesc == null || !customDesc.equals(previousUndoDesc);
                        undoAction.setDescription(customDesc);
                    }
                }
                Command redoCommand = undoManager.getRedoCommand();
                redoAction.setEnabled(undoManager.redoable());
                if (redoCommand != null) {
                    String desc;
                    String label = redoCommand.getLabel();
                    if (label != null) {
                        String customText = MessageFormat.format(REDO_ACTION_TEXT, label);
                        updateActions = updateActions || customText == null || previousRedoText == null || !customText.equals(previousRedoText);
                        redoAction.setText(customText);
                    }
                    if ((desc = redoCommand.getDescription()) != null) {
                        String customDesc = MessageFormat.format(REDO_ACTION_DESC, desc);
                        updateActions = updateActions || customDesc == null || previousRedoDesc == null || !customDesc.equals(previousRedoDesc);
                        redoAction.setDescription(customDesc);
                    }
                }
            }
            if (updateActions) {
                if (this.getEditorSite().getActionBars() != null) {
                    this.getEditorSite().getActionBars().updateActionBars();
                } else if (this.getEditorPart() != null && this.getEditorPart().getEditorSite().getActionBars() != null) {
                    this.getEditorPart().getEditorSite().getActionBars().updateActionBars();
                }
            }
        }
    }

    private void updateSourceViewerConfiguration() {
        Object configuration = this.getSourceViewerConfiguration();
        if (configuration == null) {
            return;
        }
        if (!(configuration instanceof StructuredTextViewerConfiguration)) {
            configuration = this.createSourceViewerConfiguration();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
        } else {
            StructuredTextViewerConfiguration newViewerConfiguration = this.createSourceViewerConfiguration();
            if (!((StructuredTextViewerConfiguration)configuration).getDeclaringID().equals(newViewerConfiguration.getDeclaringID())) {
                configuration = newViewerConfiguration;
                this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
            }
            IFile resource = null;
            if (this.getEditorInput() instanceof IFileEditorInput) {
                resource = ((IFileEditorInput)this.getEditorInput()).getFile();
                if (resource.getType() != 4) {
                    resource = resource.getProject();
                }
                ((StructuredTextViewerConfiguration)configuration).configureOn((IResource)resource);
            }
        }
        if (this.getSourceViewer() != null) {
            IAction openHyperlinkAction;
            this.getSourceViewer().configure(configuration);
            IAction contentAssistAction = this.getAction("ContentAssistProposals");
            if (contentAssistAction instanceof IUpdate) {
                ((IUpdate)contentAssistAction).update();
            }
            if ((openHyperlinkAction = this.getAction("OpenFileFromSource")) instanceof OpenHyperlinkAction) {
                ((OpenHyperlinkAction)openHyperlinkAction).setHyperlinkDetectors(this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer()));
            }
        }
    }

    protected void updateStatusField(String category) {
        IStatusField field;
        super.updateStatusField(category);
        if (category == null) {
            return;
        }
        if ("Offset".equals(category) && (field = this.getStatusField(category)) != null) {
            Point selection = this.getTextViewer().getTextWidget().getSelection();
            int offset1 = StructuredTextEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)selection.x);
            int offset2 = StructuredTextEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)selection.y);
            String text = null;
            text = offset1 != offset2 ? "[" + offset1 + "-" + offset2 + "]" : "[ " + offset1 + " ]";
            field.setText(text == null ? this.fErrorLabel : text);
        }
    }

    public IStatus validateEdit(Shell context) {
        IStatus status = STATUS_OK;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            if (input == null) {
                String msg = SSEUIMessages.Error_opening_file_UI_;
                status = new Status(4, "org.eclipse.wst.sse.ui", 1, msg, null);
            } else {
                this.validateState(input);
                this.sanityCheckState(input);
                if (this.isEditorInputReadOnly()) {
                    String fname = input.getName();
                    if (input instanceof IStorageEditorInput) {
                        try {
                            IStorage s = ((IStorageEditorInput)input).getStorage();
                            if (s != null) {
                                IPath path = s.getFullPath();
                                fname = path != null ? String.valueOf(fname) + path.toString() : String.valueOf(fname) + s.getName();
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    String msg = NLS.bind((String)SSEUIMessages._UI_File_is_read_only, (Object[])new Object[]{fname});
                    status = new Status(4, "org.eclipse.wst.sse.ui", 1, msg, null);
                }
            }
        }
        return status;
    }

    protected void validateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            try {
                boolean wasReadOnly = this.isEditorInputReadOnly();
                extension.validateState((Object)input, (Object)this.getSite().getShell());
                if (this.getSourceViewer() != null) {
                    this.getSourceViewer().setEditable(this.isEditable());
                }
                if (wasReadOnly != this.isEditorInputReadOnly()) {
                    this.updateStateDependentActions();
                }
            }
            catch (CoreException x) {
                ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.ui"));
                log.log(x.getStatus());
                this.statusError(x.getStatus());
            }
        }
    }

    static /* synthetic */ boolean access$1(StructuredTextEditor structuredTextEditor) {
        return structuredTextEditor.fEditorDisposed;
    }

    static /* synthetic */ void access$5(StructuredTextEditor structuredTextEditor, boolean bl) {
        structuredTextEditor.fUpdateMenuTextPending = bl;
    }

    static /* synthetic */ void access$6(StructuredTextEditor structuredTextEditor) {
        structuredTextEditor.endBusyStateInternal();
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            StructuredTextEditor.this.fDirtyBeforeDocumentEvent = StructuredTextEditor.this.isDirty();
        }

        public void documentChanged(DocumentEvent event) {
            if (StructuredTextEditor.this.isEditorInputReadOnly()) {
                int offset = event.getOffset() + event.getLength();
                IStructuredModel internalModel = StructuredTextEditor.this.getInternalModel();
                StructuredTextEditor.this.fCurrentRunnable = new Runnable(this, internalModel, offset){
                    final /* synthetic */ InternalDocumentListener this$1;
                    private final /* synthetic */ IStructuredModel val$internalModel;
                    private final /* synthetic */ int val$offset;
                    {
                        this.this$1 = internalDocumentListener;
                        this.val$internalModel = iStructuredModel;
                        this.val$offset = n;
                    }

                    public void run() {
                        IStatus status;
                        if (!(StructuredTextEditor.access$1(InternalDocumentListener.access$0(this.this$1)) || (status = InternalDocumentListener.access$0(this.this$1).validateEdit(InternalDocumentListener.access$0(this.this$1).getSite().getShell())) != null && status.isOK() || this.val$internalModel == null)) {
                            this.val$internalModel.getUndoManager().undo();
                            StructuredTextEditor.access$2(InternalDocumentListener.access$0(this.this$1)).setSelectedRange(this.val$offset, 0);
                            if (!InternalDocumentListener.access$0((InternalDocumentListener)this.this$1).fDirtyBeforeDocumentEvent) {
                                this.val$internalModel.setDirtyState(false);
                            }
                        }
                        InternalDocumentListener.access$0((InternalDocumentListener)this.this$1).fCurrentRunnable = null;
                    }
                };
                Display display = StructuredTextEditor.this.getDisplay();
                if (display != null) {
                    if (Thread.currentThread() != display.getThread()) {
                        display.asyncExec(StructuredTextEditor.this.fCurrentRunnable);
                    } else {
                        StructuredTextEditor.this.fCurrentRunnable.run();
                    }
                }
            }
        }

        static /* synthetic */ StructuredTextEditor access$0(InternalDocumentListener internalDocumentListener) {
            return internalDocumentListener.StructuredTextEditor.this;
        }
    }

    class InternalElementStateListener
    implements IElementStateListener {
        InternalElementStateListener() {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementDeleted(Object element) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    }

    class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
            StructuredTextEditor.this.getTextViewer();
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
            if (StructuredTextEditor.this.getTextViewer() != null) {
                StructuredTextEditor.this.getTextViewer().unconfigure();
                SourceViewerConfiguration config = StructuredTextEditor.this.getSourceViewerConfiguration();
                if (config instanceof StructuredTextViewerConfiguration) {
                    ((StructuredTextViewerConfiguration)config).unConfigure(StructuredTextEditor.this.getSourceViewer());
                }
            }
        }

        public void modelChanged(IStructuredModel model) {
            if (StructuredTextEditor.this.getTextViewer() != null && !StructuredTextEditor.this.fUpdateMenuTextPending) {
                this.runOnDisplayThreadIfNeededed(new Runnable(this){
                    final /* synthetic */ InternalModelStateListener this$1;
                    {
                        this.this$1 = internalModelStateListener;
                    }

                    public void run() {
                        InternalModelStateListener.access$0(this.this$1).updateMenuText();
                        StructuredTextEditor.access$5(InternalModelStateListener.access$0(this.this$1), false);
                    }
                });
            }
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void modelReinitialized(IStructuredModel structuredModel) {
            try {
                try {
                    if (StructuredTextEditor.this.getSourceViewer() != null) {
                        SourceViewerConfiguration cfg = StructuredTextEditor.this.getSourceViewerConfiguration();
                        if (cfg != null && cfg instanceof StructuredTextViewerConfiguration) {
                            StructuredTextEditor.this.initializeSourceViewerConfiguration((StructuredTextViewerConfiguration)cfg);
                        }
                        StructuredTextEditor.this.getSourceViewer().configure(cfg);
                    }
                }
                catch (Exception e) {
                    Logger.logException("problem trying to configure after model change", e);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ((ITextViewerExtension)StructuredTextEditor.this.getSourceViewer()).setRedraw(true);
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            ((ITextViewerExtension)StructuredTextEditor.this.getSourceViewer()).setRedraw(true);
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel originalmodel, IStructuredModel movedmodel) {
        }

        private void runOnDisplayThreadIfNeededed(Runnable r) {
            if (StructuredTextEditor.this.getDisplay() == null || Thread.currentThread() == StructuredTextEditor.this.getDisplay().getThread()) {
                r.run();
            } else {
                StructuredTextEditor.this.getDisplay().asyncExec(r);
            }
        }

        static /* synthetic */ StructuredTextEditor access$0(InternalModelStateListener internalModelStateListener) {
            return internalModelStateListener.StructuredTextEditor.this;
        }
    }

    class MouseTracker
    extends MouseTrackAdapter
    implements MouseMoveListener {
        private Control fSubjectControl;

        public void mouseHover(MouseEvent event) {
            StructuredTextEditor.this.hoverX = event.x;
            StructuredTextEditor.this.hoverY = event.y;
        }

        public void mouseMove(MouseEvent e) {
            StructuredTextEditor.this.hoverX = e.x;
            StructuredTextEditor.this.hoverY = e.y;
        }

        public void start(Control subjectControl) {
            this.fSubjectControl = subjectControl;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.addMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl.addDisposeListener(new DisposeListener(this){
                    final /* synthetic */ MouseTracker this$1;
                    {
                        this.this$1 = mouseTracker;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        this.this$1.stop();
                    }
                });
            }
        }

        public void stop() {
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.removeMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl = null;
            }
        }
    }

    class ShowInTargetListAdapter
    implements IShowInTargetList {
        ShowInTargetListAdapter() {
        }

        public String[] getShowInTargetIds() {
            return StructuredTextEditor.this.fShowInTargetIds;
        }
    }

    class TimeOutExpired
    extends TimerTask {
        TimeOutExpired() {
        }

        public void run() {
            StructuredTextEditor.this.getDisplay().syncExec(new Runnable(this){
                final /* synthetic */ TimeOutExpired this$1;
                {
                    this.this$1 = timeOutExpired;
                }

                public void run() {
                    if (TimeOutExpired.access$0(this.this$1).getDisplay() != null && !TimeOutExpired.access$0(this.this$1).getDisplay().isDisposed()) {
                        StructuredTextEditor.access$6(TimeOutExpired.access$0(this.this$1));
                    }
                }
            });
        }

        static /* synthetic */ StructuredTextEditor access$0(TimeOutExpired timeOutExpired) {
            return timeOutExpired.StructuredTextEditor.this;
        }
    }
}

