/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.IExtendedConfiguration;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.contentassist.IResourceDependentProcessor;
import org.eclipse.wst.sse.ui.internal.editor.HTMLTextPresenter;
import org.eclipse.wst.sse.ui.internal.hyperlink.HighlighterHyperlinkPresenter;
import org.eclipse.wst.sse.ui.internal.provisional.StructuredTextViewerUndoManager;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredRegionProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorBuilder;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorStrategy;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.Assert;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class StructuredTextViewerConfiguration
extends TextSourceViewerConfiguration
implements IExtendedConfiguration {
    private static final String CONTENT_ASSIST_PROCESSOR_EXTENDED_ID = "contentassistprocessor";
    public static final String ID = "textviewerconfiguration";
    protected String[] configuredContentTypes;
    protected IEditorPart editorPart;
    private IAnnotationHover fAnnotationHover = null;
    protected IContentAssistant fContentAssistant;
    private List fContentAssistProcessors = new ArrayList();
    protected IContentAssistant fCorrectionAssistant;
    private String fDeclaringID;
    protected IHighlighter fHighlighter;
    protected StructuredRegionProcessor fReconciler;
    protected IResource fResource = null;
    protected final String SSE_EDITOR_ID = "org.eclipse.wst.sse.ui";
    protected final String SSE_MODEL_ID = "org.eclipse.wst.sse.core";
    static /* synthetic */ Class class$0;

    public StructuredTextViewerConfiguration(IPreferenceStore store) {
        super(store);
    }

    public StructuredTextViewerConfiguration() {
    }

    public StructuredTextViewerConfiguration(IEditorPart textEditor) {
        this();
        this.editorPart = textEditor;
    }

    public void configureOn(IResource resource) {
        this.fResource = resource;
        this.updateForResource();
    }

    protected ValidatorStrategy createValidatorStrategy(String contentTypeId) {
        ValidatorStrategy validatorStrategy = new ValidatorStrategy(this.getTextEditor(), contentTypeId);
        ValidatorBuilder vBuilder = new ValidatorBuilder();
        ValidatorMetaData[] vmds = vBuilder.getValidatorMetaData("org.eclipse.wst.sse.ui");
        int i = 0;
        while (i < vmds.length) {
            if (vmds[i].canHandleContentType(contentTypeId)) {
                validatorStrategy.addValidatorMetaData(vmds[i]);
            }
            ++i;
        }
        return validatorStrategy;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new StructuredTextAnnotationHover();
        }
        return this.fAnnotationHover;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "org.eclipse.wst.sse.core.default_structured_text_partitioning";
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = EditorUtility.computeStateMask(hoverDescs[i].getModifierString());
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fContentAssistant == null) {
            ContentAssistant assistant = new ContentAssistant(){
                private Map fExtendedProcessors = new HashMap(0);

                public IContentAssistProcessor getContentAssistProcessor(String contentType) {
                    IContentAssistProcessor processor = super.getContentAssistProcessor(contentType);
                    if (processor == null && !this.fExtendedProcessors.containsKey(contentType)) {
                        processor = (IContentAssistProcessor)ExtendedConfigurationBuilder.getInstance().getConfiguration(StructuredTextViewerConfiguration.CONTENT_ASSIST_PROCESSOR_EXTENDED_ID, contentType);
                        this.fExtendedProcessors.put(contentType, processor);
                        StructuredTextViewerConfiguration.this.fContentAssistProcessors.add(processor);
                        if (processor instanceof IResourceDependentProcessor) {
                            ((IResourceDependentProcessor)processor).initialize(StructuredTextViewerConfiguration.this.fResource);
                        }
                        this.setContentAssistProcessor(processor, contentType);
                    }
                    return processor;
                }
            };
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            assistant.enableAutoActivation(true);
            assistant.setAutoActivationDelay(500);
            assistant.setProposalPopupOrientation(10);
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            this.fContentAssistant = assistant;
        }
        this.updateForResource();
        return this.fContentAssistant;
    }

    public IContentAssistant getCorrectionAssistant(ISourceViewer sourceViewer) {
        if (this.fCorrectionAssistant == null) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fCorrectionAssistant = assistant;
        }
        this.updateForResource();
        return this.fCorrectionAssistant;
    }

    public String getDeclaringID() {
        return this.fDeclaringID;
    }

    protected IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public IHighlighter getHighlighter(ISourceViewer viewer) {
        IDocument doc;
        if (this.fHighlighter != null) {
            this.fHighlighter.uninstall();
        } else {
            Highlighter highlighter = new Highlighter();
            highlighter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(viewer));
            this.fHighlighter = highlighter;
        }
        if (viewer != null && (doc = viewer.getDocument()) instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            this.fHighlighter.setDocument(structuredDocument);
        }
        return this.fHighlighter;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 0;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    protected IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer arg0) {
        return new StructuredTextAnnotationHover();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    protected ITextEditor getTextEditor() {
        ITextEditor editor = null;
        if (this.editorPart instanceof ITextEditor) {
            editor = (ITextEditor)this.editorPart;
        }
        if (editor == null && this.editorPart != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            editor = (ITextEditor)this.editorPart.getAdapter((Class)clazz);
        }
        return editor;
    }

    protected TextHoverManager.TextHoverDescriptor[] getTextHovers() {
        return SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return new StructuredTextViewerUndoManager();
    }

    protected void setContentAssistProcessor(ContentAssistant ca, IContentAssistProcessor newProcessor, String partitionType) {
        IContentAssistProcessor previousProcessor = ca.getContentAssistProcessor(partitionType);
        if (previousProcessor != null) {
            if (previousProcessor instanceof IReleasable) {
                ((IReleasable)previousProcessor).release();
            }
            this.fContentAssistProcessors.remove(previousProcessor);
        }
        this.fContentAssistProcessors.add(newProcessor);
        if (newProcessor instanceof IResourceDependentProcessor) {
            ((IResourceDependentProcessor)newProcessor).initialize(this.fResource);
        }
        ca.setContentAssistProcessor(newProcessor, partitionType);
    }

    public void setDeclaringID(String targetID) {
        this.fDeclaringID = targetID;
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public void unConfigure(ISourceViewer viewer) {
        this.editorPart = null;
        if (this.fHighlighter != null) {
            this.fHighlighter.uninstall();
        }
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
        }
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
        }
        if (this.fContentAssistant != null) {
            this.unconfigureContentAssistProcessors();
        }
        if (this.fAnnotationHover != null && this.fAnnotationHover instanceof IReleasable) {
            ((IReleasable)this.fAnnotationHover).release();
        }
    }

    private void unconfigureContentAssistProcessors() {
        if (!this.fContentAssistProcessors.isEmpty()) {
            Iterator it = this.fContentAssistProcessors.iterator();
            IContentAssistProcessor p = null;
            while (it.hasNext()) {
                p = (IContentAssistProcessor)it.next();
                if (!(p instanceof IReleasable)) continue;
                ((IReleasable)p).release();
            }
        }
    }

    protected void updateForResource() {
        if (!this.fContentAssistProcessors.isEmpty()) {
            Iterator it = this.fContentAssistProcessors.iterator();
            IContentAssistProcessor p = null;
            while (it.hasNext()) {
                p = (IContentAssistProcessor)it.next();
                if (!(p instanceof IResourceDependentProcessor)) continue;
                ((IResourceDependentProcessor)p).initialize(this.fResource);
            }
        }
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getHyperlinkPresenter(sourceViewer);
        }
        return new HighlighterHyperlinkPresenter(this.fPreferenceStore);
    }

    public void setPreferenceStore(IPreferenceStore store) {
        Assert.isLegal(this.fPreferenceStore == null || this.fPreferenceStore == store, "TextSourceViewerConfiguration's preference store may only be set once");
        this.fPreferenceStore = store;
    }
}

