/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapterFactory;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;

public class StructuredContentOutlineConfiguration
extends ContentOutlineConfiguration {
    protected ImageDescriptor COLLAPSE_D = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/collapseall.gif");
    protected ImageDescriptor COLLAPSE_E = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/collapseall.gif");
    private StructuredTextEditor fEditor = null;
    private boolean fIsLinkWithEditor = false;
    private Map fMenuContributions = null;
    private Map fToolbarContributions = null;
    private final String OUTLINE_LINK_PREF = "outline-link-editor";
    ImageDescriptor SYNCED_D = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/synced.gif");
    ImageDescriptor SYNCED_E = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/synced.gif");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        PropertyChangeUpdateActionContributionItem toggleLinkItem = new PropertyChangeUpdateActionContributionItem(new ToggleLinkAction(this.getPreferenceStore(), "outline-link-editor"));
        IContributionItem[] items = super.getMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{toggleLinkItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = toggleLinkItem;
            items = combinedItems;
        }
        return items;
    }

    protected IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        ActionContributionItem collapseAllItem = new ActionContributionItem((IAction)new CollapseTreeAction(viewer));
        IContributionItem[] items = super.getToolbarContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{collapseAllItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = collapseAllItem;
            items = combinedItems;
        }
        return items;
    }

    public Object getAdapter(Class key) {
        Object adapter = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            adapter = new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext((Object)StructuredContentOutlineConfiguration.this.getEditor().getEditorInput(), StructuredContentOutlineConfiguration.this.getEditor().getSelectionProvider().getSelection());
                }
            };
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = key.equals(clazz2) ? this.getEditor().getAdapter(key) : super.getAdapter(key);
        }
        return adapter;
    }

    public IDoubleClickListener getDoubleClickListener(TreeViewer viewer) {
        StructuredTextEditor structuredTextEditor = this.getEditor();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.sse.ui.internal.ViewerSelectionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ViewerSelectionManager)structuredTextEditor.getAdapter(clazz);
    }

    public StructuredTextEditor getEditor() {
        return this.fEditor;
    }

    protected IJFaceNodeAdapterFactory getFactory() {
        IJFaceNodeAdapterFactory adapterFactory;
        FactoryRegistry factoryRegistry = this.getEditor().getModel().getFactoryRegistry();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapterFactory = (IJFaceNodeAdapterFactory)factoryRegistry.getFactoryFor((Object)clazz)) == null) {
            Logger.log(4, "model has no JFace adapter factory");
        }
        return adapterFactory;
    }

    public final IContributionItem[] getMenuContributions(TreeViewer viewer) {
        IContributionItem[] items;
        if (this.fMenuContributions == null) {
            this.fMenuContributions = new HashMap();
        }
        if ((items = (IContributionItem[])this.fMenuContributions.get(viewer)) == null) {
            items = this.createMenuContributions(viewer);
            this.fMenuContributions.put(viewer, items);
        }
        return items;
    }

    public List getSelectedNodes(NodeSelectionChangedEvent event) {
        if (this.isLinkedWithEditor()) {
            return super.getSelectedNodes(event);
        }
        return null;
    }

    public ISelectionChangedListener getSelectionChangedListener(TreeViewer viewer) {
        StructuredTextEditor structuredTextEditor = this.getEditor();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.sse.ui.internal.ViewerSelectionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ViewerSelectionManager)structuredTextEditor.getAdapter(clazz);
    }

    public final IContributionItem[] getToolbarContributions(TreeViewer viewer) {
        IContributionItem[] items;
        if (this.fToolbarContributions == null) {
            this.fToolbarContributions = new HashMap();
        }
        if ((items = (IContributionItem[])this.fToolbarContributions.get(viewer)) == null) {
            items = this.createToolbarContributions(viewer);
            this.fToolbarContributions.put(viewer, items);
        }
        return items;
    }

    protected boolean isLinkedWithEditor() {
        return this.fIsLinkWithEditor;
    }

    public boolean isLinkedWithEditor(TreeViewer treeViewer) {
        return this.isLinkedWithEditor();
    }

    public void setEditor(StructuredTextEditor editor) {
        this.fEditor = editor;
    }

    protected void setLinkWithEditor(boolean isLinkWithEditor) {
        this.fIsLinkWithEditor = isLinkWithEditor;
    }

    public void unconfigure(TreeViewer viewer) {
        int i;
        IContributionItem[] items;
        super.unconfigure(viewer);
        if (this.fToolbarContributions != null && (items = (IContributionItem[])this.fToolbarContributions.get(viewer)) != null) {
            i = 0;
            while (i < items.length) {
                if (items[i] instanceof PropertyChangeUpdateActionContributionItem) {
                    ((PropertyChangeUpdateActionContributionItem)items[i]).disconnect();
                }
                ++i;
            }
            this.fToolbarContributions.remove(viewer);
        }
        if (this.fMenuContributions != null && (items = (IContributionItem[])this.fMenuContributions.get(viewer)) != null) {
            i = 0;
            while (i < items.length) {
                if (items[i] instanceof PropertyChangeUpdateActionContributionItem) {
                    ((PropertyChangeUpdateActionContributionItem)items[i]).disconnect();
                }
                ++i;
            }
            this.fMenuContributions.remove(viewer);
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return SSEUIPlugin.getInstance().getPreferenceStore();
    }

    private class CollapseTreeAction
    extends Action {
        private TreeViewer fTreeViewer = null;

        public CollapseTreeAction(TreeViewer viewer) {
            super(SSEUIMessages.StructuredContentOutlineConfiguration_0, 1);
            this.setImageDescriptor(StructuredContentOutlineConfiguration.this.COLLAPSE_E);
            this.setDisabledImageDescriptor(StructuredContentOutlineConfiguration.this.COLLAPSE_D);
            this.setToolTipText(this.getText());
            this.fTreeViewer = viewer;
        }

        public void run() {
            super.run();
            this.fTreeViewer.collapseAll();
        }
    }

    private class ToggleLinkAction
    extends PropertyChangeUpdateAction {
        public ToggleLinkAction(IPreferenceStore store, String preference) {
            super(SSEUIMessages.StructuredContentOutlineConfiguration_1, store, preference, true);
            this.setToolTipText(this.getText());
            this.setDisabledImageDescriptor(StructuredContentOutlineConfiguration.this.SYNCED_D);
            this.setImageDescriptor(StructuredContentOutlineConfiguration.this.SYNCED_E);
            this.update();
        }

        public void update() {
            super.update();
            StructuredContentOutlineConfiguration.this.setLinkWithEditor(this.isChecked());
        }
    }
}

