/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class DirtyRegionProcessor
extends Job
implements IReconciler {
    protected static final boolean DEBUG;
    private static final long UPDATE_DELAY = 750L;
    private long fDelay;
    private List fDirtyRegionQueue = Collections.synchronizedList(new ArrayList());
    private IDocument fDocument = null;
    private boolean fIsInstalled = false;
    private IProgressMonitor fLocalProgressMonitor = null;
    private String fPartitioning;
    private Map fStrategies = new HashMap();
    private List fStrategyTypes = new ArrayList();
    private ITextViewer fViewer;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public DirtyRegionProcessor() {
        super(SSEUIMessages.proc_dirty_regions_0);
        this.setPriority(30);
        this.setSystem(true);
        this.setLocalProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        this.setDelay(750L);
    }

    private synchronized void addRequest(DirtyRegion dr) {
        List drq = this.getDirtyRegionQueue();
        int size = drq.size();
        int i = 0;
        while (i < size) {
            if (this.contains((DirtyRegion)drq.get(i), dr)) {
                return;
            }
            ++i;
        }
        Iterator it = drq.iterator();
        while (it.hasNext()) {
            if (!this.contains(dr, (DirtyRegion)it.next())) continue;
            it.remove();
        }
        drq.add(dr);
    }

    protected ITypedRegion[] computePartitioning(DirtyRegion dirtyRegion) {
        IDocument doc = this.getDocument();
        ITypedRegion[] tr = null;
        int drOffset = dirtyRegion.getOffset();
        int drLength = dirtyRegion.getLength();
        int docLength = doc.getLength();
        if (drOffset > docLength) {
            drOffset = docLength;
            drLength = 0;
        } else if (drOffset + drLength > docLength) {
            drLength = docLength - drOffset;
        }
        try {
            tr = TextUtilities.computePartitioning((IDocument)doc, (String)this.getDocumentPartitioning(), (int)drOffset, (int)drLength, (boolean)true);
        }
        catch (BadLocationException e) {
            String info = "dr: [" + drOffset + ":" + drLength + "] doc: [" + docLength + "] ";
            Logger.logException(info, e);
            tr = new ITypedRegion[]{};
        }
        return tr;
    }

    protected boolean contains(DirtyRegion root, DirtyRegion possible) {
        int rootStart = root.getOffset();
        int rootEnd = rootStart + root.getLength();
        int possStart = possible.getOffset();
        int possEnd = possStart + possible.getLength();
        return rootStart <= possStart && rootEnd >= possEnd;
    }

    protected DirtyRegion createDirtyRegion(int offset, int length, String type) {
        DirtyRegion durty = null;
        IDocument doc = this.getDocument();
        if (doc != null) {
            int docLen = doc.getLength();
            if (offset > docLen) {
                offset = docLen;
                length = 0;
            } else if (offset + length >= docLen) {
                length = docLen - offset;
            }
            try {
                durty = new DirtyRegion(offset, length, type, doc.get(offset, length));
            }
            catch (BadLocationException e) {
                String info = "dr: [" + offset + ":" + length + "] doc: [" + docLen + "] ";
                Logger.logException(info, e);
            }
        }
        return durty;
    }

    protected DirtyRegion createDirtyRegion(ITypedRegion tr, String type) {
        return this.createDirtyRegion(tr.getOffset(), tr.getLength(), type);
    }

    protected long getDelay() {
        return this.fDelay;
    }

    protected List getDirtyRegionQueue() {
        return this.fDirtyRegionQueue;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public String getDocumentPartitioning() {
        if (this.fPartitioning == null) {
            return "__dftl_partitioning";
        }
        return this.fPartitioning;
    }

    IProgressMonitor getLocalProgressMonitor() {
        return this.fLocalProgressMonitor;
    }

    protected String[] getPartitions(DirtyRegion dirtyRegion) {
        ITypedRegion[] regions = null;
        int drOffset = dirtyRegion.getOffset();
        int drLength = dirtyRegion.getLength();
        int docLength = this.getDocument().getLength();
        if (drOffset > docLength) {
            drOffset = docLength;
            drLength = 0;
        } else if (drOffset + drLength > docLength) {
            drLength = docLength - drOffset;
        }
        try {
            regions = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)this.getDocumentPartitioning(), (int)dirtyRegion.getOffset(), (int)dirtyRegion.getLength(), (boolean)true);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            regions = new ITypedRegion[]{};
        }
        String[] partitions = new String[regions.length];
        int i = 0;
        while (i < regions.length) {
            partitions[i] = regions[i].getType();
            ++i;
        }
        return partitions;
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        if (this.fStrategies == null) {
            return null;
        }
        return (IReconcilingStrategy)this.fStrategies.get(contentType);
    }

    private synchronized DirtyRegion[] getRequests() {
        DirtyRegion[] toRefresh = this.fDirtyRegionQueue.toArray(new DirtyRegion[this.fDirtyRegionQueue.size()]);
        this.fDirtyRegionQueue.clear();
        return toRefresh;
    }

    protected IReconcilingStrategy getStrategy(DirtyRegion dirtyRegion) {
        String[] partitions = this.getPartitions(dirtyRegion);
        IReconcilingStrategy rs = null;
        if (partitions.length > 0) {
            rs = this.getReconcilingStrategy(partitions[0]);
        }
        return rs;
    }

    public List getStrategyTypes() {
        return this.fStrategyTypes;
    }

    protected ITextViewer getTextViewer() {
        return this.fViewer;
    }

    public void install(ITextViewer textViewer) {
        if (!this.isInstalled()) {
            this.fViewer = textViewer;
            this.getLocalProgressMonitor().setCanceled(false);
            this.setInstalled(true);
        }
    }

    public boolean isInstalled() {
        return this.fIsInstalled;
    }

    public void newModel(NewDocumentEvent structuredDocumentEvent) {
    }

    public void noChange(NoChangeEvent structuredDocumentEvent) {
    }

    protected void process(DirtyRegion dr) {
    }

    public final void processDirtyRegion(DirtyRegion dr) {
        if (dr == null) {
            return;
        }
        this.cancel();
        this.addRequest(dr);
        this.schedule(this.getDelay());
        if (DEBUG) {
            System.out.println("added request for: [" + dr.getText() + "]");
            System.out.println("queue size is now: " + this.getDirtyRegionQueue().size());
        }
    }

    protected void reconcilerDocumentChanged(IDocument document) {
        this.setDocument(document);
        this.setDocumentOnAllStrategies(document);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                DirtyRegion[] toRefresh = this.getRequests();
                int i = 0;
                while (i < toRefresh.length) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.process(toRefresh[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.logException("problem with as-you-type validation", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        monitor.done();
        return status;
    }

    protected void setDelay(long delay) {
        this.fDelay = delay;
    }

    public void setDocument(IDocument doc) {
        this.fDocument = doc;
        this.setDocumentOnAllStrategies(doc);
    }

    protected void setDocumentOnAllStrategies(IDocument document) {
        if (this.isInstalled() && this.fStrategies != null) {
            Iterator e = this.fStrategies.values().iterator();
            while (e.hasNext()) {
                IReconcilingStrategy strategy = (IReconcilingStrategy)e.next();
                strategy.setDocument(document);
            }
        }
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning;
    }

    public void setInstalled(boolean isInstalled) {
        this.fIsInstalled = isInstalled;
    }

    private void setLocalProgressMonitor(IProgressMonitor pm) {
        this.fLocalProgressMonitor = pm;
        List strategyTypes = this.getStrategyTypes();
        if (!strategyTypes.isEmpty()) {
            Iterator it = strategyTypes.iterator();
            String type = null;
            while (it.hasNext()) {
                type = (String)it.next();
                if (!(this.getReconcilingStrategy(type) instanceof IReconcilingStrategyExtension)) continue;
                ((IReconcilingStrategyExtension)this.getReconcilingStrategy(type)).setProgressMonitor(pm);
            }
        }
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy, String contentType) {
        if (strategy == null) {
            this.fStrategies.remove(contentType);
        } else {
            this.fStrategies.put(contentType, strategy);
            if (strategy instanceof IReconcilingStrategyExtension && this.getLocalProgressMonitor() != null) {
                ((IReconcilingStrategyExtension)strategy).setProgressMonitor(this.getLocalProgressMonitor());
            }
            strategy.setDocument(this.fDocument);
        }
        this.getStrategyTypes().add(contentType);
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.setInstalled(false);
            this.getLocalProgressMonitor().setCanceled(true);
        }
        this.setDocument(null);
    }
}

