/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ConnectorModule;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.JavaClientModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ObjectNotFoundException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.client.impl.ApplicationClientResourceFactory;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.common.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.ejb.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.internal.jca.impl.ConnectorResourceFactory;
import org.eclipse.jst.j2ee.internal.webapplication.impl.WebAppResourceFactory;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class EARFileImpl
extends ModuleFileImpl
implements EARFile {
    protected Application deploymentDescriptor = null;
    protected EList moduleRefs = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ModuleFile getModuleFile(Module moduleDescriptor) {
        ModuleRef ref = this.getModuleRef(moduleDescriptor);
        return ref == null ? null : ref.getModuleFile();
    }

    public ModuleFile addCopy(ModuleFile aModuleFile) throws DuplicateObjectException {
        Object result = this.primAddCopyRef(aModuleFile);
        if (result instanceof ModuleRef) {
            return ((ModuleRef)result).getModuleFile();
        }
        return (ModuleFile)result;
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getEARFile();
    }

    public Archive addCopy(Archive anArchive) throws DuplicateObjectException {
        if (anArchive.isModuleFile()) {
            return this.addCopy((ModuleFile)anArchive);
        }
        Archive copy = super.addCopy(anArchive);
        copy.initializeClassLoader();
        return copy;
    }

    protected Object primAddCopyRef(ModuleFile aModuleFile) throws DuplicateObjectException {
        EList refs = this.getModuleRefs();
        if (aModuleFile.isEARFile()) {
            return (ModuleFile)super.addCopy(aModuleFile);
        }
        this.checkAddValid(aModuleFile);
        ModuleFile copy = this.getCommonArchiveFactory().copy(aModuleFile);
        Module newModule = this.createModuleForCopying(aModuleFile);
        this.getFiles().add((Object)copy);
        copy.initializeClassLoader();
        if (!copy.getURI().equals(newModule.getUri())) {
            copy.setURI(newModule.getUri());
        }
        this.getDeploymentDescriptor().getModules().add((Object)newModule);
        ModuleRef aRef = this.createModuleRef(newModule, copy);
        refs.add((Object)aRef);
        return aRef;
    }

    public ModuleRef addCopyRef(ModuleFile aModuleFile) throws DuplicateObjectException {
        Object result = this.primAddCopyRef(aModuleFile);
        if (result instanceof ModuleRef) {
            return (ModuleRef)result;
        }
        return null;
    }

    public SecurityRole addCopy(SecurityRole aRole, Module aModule) throws DuplicateObjectException {
        EObject dd = null;
        try {
            dd = this.getDeploymentDescriptor(aModule);
        }
        catch (Exception e) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{aModule.getUri(), this.getURI()}), e);
        }
        String roleName = aRole.getRoleName();
        SecurityRole copy = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)aRole);
        if (aModule.isEjbModule()) {
            EJBJar ejbJar = (EJBJar)dd;
            if (ejbJar.containsSecurityRole(roleName)) {
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString("dup_sec_role_module_EXC_", new Object[]{aModule.getUri(), roleName}), ejbJar.getAssemblyDescriptor().getSecurityRoleNamed(roleName));
            }
            this.getAssemblyDescriptorAddIfNecessary(ejbJar).getSecurityRoles().add((Object)copy);
        } else if (aModule.isWebModule()) {
            WebApp webApp = (WebApp)dd;
            if (webApp.containsSecurityRole(roleName)) {
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString("dup_sec_role_module_EXC_", new Object[]{aModule.getUri(), roleName}), webApp.getSecurityRoleNamed(roleName));
            }
            webApp.getSecurityRoles().add((Object)copy);
        }
        this.addCopyIfNotExists(aRole);
        return copy;
    }

    public SecurityRole addCopyIfNotExists(SecurityRole aRole) {
        Application dd = this.getDeploymentDescriptor();
        SecurityRole copy = null;
        if (!dd.containsSecurityRole(aRole.getRoleName())) {
            copy = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)aRole);
            dd.getSecurityRoles().add((Object)copy);
        }
        return copy;
    }

    protected void checkDuplicate(String aUri) throws DuplicateObjectException {
        if (this.isDuplicate(aUri)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString("dup_resource_EXC_", new Object[]{aUri, this.getURI()}));
        }
    }

    protected Module createModuleForCopying(ModuleFile aModuleFile) {
        WebModule aModule = null;
        if (aModuleFile.isWARFile()) {
            aModule = this.getApplicationFactory().createWebModule();
        } else if (aModuleFile.isEJBJarFile()) {
            aModule = this.getApplicationFactory().createEjbModule();
        } else if (aModuleFile.isApplicationClientFile()) {
            aModule = this.getApplicationFactory().createJavaClientModule();
        } else if (aModuleFile.isRARFile()) {
            aModule = this.getApplicationFactory().createConnectorModule();
        }
        aModule.setUri(aModuleFile.getURI());
        return aModule;
    }

    public EObject getAltDeploymentDescriptor(Module aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        XMLResource ddRes;
        String altDD = aModule.getAltDD();
        if (ArchiveUtil.isNullOrEmpty(altDD)) {
            return null;
        }
        if (!this.isMofResourceLoaded(altDD.trim())) {
            this.registerResourceFactory(aModule, altDD);
        }
        if (!(ddRes = (XMLResource)this.getMofResource(altDD.trim())).isAlt()) {
            ddRes.setIsAlt(true);
            ddRes.setApplication(this.getDeploymentDescriptor());
        }
        return ArchiveUtil.getRoot((Resource)ddRes);
    }

    public List getApplicationClientFiles() {
        ArrayList<File> clientFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isApplicationClientFile()) {
                clientFiles.add(aFile);
            }
            ++i;
        }
        return clientFiles;
    }

    protected ApplicationFactory getApplicationFactory() {
        return ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory();
    }

    protected AssemblyDescriptor getAssemblyDescriptorAddIfNecessary(EJBJar ejbJar) {
        AssemblyDescriptor ad = ejbJar.getAssemblyDescriptor();
        if (ad == null) {
            ad = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(ad);
        }
        return ad;
    }

    public Application getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        Application dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        return this.getDeploymentDescriptorGen();
    }

    public Connector getDeploymentDescriptor(ConnectorModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (Connector)this.getDeploymentDescriptor((Module)aModule);
    }

    public EJBJar getDeploymentDescriptor(EjbModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (EJBJar)this.getDeploymentDescriptor((Module)aModule);
    }

    public ApplicationClient getDeploymentDescriptor(JavaClientModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (ApplicationClient)this.getDeploymentDescriptor((Module)aModule);
    }

    public EObject getDeploymentDescriptor(Module aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        EObject dd = this.getAltDeploymentDescriptor(aModule);
        if (dd == null) {
            dd = this.getModuleFile(aModule).getStandardDeploymentDescriptor();
        }
        return dd;
    }

    public WebApp getDeploymentDescriptor(WebModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (WebApp)this.getDeploymentDescriptor((Module)aModule);
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/application.xml";
    }

    public List getEJBJarFiles() {
        ArrayList<File> ejbJarFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isEJBJarFile()) {
                ejbJarFiles.add(aFile);
            }
            ++i;
        }
        return ejbJarFiles;
    }

    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref) {
        String link = ref.getLink();
        if (link == null) {
            return null;
        }
        List jarFiles = this.getEJBJarFiles();
        int i = 0;
        while (i < jarFiles.size()) {
            EnterpriseBean bean = ((EJBJarFile)jarFiles.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(link);
            if (bean != null) {
                return bean;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref, String moduleUri) {
        String link = ref.getLink();
        if (link == null) {
            return null;
        }
        if (link.indexOf(35) == -1) {
            EJBJar jar;
            EnterpriseBean linkedEJB = null;
            XMLResource res = (XMLResource)ref.eResource();
            if (res instanceof EJBResource && (jar = ((EJBResource)res).getEJBJar()) != null) {
                linkedEJB = jar.getEnterpiseBeanFromRef(ref);
            }
            if (linkedEJB != null) return linkedEJB;
            List jarFiles = this.getEJBJarFiles();
            int i = 0;
            while (i < jarFiles.size()) {
                linkedEJB = ((EJBJarFile)jarFiles.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(link);
                if (linkedEJB != null) {
                    return linkedEJB;
                }
                ++i;
            }
            return null;
        } else {
            String ejbJarUri;
            String ejbBeanName = link.substring(link.indexOf("#") + 1, link.length());
            String ejbJarName = link.substring(0, link.indexOf("#"));
            if (ejbBeanName == null || ejbJarName == null || (ejbJarUri = ArchiveUtil.deriveEARRelativeURI(ejbJarName, moduleUri)) == null) return null;
            try {
                File aFile = this.getFile(ejbJarUri);
                if (aFile == null || !aFile.isEJBJarFile()) {
                    return null;
                }
                EJBJarFile jarFile = (EJBJarFile)this.getFile(ejbJarUri);
                EList ejbs = jarFile.getDeploymentDescriptor().getEnterpriseBeans();
                if (ejbs == null || ejbs.isEmpty()) return null;
                Iterator it = ejbs.iterator();
                while (it.hasNext()) {
                    EnterpriseBean ejbBean = (EnterpriseBean)it.next();
                    if (ejbBean == null || !ejbBean.getName().equals(ejbBeanName)) continue;
                    return ejbBean;
                }
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }

    public Module getModule(String aUri, String altDD) {
        return this.getDeploymentDescriptor().getModule(aUri, altDD);
    }

    public ModuleRef getModuleRef(Module moduleDescriptor) {
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.getModule() == moduleDescriptor) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    public List getModuleFiles() {
        ArrayList<File> moduleFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isModuleFile()) {
                moduleFiles.add(aFile);
            }
            ++i;
        }
        return moduleFiles;
    }

    protected ArchiveOptions getOptionsForOpening(String aUri) throws IOException {
        LoadStrategy strategy = this.getCommonArchiveFactory().createChildLoadStrategy(aUri, this.getLoadStrategy());
        return this.getOptions().cloneWith(strategy, aUri);
    }

    protected ArchiveOptions getOptionsForOpening(LooseArchive loose) throws IOException {
        LoadStrategy strategy = this.getCommonArchiveFactory().createLoadStrategy(loose.getBinariesPath());
        strategy.setLooseArchive(loose);
        return this.getOptions().cloneWith(strategy, loose.getUri());
    }

    public List getRARFiles() {
        ArrayList<File> rarFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isRARFile()) {
                rarFiles.add(aFile);
            }
            ++i;
        }
        return rarFiles;
    }

    public EList getRolesFromAllModules() {
        BasicEList roleList = new BasicEList();
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        int n = modules.size();
        while (i < n) {
            Module aModule = (Module)modules.get(i);
            EList roles = this.getRolesFromModule(aModule);
            int j = 0;
            int m = roles.size();
            while (j < m) {
                roleList.add(roles.get(j));
                ++j;
            }
            ++i;
        }
        return roleList;
    }

    public EList getRolesFromModule(Module aModule) {
        BasicEList roleList = new BasicEList();
        try {
            if (aModule.isWebModule()) {
                roleList = this.getDeploymentDescriptor((WebModule)aModule).getSecurityRoles();
            } else if (aModule.isEjbModule()) {
                roleList = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)aModule)).getSecurityRoles();
            }
        }
        catch (Exception e) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{aModule.getUri(), this.getURI()}), e);
        }
        return roleList;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public List getWARFiles() {
        ArrayList<File> warFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isWARFile()) {
                warFiles.add(aFile);
            }
            ++i;
        }
        return warFiles;
    }

    public void initializeAfterOpen() {
        super.initializeAfterOpen();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isEARFile() {
        return true;
    }

    public boolean isNestedArchive(String aUri) {
        if (super.isNestedArchive(aUri)) {
            return true;
        }
        return this.getDeploymentDescriptor().getFirstModule(aUri) != null;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        Application appl = ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory().createApplication();
        resource.setID((EObject)appl, "Application_ID");
        this.setDeploymentDescriptorGen(appl);
        resource.getContents().add((Object)appl);
        return appl;
    }

    public Archive openNestedArchive(LooseArchive loose) throws OpenFailureException {
        Module m = this.getDeploymentDescriptor().getFirstModule(loose.getUri());
        if (m == null) {
            return super.openNestedArchive(loose);
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(loose);
            return this.openNestedArchive(m, archiveOptions);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Archive openNestedArchive(String aUri) throws OpenFailureException {
        Module m = this.getDeploymentDescriptor().getFirstModule(aUri);
        if (m == null) {
            return super.openNestedArchive(aUri);
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(aUri);
            return this.openNestedArchive(m, archiveOptions);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Archive openNestedArchive(Module m, ArchiveOptions archiveOptions) throws OpenFailureException {
        String aUri = m.getUri();
        try {
            if (m.isWebModule()) {
                return this.getCommonArchiveFactory().openWARFile(archiveOptions, aUri);
            }
            if (m.isEjbModule()) {
                return this.getCommonArchiveFactory().openEJBJarFile(archiveOptions, aUri);
            }
            if (m.isJavaModule()) {
                return this.getCommonArchiveFactory().openApplicationClientFile(archiveOptions, aUri);
            }
            if (m.isConnectorModule()) {
                return this.getCommonArchiveFactory().openRARFile(archiveOptions, aUri);
            }
        }
        catch (OpenFailureException ex) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString("nested_open_fail_EXC_", new Object[]{aUri, this.getURI()}), (Exception)((Object)ex));
        }
        return null;
    }

    public void pushDownRole(SecurityRole role) {
        if (role == null) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString("Parameter_should_not_be_nu_EXC_"));
        }
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module m = (Module)modules.get(i);
            this.pushDownRole(role, m);
            ++i;
        }
    }

    public void pushDownRole(SecurityRole role, Module aModule) {
        try {
            AssemblyDescriptor assembly;
            if (aModule.isWebModule()) {
                WebApp dd = this.getDeploymentDescriptor((WebModule)aModule);
                if (dd.getSecurityRoleNamed(role.getRoleName()) == null) {
                    dd.getSecurityRoles().add((Object)EtoolsCopyUtility.createCopy((EObject)role));
                }
            } else if (aModule.isEjbModule() && (assembly = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)aModule))).getSecurityRoleNamed(role.getRoleName()) == null) {
                assembly.getSecurityRoles().add((Object)EtoolsCopyUtility.createCopy((EObject)role));
            }
        }
        catch (Exception e) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{aModule.getUri(), this.getURI()}), e);
        }
    }

    protected void registerResourceFactory(Module aModule, String aUri) {
        Resource.Factory factory = null;
        if (aModule.isEjbModule()) {
            factory = EJBJarResourceFactory.getRegisteredFactory();
        } else if (aModule.isWebModule()) {
            factory = WebAppResourceFactory.getRegisteredFactory();
        } else if (aModule.isJavaModule()) {
            factory = ApplicationClientResourceFactory.getRegisteredFactory();
        } else if (aModule.isConnectorModule()) {
            factory = ConnectorResourceFactory.getRegisteredFactory();
        }
        if (factory != null) {
            ResourceSet set = this.getResourceSet();
            ((J2EEResourceFactoryRegistry)set.getResourceFactoryRegistry()).registerLastFileSegment(aUri, factory);
        }
    }

    public void remove(ModuleRef aModuleRef) {
        if (aModuleRef == null) {
            return;
        }
        Module aModule = aModuleRef.getModule();
        if (aModule != null) {
            this.getDeploymentDescriptor().getModules().remove((Object)aModule);
        }
        this.getModuleRefs().remove((Object)aModuleRef);
        if (this.getModuleRefs(aModuleRef.getModuleFile()).isEmpty()) {
            this.getFiles().remove((Object)aModuleRef.getModuleFile());
        }
    }

    public List getModuleRefs(ModuleFile aModuleFile) {
        EList refs = this.getModuleRefs();
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>(1);
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.getModuleFile() == aModuleFile) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    protected void renameRolesInModuleDDs(String existingRoleName, String newRoleName) {
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module m = (Module)modules.get(i);
            try {
                if (m.isEjbModule()) {
                    this.getDeploymentDescriptor((EjbModule)m).renameSecurityRole(existingRoleName, newRoleName);
                } else if (m.isWebModule()) {
                    this.getDeploymentDescriptor((WebModule)m).renameSecurityRole(existingRoleName, newRoleName);
                }
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{m.getUri(), this.getURI()}), e);
            }
            ++i;
        }
    }

    public void renameSecurityRole(String existingRoleName, String newRoleName) throws ObjectNotFoundException, DuplicateObjectException {
        Application app = this.getDeploymentDescriptor();
        SecurityRole aRole = app.getSecurityRoleNamed(existingRoleName);
        if (aRole == null) {
            throw new ObjectNotFoundException(CommonArchiveResourceHandler.getString("no_sec_role_EXC_", new Object[]{this.getURI(), existingRoleName}));
        }
        if (app.getSecurityRoleNamed(newRoleName) != null) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString("dup_sec_role_EXC_", new Object[]{this.getURI(), newRoleName}), app.getSecurityRoleNamed(newRoleName));
        }
        aRole.setRoleName(newRoleName);
        this.renameRolesInModuleDDs(existingRoleName, newRoleName);
    }

    public void rollUpRoles() {
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module aModule = (Module)modules.get(i);
            this.rollUpRoles(aModule);
            ++i;
        }
    }

    public void rollUpRoles(Module aModule) {
        EList securityRoles = null;
        try {
            if (aModule.isWebModule()) {
                securityRoles = this.getDeploymentDescriptor((WebModule)aModule).getSecurityRoles();
            } else if (aModule.isEjbModule()) {
                securityRoles = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)aModule)).getSecurityRoles();
            }
        }
        catch (Exception e) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{aModule.getUri(), this.getURI()}), e);
        }
        if (securityRoles == null) {
            return;
        }
        int i = 0;
        while (i < securityRoles.size()) {
            this.addCopyIfNotExists((SecurityRole)securityRoles.get(i));
            ++i;
        }
    }

    public void setDeploymentDescriptor(Application l) {
        this.setDeploymentDescriptorGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)l);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
            case 9: {
                return this.moduleRefs != null && !this.moduleRefs.isEmpty();
            }
            case 10: {
                return this.deploymentDescriptor != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI((String)newValue);
                return;
            }
            case 1: {
                this.setLastModified((Long)newValue);
                return;
            }
            case 2: {
                this.setSize((Long)newValue);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)newValue);
                return;
            }
            case 4: {
                this.setOriginalURI((String)newValue);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)newValue);
                return;
            }
            case 6: {
                this.setContainer((Container)newValue);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getModuleRefs().clear();
                this.getModuleRefs().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setDeploymentDescriptor((Application)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
            case 8: {
                this.getTypes().clear();
                return;
            }
            case 9: {
                this.getModuleRefs().clear();
                return;
            }
            case 10: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public Application getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            Application oldDeploymentDescriptor = this.deploymentDescriptor;
            this.deploymentDescriptor = (Application)EcoreUtil.resolve((EObject)this.deploymentDescriptor, (EObject)this);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public Application basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(Application newDeploymentDescriptor) {
        Application oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public EList getModuleRefsGen() {
        if (this.moduleRefs == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.moduleRefs = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 9, 1);
        }
        return this.moduleRefs;
    }

    public EList getModuleRefs() {
        EList refs = this.getModuleRefsGen();
        if (refs.isEmpty()) {
            this.initRefs(refs);
        }
        return refs;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)otherEnd, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getModuleRefs()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getModuleRefs()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 6: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.Container");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (resolve) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
            case 8: {
                return this.getTypes();
            }
            case 9: {
                return this.getModuleRefs();
            }
            case 10: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void initRefs(EList refs) {
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module module = (Module)modules.get(i);
            refs.add((Object)this.createModuleRef(module, null));
            ++i;
        }
    }

    protected ModuleRef createModuleRef(Module aModule, ModuleFile aFile) {
        ModuleRef newRef = null;
        if (aModule.isEjbModule()) {
            newRef = this.getCommonArchiveFactory().createEJBModuleRef();
        } else if (aModule.isWebModule()) {
            newRef = this.getCommonArchiveFactory().createWebModuleRef();
        } else if (aModule.isConnectorModule()) {
            newRef = this.getCommonArchiveFactory().createConnectorModuleRef();
        } else if (aModule.isJavaModule()) {
            newRef = this.getCommonArchiveFactory().createClientModuleRef();
        }
        newRef.setModule(aModule);
        newRef.setModuleFile(aFile);
        return newRef;
    }

    public List getClientModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isClient()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getConnectorModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isConnector()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getEJBModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isEJB()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getWebModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isWeb()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getFARFiles() {
        ArrayList<File> farFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isFARFile()) {
                farFiles.add(aFile);
            }
            ++i;
        }
        return farFiles;
    }

    public List getArchivesOfType(String type) {
        return Collections.EMPTY_LIST;
    }

    public Map getEJBReferences(boolean filterLinkedReferences, boolean filterNonLinkedReferences) throws ArchiveWrappedException {
        Application app;
        if (!(filterLinkedReferences && filterNonLinkedReferences || (app = this.getDeploymentDescriptor()) == null)) {
            EList modules = app.getModules();
            Map references = null;
            int i = 0;
            while (i < modules.size()) {
                Module module = (Module)modules.get(i);
                try {
                    references = this.collectEJBReferences(module, filterLinkedReferences, filterNonLinkedReferences, references);
                }
                catch (ResourceLoadException e) {
                    throw new ArchiveWrappedException((Exception)((Object)e));
                }
                catch (FileNotFoundException e) {
                    throw new ArchiveWrappedException(e);
                }
                catch (EmptyResourceException e) {
                    throw new ArchiveWrappedException(e);
                }
                ++i;
            }
            return references;
        }
        return Collections.EMPTY_MAP;
    }

    private Map collectEJBReferences(Module module, boolean filterLinkedReferences, boolean filterNonLinkedReferences, Map references) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        HashMap myReferences = references;
        List moduleReferences = this.getEJBReferneces(module);
        if (moduleReferences != null && !moduleReferences.isEmpty()) {
            EjbRef ref = null;
            ArrayList<EjbRef> filteredRefs = null;
            String link = null;
            int i = 0;
            while (i < moduleReferences.size()) {
                ref = (EjbRef)moduleReferences.get(i);
                link = ref.getLink();
                if (link != null && link.length() > 0 && !filterLinkedReferences || link == null || link.length() == 0 && !filterNonLinkedReferences) {
                    if (filteredRefs == null) {
                        filteredRefs = new ArrayList<EjbRef>(moduleReferences.size());
                    }
                    filteredRefs.add(ref);
                }
                ++i;
            }
            if (filteredRefs != null) {
                if (myReferences == null) {
                    myReferences = new HashMap();
                }
                myReferences.put(module, filteredRefs);
            }
        }
        return myReferences;
    }

    private List getEJBReferneces(Module module) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        if (module != null) {
            ApplicationClient appClient;
            if (module.isEjbModule()) {
                EJBJar ejbJar = this.getDeploymentDescriptor((EjbModule)module);
                return this.getEJBReferences(ejbJar);
            }
            if (module.isWebModule()) {
                WebApp webApp = this.getDeploymentDescriptor((WebModule)module);
                if (webApp != null) {
                    return webApp.getEjbRefs();
                }
            } else if (module.isJavaModule() && (appClient = this.getDeploymentDescriptor((JavaClientModule)module)) != null) {
                return appClient.getEjbReferences();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List getEJBReferences(EJBJar ejbJar) {
        if (ejbJar != null) {
            EList ejbs = ejbJar.getEnterpriseBeans();
            ArrayList refs = null;
            EnterpriseBean ejb = null;
            int i = 0;
            while (i < ejbs.size()) {
                ejb = (EnterpriseBean)ejbs.get(i);
                if (refs == null) {
                    refs = new ArrayList();
                }
                refs.addAll(ejb.getEjbRefs());
                ++i;
            }
            if (refs != null) {
                return refs;
            }
        }
        return Collections.EMPTY_LIST;
    }
}

