/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ArchiveFileDynamicClassLoader
extends ClassLoader {
    protected Archive archive = null;
    protected ClassLoader extraClassLoader;
    protected boolean inEARFile;

    public ArchiveFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl) {
        super(parentCl);
        this.setArchive(anArchive);
        this.setExtraClassLoader(extraCl);
        this.inEARFile = anArchive.getContainer() != null && anArchive.getContainer().isEARFile();
    }

    /*
     * WARNING - void declaration
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        void var2_3;
        byte[] bytes = this.getClassBytesFor(name);
        if (bytes != null) {
            Class<?> result = this.defineClass(name, bytes, 0, bytes.length);
            if (result == null) {
                throw new ClassNotFoundException(name);
            }
        } else {
            throw new ClassNotFoundException(name);
        }
        return var2_3;
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected byte[] getClassBytesFor(String className) {
        if (className == null) {
            return null;
        }
        String jarEntryName = ArchiveUtil.classNameToUri(className);
        try {
            InputStream in = this.getArchive().getInputStream(jarEntryName);
            return ArchiveUtil.inputStreamToBytes(in);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException ex) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString("io_ex_loading_EXC_", new Object[]{className}), ex);
        }
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive().getContainer();
    }

    public ClassLoader getExtraClassLoader() {
        return this.extraClassLoader;
    }

    protected synchronized Class loadClass(String name, Set visitedArchives) throws ClassNotFoundException {
        if (visitedArchives.contains(this.getArchive())) {
            throw new ClassNotFoundException(name);
        }
        visitedArchives.add(this.getArchive());
        try {
            return super.loadClass(name, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadClassInDependentJarInEAR(name, visitedArchives);
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class c = this.loadClassInDependentJar(name);
            if (c != null && resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    protected Class loadClassInDependentJar(String name) throws ClassNotFoundException {
        if (this.inEARFile) {
            return this.loadClassInDependentJarInEAR(name);
        }
        if (this.getExtraClassLoader() != null) {
            return this.getExtraClassLoader().loadClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    protected Class loadClassInDependentJarInEAR(String name) throws ClassNotFoundException {
        HashSet<Archive> visitedArchives = new HashSet<Archive>(5);
        visitedArchives.add(this.getArchive());
        return this.loadClassInDependentJarInEAR(name, visitedArchives);
    }

    protected Class loadClassInDependentJarInEAR(String name, Set visitedArchives) throws ClassNotFoundException {
        String[] classpath = this.archive.getManifest().getClassPathTokenized();
        int i = 0;
        while (i < classpath.length) {
            try {
                File file;
                String uri = ArchiveUtil.deriveEARRelativeURI(classpath[i], this.archive);
                if (uri != null && (file = this.getEARFile().getFile(uri)).isArchive()) {
                    Archive dep = (Archive)file;
                    try {
                        return ((ArchiveFileDynamicClassLoader)dep.getArchiveClassLoader()).loadClass(name, visitedArchives);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
            ++i;
        }
        throw new ClassNotFoundException(name);
    }

    public void setArchive(Archive newArchive) {
        this.archive = newArchive;
    }

    public void setExtraClassLoader(ClassLoader newExtraClassLoader) {
        this.extraClassLoader = newExtraClassLoader;
    }
}

