/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.internal.ClasspathTableManager;
import org.eclipse.jst.j2ee.internal.IClasspathTableOwner;
import org.eclipse.jst.j2ee.internal.ICommonManifestUIConstants;
import org.eclipse.jst.j2ee.internal.ManifestErrorPrompter;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.common.operations.UpdateJavaBuildPathOperation;
import org.eclipse.jst.j2ee.internal.listeners.IValidateEditListener;
import org.eclipse.jst.j2ee.internal.listeners.ValidateEditListener;
import org.eclipse.jst.j2ee.internal.project.J2EEComponentUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;

public class JARDependencyPropertiesPage
extends PropertyPage
implements IClasspathTableOwner,
Listener,
ClasspathModelListener,
ICommonManifestUIConstants {
    protected IProject project;
    protected IOException caughtManifestException;
    protected boolean isDirty;
    protected Text classPathText;
    protected Text componentNameText;
    protected ClasspathModel model;
    protected CCombo availableAppsCombo;
    protected ClasspathTableManager tableManager;
    protected IValidateEditListener validateEditListener;
    protected Button enableWLPCheckBox;
    protected Label manifestLabel;
    protected Label enterpriseApplicationLabel;
    protected Label availableDependentJars;
    static /* synthetic */ Class class$0;

    protected void initialize() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.project = (IProject)iAdaptable.getAdapter((Class)clazz);
        this.model = new ClasspathModel(null);
        this.model.setProject(this.project);
        this.model.addListener((ClasspathModelListener)this);
        this.updateModelManifest();
        this.initializeValidateEditListener();
    }

    public void dispose() {
        super.dispose();
        if (this.model.earArtifactEdit != null) {
            this.model.earArtifactEdit.dispose();
            this.model.earArtifactEdit = null;
        }
    }

    /*
     * Exception decompiling
     */
    private void updateModelManifest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 208->212)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initializeValidateEditListener() {
        this.validateEditListener = new ValidateEditListener(null, (ResourceStateValidator)this.model);
        this.validateEditListener.setShell(this.getShell());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.caughtManifestException != null && !this.model.isDirty()) {
            ManifestErrorPrompter.showManifestException(this.getShell(), ERROR_READING_MANIFEST_DIALOG_MESSAGE_PROP_PAGE, false, this.caughtManifestException);
        }
    }

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (!this.isValidComponent()) {
            return composite;
        }
        this.createProjectLabelsGroup(composite);
        this.createListGroup(composite);
        this.createTextGroup(composite);
        this.refresh();
        this.handleStandaloneWebModule();
        return composite;
    }

    private void handleStandaloneWebModule() {
        if (this.enableWLPCheckBox != null && this.enableWLPCheckBox.getSelection()) {
            this.model.setWLPModel(true);
            this.handleWLPSupport((Widget)this.enableWLPCheckBox);
            this.enableWLPCheckBox.setEnabled(false);
        }
    }

    private boolean isValidComponent() {
        if (this.model.getComponent().getComponentTypeId().equals("jst.ear")) {
            this.setErrorMessage("Java Jar Dependencies is not valid for EAR modules");
            return false;
        }
        if (ComponentUtilities.getComponentsForProject((IProject)this.model.getProject()).length > 1) {
            this.setErrorMessage("Java Jar Dependencies is valid only for one module per flexible project");
            return false;
        }
        if (J2EEComponentUtilities.isStandaloneComponent((IVirtualComponent)this.model.getComponent()) && !this.model.getComponent().getComponentTypeId().equals("jst.web")) {
            this.setErrorMessage(ClasspathModel.NO_EAR_MESSAGE);
            return false;
        }
        return true;
    }

    protected void createProjectLabelsGroup(Composite parent) {
        Composite labelsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        labelsGroup.setLayout((Layout)layout);
        labelsGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(labelsGroup, 0);
        label.setText(ManifestUIResourceHandler.getString("Project_name__UI_"));
        this.componentNameText = new Text(labelsGroup, 2048);
        GridData data = new GridData(768);
        this.componentNameText.setEditable(false);
        this.componentNameText.setLayoutData((Object)data);
        this.componentNameText.setText(this.project.getName());
        if (J2EEComponentUtilities.isWebComponent((IVirtualComponent)this.model.getComponent())) {
            this.createEnableWLPProjectCheckbox(labelsGroup);
        }
        this.createEnterpriseAppsControls(labelsGroup);
    }

    private void createEnterpriseAppsControls(Composite labelsGroup) {
        this.enterpriseApplicationLabel = new Label(labelsGroup, 0);
        this.enterpriseApplicationLabel.setText(ManifestUIResourceHandler.getString("EAR_Project_Name__UI__UI_"));
        this.availableAppsCombo = new CCombo(labelsGroup, 2056);
        GridData gd = new GridData(768);
        this.availableAppsCombo.setLayoutData((Object)gd);
        this.availableAppsCombo.addListener(13, (Listener)this);
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableDependentJars = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableDependentJars.setText(ManifestUIResourceHandler.getString("Available_dependent_JARs__UI_"));
        this.availableDependentJars.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTextGroup(Composite parent) {
        Composite textGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        textGroup.setLayout((Layout)layout);
        textGroup.setLayoutData((Object)new GridData(1808));
        this.createClassPathText(textGroup);
    }

    protected void createClassPathText(Composite textGroup) {
        this.manifestLabel = new Label(textGroup, 0);
        this.manifestLabel.setText(ManifestUIResourceHandler.getString("Manifest_Class-Path__UI_"));
        this.classPathText = new Text(textGroup, 2626);
        GridData gData = new GridData(1808);
        gData.widthHint = 400;
        gData.heightHint = 100;
        this.classPathText.setLayoutData((Object)gData);
        this.classPathText.setEditable(false);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.tableManager = new ClasspathTableManager(this, this.model, this.validateEditListener);
        this.tableManager.setReadOnly(this.isReadOnly());
        this.tableManager.fillComposite(composite);
    }

    public CheckboxTableViewer createAvailableJARsViewer(Composite parent) {
        int flags = 67618;
        Table table = new Table(parent, flags);
        CheckboxTableViewer availableJARsViewer = new CheckboxTableViewer(table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        availableJARsViewer.setSorter(null);
        TableColumn fileNameColumn = new TableColumn(table, 0, 0);
        fileNameColumn.setText(ManifestUIResourceHandler.getString("JAR/Module_UI_"));
        fileNameColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(ManifestUIResourceHandler.getString("Project_UI_"));
        projectColumn.setResizable(true);
        tableLayout.layout((Composite)table, true);
        return availableJARsViewer;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite buttonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        buttonColumn.setLayoutData((Object)data);
        return buttonColumn;
    }

    public Button primCreatePushButton(String label, Composite buttonColumn) {
        Button aButton = new Button(buttonColumn, 8);
        aButton.setText(label);
        return aButton;
    }

    public Button primCreateRadioButton(String label, Composite parent) {
        Button aButton = new Button(parent, 16);
        aButton.setText(label);
        return aButton;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.availableAppsCombo) {
            this.availableAppsSelected(event);
        }
        if (event.widget == this.enableWLPCheckBox) {
            this.handleWLPSupport(event.widget);
            this.tableManager.refresh();
        }
    }

    private void handleWLPSupport(Widget widget) {
        if (((Button)widget).getSelection()) {
            this.tableManager.setWLPEntry(true);
            this.makeJarDependencyControlsInvisible();
            this.availableDependentJars.setText("Select utility projects to add as Web Library projects to the web module");
        } else {
            this.tableManager.setWLPEntry(false);
            this.makeJarDependencyControlsVisible();
            this.availableDependentJars.setText(ManifestUIResourceHandler.getString("Available_dependent_JARs__UI_"));
        }
    }

    private void makeJarDependencyControlsVisible() {
        this.availableAppsCombo.setVisible(true);
        this.tableManager.upButton.setVisible(true);
        this.tableManager.downButton.setVisible(true);
        this.tableManager.radioGroup.setVisible(true);
        this.manifestLabel.setVisible(true);
        this.classPathText.setVisible(true);
        this.enterpriseApplicationLabel.setVisible(true);
    }

    private void makeJarDependencyControlsInvisible() {
        this.availableAppsCombo.setVisible(false);
        this.tableManager.upButton.setVisible(false);
        this.tableManager.downButton.setVisible(false);
        this.tableManager.radioGroup.setVisible(false);
        this.manifestLabel.setVisible(false);
        this.classPathText.setVisible(false);
        this.enterpriseApplicationLabel.setVisible(false);
    }

    protected void availableAppsSelected(Event event) {
        int index = this.availableAppsCombo.getSelectionIndex();
        this.model.selectEAR(index);
    }

    protected void populateApps() {
        IVirtualComponent[] components = this.model.getAvailableEARComponents();
        String[] values = new String[components.length];
        int i = 0;
        while (i < components.length) {
            values[i] = components[i].getProject().getName();
            ++i;
        }
        if (this.availableAppsCombo != null) {
            this.availableAppsCombo.setItems(values);
            IVirtualComponent selected = this.model.getSelectedEARComponent();
            if (selected != null) {
                int index = Arrays.asList(components).indexOf(selected);
                this.availableAppsCombo.select(index);
            } else {
                this.availableAppsCombo.clearSelection();
            }
        }
    }

    protected void refresh() {
        this.populateApps();
        this.tableManager.refresh();
        this.refreshText();
    }

    protected void createEnableWLPProjectCheckbox(Composite parent) {
        this.enableWLPCheckBox = new Button(parent, 32);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 20;
        this.enableWLPCheckBox.setLayoutData((Object)data);
        this.enableWLPCheckBox.setText("Set Web Library Project dependency");
        this.enableWLPCheckBox.addListener(13, (Listener)this);
        if (J2EEComponentUtilities.isStandaloneWebComponent((IVirtualComponent)this.model.getComponent())) {
            this.enableWLPCheckBox.setSelection(true);
        } else {
            this.enableWLPCheckBox.setSelection(false);
        }
    }

    public void refreshText() {
        ClassPathSelection sel = this.model.getClassPathSelection();
        this.classPathText.setText(sel == null ? "" : sel.toString());
    }

    public void modelChanged(ClasspathModelEvent evt) {
        if (evt.getEventType() == 1) {
            this.isDirty = true;
            this.refreshText();
        } else if (evt.getEventType() == 2) {
            this.tableManager.refresh();
        }
    }

    protected void performDefaults() {
        this.model.resetClassPathSelection();
        this.refresh();
        this.isDirty = false;
        this.model.dispose();
    }

    public boolean performCancel() {
        this.model.dispose();
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.isWLPProjectSetting()) {
            return this.performWLPSettingOp();
        }
        return this.performJavaJarDependencyOp();
    }

    private boolean performWLPSettingOp() {
        boolean bl;
        try {
            boolean createdFlexProjects = this.runWLPOp(this.createFlexProjectOperations());
            boolean createdComponentDependency = false;
            if (createdFlexProjects) {
                createdComponentDependency = this.runWLPOp(this.createComponentDependencyOperations());
            }
            boolean createdBuildPathSettings = false;
            if (createdComponentDependency) {
                WorkspaceModifyComposedOperation composedOp = new WorkspaceModifyComposedOperation();
                composedOp.addRunnable(this.createWLPBuildPathOperation());
                createdBuildPathSettings = this.runWLPOp(composedOp);
            }
            bl = createdBuildPathSettings;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.model.dispose();
            throw throwable;
        }
        this.model.dispose();
        return bl;
    }

    private boolean runWLPOp(WorkspaceModifyComposedOperation composed) {
        try {
            if (composed != null) {
                new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)composed);
            }
        }
        catch (InvocationTargetException ex) {
            String title;
            String msg = title = ManifestUIResourceHandler.getString("An_internal_error_occurred_ERROR_");
            if (ex.getTargetException() != null && ex.getTargetException().getMessage() != null) {
                msg = ex.getTargetException().getMessage();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
            Logger.getLogger().logError((Throwable)ex);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performJavaJarDependencyOp() {
        if (!this.isDirty) {
            return true;
        }
        WorkspaceModifyComposedOperation composed = new WorkspaceModifyComposedOperation((IRunnableWithProgress)this.createManifestOperation());
        composed.addRunnable(this.createBuildPathOperation());
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)composed);
            }
            catch (InvocationTargetException ex) {
                String title;
                String msg = title = ManifestUIResourceHandler.getString("An_internal_error_occurred_ERROR_");
                if (ex.getTargetException() != null && ex.getTargetException().getMessage() != null) {
                    msg = ex.getTargetException().getMessage();
                }
                MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
                Logger.getLogger().logError((Throwable)ex);
                Object var5_5 = null;
                this.model.dispose();
                return false;
            }
            catch (InterruptedException interruptedException) {
                Object var5_6 = null;
                this.model.dispose();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.model.dispose();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.model.dispose();
        this.isDirty = false;
        return true;
    }

    private WorkspaceModifyComposedOperation createComponentDependencyOperations() {
        IVirtualComponent targetComp;
        IFlexibleProject flexProject;
        IProject elementProject;
        ClasspathElement element;
        WorkspaceModifyComposedOperation composedOp = null;
        List selected = this.getSelectedClassPathSelectionForWLPs().getClasspathElements();
        List unselected = this.getUnSelectedClassPathSelectionForWLPs().getClasspathElements();
        ArrayList<ComponentHandle> targetComponentsHandles = new ArrayList<ComponentHandle>();
        int i = 0;
        while (i < selected.size()) {
            element = (ClasspathElement)selected.get(i);
            elementProject = element.getProject();
            flexProject = ComponentCore.createFlexibleProject((IProject)elementProject);
            targetComp = flexProject.getComponents()[0];
            targetComponentsHandles.add(targetComp.getComponentHandle());
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            composedOp = new WorkspaceModifyComposedOperation();
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createWLPReferenceComponentOperation((ComponentHandle)this.model.getComponent().getComponentHandle(), targetComponentsHandles)));
        }
        targetComponentsHandles = new ArrayList();
        i = 0;
        while (i < unselected.size()) {
            element = (ClasspathElement)unselected.get(i);
            elementProject = element.getProject();
            flexProject = ComponentCore.createFlexibleProject((IProject)elementProject);
            if (flexProject.getComponents().length > 0) {
                targetComp = flexProject.getComponents()[0];
                targetComponentsHandles.add(targetComp.getComponentHandle());
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            if (composedOp == null) {
                composedOp = new WorkspaceModifyComposedOperation();
            }
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.removeReferenceComponentOperation((ComponentHandle)this.model.getComponent().getComponentHandle(), targetComponentsHandles)));
        }
        return composedOp;
    }

    private WorkspaceModifyComposedOperation createFlexProjectOperations() {
        WorkspaceModifyComposedOperation composedOp = null;
        try {
            Object[] elements = this.tableManager.availableJARsViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                ClasspathElement element = (ClasspathElement)elements[i];
                IProject elementProject = element.getProject();
                if (!elementProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                    if (composedOp == null) {
                        composedOp = new WorkspaceModifyComposedOperation();
                    }
                    composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createFlexJavaProjectForProjectOperation((IProject)elementProject)));
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return composedOp;
    }

    protected IRunnableWithProgress createBuildPathOperation() {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)this.project);
        return WTPUIPlugin.getRunnableWithProgress((IHeadlessRunnableWithProgress)new UpdateJavaBuildPathOperation(javaProject, this.getSelectedClassPathSelectionForWLPs()));
    }

    protected IRunnableWithProgress createWLPBuildPathOperation() {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)this.project);
        return WTPUIPlugin.getRunnableWithProgress((IHeadlessRunnableWithProgress)new UpdateJavaBuildPathOperation(javaProject, this.getSelectedClassPathSelectionForWLPs(), this.getUnSelectedClassPathSelectionForWLPs()));
    }

    private ClassPathSelection getUnSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        new ArrayList();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        List modelElements = this.model.getClassPathSelectionForWLPs().getClasspathElements();
        int i = 0;
        while (i < modelElements.size()) {
            List<Object> checkedElementsList = Arrays.asList(checkedElements);
            if (!checkedElementsList.contains((ClasspathElement)modelElements.get(i))) {
                selection.getClasspathElements().add((ClasspathElement)modelElements.get(i));
            }
            ++i;
        }
        return selection;
    }

    private ClassPathSelection getSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            selection.getClasspathElements().add((ClasspathElement)checkedElements[i]);
            ++i;
        }
        return selection;
    }

    protected boolean isWLPProjectSetting() {
        if (this.enableWLPCheckBox != null) {
            return this.enableWLPCheckBox.getSelection();
        }
        return false;
    }

    protected UpdateManifestOperation createManifestOperation() {
        return new UpdateManifestOperation(this.project.getName(), this.model.getClassPathSelection().toString(), true);
    }

    protected boolean isReadOnly() {
        return JemProjectUtilities.isBinaryProject((IProject)this.project);
    }
}

