/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class J2EEClipboard
extends ArrayList {
    private Map bindings;
    private Map extensions;

    public J2EEClipboard(Collection defaultClipboard) {
        super(defaultClipboard);
    }

    public boolean addAll(Collection c) {
        boolean result = super.addAll(c);
        if (result && c instanceof J2EEClipboard) {
            this.addAllExtra((J2EEClipboard)c);
        }
        return result;
    }

    protected void addAllExtra(J2EEClipboard c) {
        this.getBindings().putAll(c.getBindings());
        this.getExtensions().putAll(c.getExtensions());
    }

    protected void addBinding(EObject boundObject, EObject binding) {
        this.getBindings().put(boundObject, binding);
    }

    protected void addExtension(EObject extendedObject, EObject extension) {
        this.getExtensions().put(extendedObject, extension);
    }

    public EObject getBinding(EObject o) {
        return (EObject)this.getBindings().get(o);
    }

    protected Map getBindings() {
        if (this.bindings == null) {
            this.bindings = new HashMap(10);
        }
        return this.bindings;
    }

    public EObject getExtension(EObject o) {
        return (EObject)this.getExtensions().get(o);
    }

    protected Map getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashMap(10);
        }
        return this.extensions;
    }

    public boolean hasBindings() {
        return this.bindings != null && !this.bindings.isEmpty();
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }
}

