/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.earcreation.IDefaultJ2EEComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.AppClientComponentCreationWizard;
import org.eclipse.jst.j2ee.internal.wizard.J2EEComponentCreationWizard;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.ui.GenericWizardNode;

public class NewJ2EEComponentSelectionPage
extends DataModelWizardPage
implements IDefaultJ2EEComponentCreationDataModelProperties {
    private Button defaultModulesButton;
    private Composite defaultModulesComposite;
    private Composite newModulesComposite;
    private Button appClientRadioButton;
    private Button ejbRadioButton;
    private Button webRadioButton;
    private Button connectorRadioButton;
    private GenericWizardNode appClientNode;
    private GenericWizardNode ejbNode;
    private GenericWizardNode webNode;
    private GenericWizardNode connectorNode;
    private GenericWizardNode selectedNode;
    private StackLayout stackLayout;

    protected NewJ2EEComponentSelectionPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(J2EEUIMessages.getResourceString("DefaultJ2EEComponentCreationWizard.page.title"));
        this.setDescription(J2EEUIMessages.getResourceString("DefaultJ2EEComponentCreationWizard.page.desc"));
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT", "DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME", "DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR", "DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME", "DefaultJ2EEComponentCreationDataModel.CREATE_EJB", "DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME", "DefaultJ2EEComponentCreationDataModel.CREATE_WEB", "DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME", "DefaultJ2EEComponentCreationDataModel.MODULE_NAME_COLLISIONS_VALIDATION", "DefaultJ2EEComponentCreationDataModel.ENABLED"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.setInfopopID("org.eclipse.jst.j2ee.ui.EAR_NEW_MODULE_PROJECTS_PAGE");
        this.createDefaultCheckBox(composite);
        Composite forStackComposite = new Composite(composite, 0);
        layout = new GridLayout();
        forStackComposite.setLayout((Layout)layout);
        forStackComposite.setLayoutData((Object)new GridData(1808));
        Composite stackComposite = this.createStackLayoutComposite(forStackComposite);
        this.createDefaultModulesComposite(stackComposite);
        this.createModuleSelectionComposite(stackComposite);
        this.stackLayout.topControl = this.defaultModulesComposite;
        this.setButtonEnablement();
        return composite;
    }

    protected Composite createStackLayoutComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        composite.setLayout((Layout)this.stackLayout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    private void createDefaultModulesComposite(Composite parent) {
        this.defaultModulesComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        this.defaultModulesComposite.setLayout((Layout)layout);
        this.defaultModulesComposite.setLayoutData((Object)new GridData(768));
        this.createAppClientDefaultModuleControl();
        if (J2EEPlugin.isEJBSupportAvailable()) {
            this.createEJBDefaultModuleControl();
        }
        this.createWebDefaultModuleControl();
        if (J2EEPlugin.isEJBSupportAvailable()) {
            this.createConnectorDefaultModuleControl();
        }
    }

    private void createModuleSelectionComposite(Composite parent) {
        this.newModulesComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.newModulesComposite.setLayout((Layout)layout);
        this.newModulesComposite.setLayoutData((Object)new GridData(768));
        this.appClientRadioButton = new Button(this.newModulesComposite, 16);
        this.appClientRadioButton.setText(J2EEUIMessages.getResourceString("NewModuleSelectionPage.appClient"));
        this.appClientRadioButton.addListener(13, (Listener)this);
        if (EarModuleManager.getEJBModuleExtension() != null) {
            this.ejbRadioButton = new Button(this.newModulesComposite, 16);
            this.ejbRadioButton.setText(J2EEUIMessages.getResourceString("NewModuleSelectionPage.ejb"));
            this.ejbRadioButton.addListener(13, (Listener)this);
        }
        if (EarModuleManager.getWebModuleExtension() != null) {
            this.webRadioButton = new Button(this.newModulesComposite, 16);
            this.webRadioButton.setText(J2EEUIMessages.getResourceString("NewModuleSelectionPage.web"));
            this.webRadioButton.addListener(13, (Listener)this);
        }
        if (EarModuleManager.getJCAModuleExtension() != null) {
            this.connectorRadioButton = new Button(this.newModulesComposite, 16);
            this.connectorRadioButton.setText(J2EEUIMessages.getResourceString("NewModuleSelectionPage.jca"));
            this.connectorRadioButton.addListener(13, (Listener)this);
        }
    }

    private void createConnectorDefaultModuleControl() {
        if (EarModuleManager.getJCAModuleExtension() != null) {
            String label = J2EEUIMessages.getResourceString("DefaultJ2EEComponentCreationWizard.page.label.jca");
            this.createJ2EEComponentControl(label, "DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR", "DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME");
        }
    }

    private void createWebDefaultModuleControl() {
        if (EarModuleManager.getWebModuleExtension() != null) {
            String label = J2EEUIMessages.getResourceString("DefaultJ2EEComponentCreationWizard.page.label.web");
            this.createJ2EEComponentControl(label, "DefaultJ2EEComponentCreationDataModel.CREATE_WEB", "DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME");
        }
    }

    private void createEJBDefaultModuleControl() {
        if (EarModuleManager.getEJBModuleExtension() != null) {
            String label = J2EEUIMessages.getResourceString("DefaultJ2EEComponentCreationWizard.page.label.ejb");
            this.createJ2EEComponentControl(label, "DefaultJ2EEComponentCreationDataModel.CREATE_EJB", "DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME");
        }
    }

    private void createAppClientDefaultModuleControl() {
        String label = J2EEUIMessages.getResourceString("DefaultJ2EEComponentCreationWizard.page.label.appclient");
        this.createJ2EEComponentControl(label, "DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT", "DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME");
    }

    private void createJ2EEComponentControl(String label, String createProperty, String projectProperty) {
        Button checkBox = new Button(this.defaultModulesComposite, 32);
        checkBox.setSelection(true);
        checkBox.setText(label);
        Text textField = new Text(this.defaultModulesComposite, 2048);
        GridData data = new GridData(768);
        textField.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(checkBox, createProperty, null);
        this.synchHelper.synchText(textField, projectProperty, null);
    }

    private void createDefaultCheckBox(Composite composite) {
        Composite checkBoxComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        checkBoxComposite.setLayout((Layout)layout);
        checkBoxComposite.setLayoutData((Object)new GridData(1808));
        this.defaultModulesButton = new Button(checkBoxComposite, 32);
        GridData data = new GridData(32);
        data.horizontalIndent = 0;
        this.defaultModulesButton.setLayoutData((Object)data);
        this.defaultModulesButton.setText(J2EEUIMessages.getResourceString("DefaultJ2EEComponentCreationWizard.page.button.select"));
        this.defaultModulesButton.setSelection(true);
        this.defaultModulesButton.addListener(13, (Listener)this);
        this.synchHelper.synchCheckbox(this.defaultModulesButton, "DefaultJ2EEComponentCreationDataModel.ENABLED", null);
        this.createControlsSeparatorLine(checkBoxComposite);
    }

    protected void createControlsSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData(770);
        separator.setLayoutData((Object)data);
    }

    public void handleEvent(Event evt) {
        if (evt.widget == this.defaultModulesButton) {
            this.handleDefaultModulesButtonPressed();
        } else if (!this.defaultModulesButton.getSelection()) {
            if (evt.widget == this.appClientRadioButton && this.appClientRadioButton.getSelection()) {
                this.setSelectedNode(this.getAppClientNode());
            } else if (evt.widget == this.ejbRadioButton && this.ejbRadioButton.getSelection()) {
                this.setSelectedNode(this.getEjbNode());
            } else if (evt.widget == this.webRadioButton && this.webRadioButton.getSelection()) {
                this.setSelectedNode(this.getWebNode());
            } else if (evt.widget == this.connectorRadioButton && this.connectorRadioButton.getSelection()) {
                this.setSelectedNode(this.getConnectorNode());
            }
            this.validatePage();
        }
        super.handleEvent(evt);
    }

    private void handleDefaultModulesButtonPressed() {
        if (this.defaultModulesButton.getSelection()) {
            this.setSelectedNode(null);
            this.showDefaultModulesComposite();
            this.setDefaultModulesSelection(true);
        } else {
            this.setDefaultModulesSelection(false);
            this.showNewModulesCompsite();
        }
        this.setButtonEnablement();
        this.validatePage();
    }

    private void setDefaultModulesSelection(boolean selection) {
        this.getDataModel().setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT", selection);
        this.getDataModel().setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR", selection);
        this.getDataModel().setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB", selection);
        this.getDataModel().setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB", selection);
    }

    private void showDefaultModulesComposite() {
        this.defaultModulesComposite.setVisible(true);
        this.newModulesComposite.setVisible(false);
        this.stackLayout.topControl = this.defaultModulesComposite;
    }

    private void setButtonEnablement() {
        if (!this.defaultModulesButton.getSelection() && this.connectorRadioButton != null) {
            int version = this.getDataModel().getIntProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION");
            this.connectorRadioButton.setEnabled(version > 12);
        }
    }

    private void showNewModulesCompsite() {
        this.defaultModulesComposite.setVisible(false);
        this.newModulesComposite.setVisible(true);
        if (!this.isAnyModuleRadioSelected()) {
            this.appClientRadioButton.setSelection(true);
        }
        this.setSelectedNode(this.getWizardNodeFromSelection());
        this.stackLayout.topControl = this.newModulesComposite;
    }

    private GenericWizardNode getWizardNodeFromSelection() {
        if (this.appClientRadioButton.getSelection()) {
            return this.getAppClientNode();
        }
        if (this.connectorRadioButton != null && this.connectorRadioButton.getSelection()) {
            return this.getConnectorNode();
        }
        if (this.ejbRadioButton != null && this.ejbRadioButton.getSelection()) {
            return this.getEjbNode();
        }
        if (this.webRadioButton != null && this.webRadioButton.getSelection()) {
            return this.getWebNode();
        }
        return null;
    }

    private boolean isAnyModuleRadioSelected() {
        return this.appClientRadioButton.getSelection() || this.connectorRadioButton != null && this.connectorRadioButton.getSelection() || this.ejbRadioButton != null && this.ejbRadioButton.getSelection() || this.webRadioButton != null && this.webRadioButton.getSelection();
    }

    private GenericWizardNode getAppClientNode() {
        if (this.appClientNode == null) {
            this.appClientNode = new GenericWizardNode(){

                protected IWizard createWizard() {
                    IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentCreationDataModelProvider());
                    dm.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", false);
                    return new AppClientComponentCreationWizard(dm);
                }
            };
        }
        return this.appClientNode;
    }

    private GenericWizardNode getConnectorNode() {
        if (this.connectorNode == null) {
            this.connectorNode = new GenericWizardNode(){

                protected IWizard createWizard() {
                    J2EEComponentCreationWizard result = null;
                    IWizardRegistry newWizardRegistry = WorkbenchPlugin.getDefault().getNewWizardRegistry();
                    IWizardDescriptor descriptor = newWizardRegistry.findWizard("org.eclipse.jst.j2ee.jca.ui.ConnectorComponentCreationWizard");
                    try {
                        result = (J2EEComponentCreationWizard)descriptor.createWizard();
                        IDataModel dm = result.getDataModel();
                        dm.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", false);
                        result.setDataModel(dm);
                    }
                    catch (CoreException ce) {
                        Logger.getLogger().log((Throwable)ce);
                    }
                    return result;
                }
            };
        }
        return this.connectorNode;
    }

    private GenericWizardNode getEjbNode() {
        if (this.ejbNode == null) {
            this.ejbNode = new GenericWizardNode(){

                protected IWizard createWizard() {
                    J2EEComponentCreationWizard result = null;
                    IWizardRegistry newWizardRegistry = WorkbenchPlugin.getDefault().getNewWizardRegistry();
                    IWizardDescriptor descriptor = newWizardRegistry.findWizard("org.eclipse.jst.ejb.ui.EJBComponentCreationWizard");
                    try {
                        result = (J2EEComponentCreationWizard)descriptor.createWizard();
                        IDataModel dm = result.getDataModel();
                        dm.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", false);
                        result.setDataModel(dm);
                    }
                    catch (CoreException ce) {
                        Logger.getLogger().log((Throwable)ce);
                    }
                    return result;
                }
            };
        }
        return this.ejbNode;
    }

    private GenericWizardNode getWebNode() {
        if (this.webNode == null) {
            this.webNode = new GenericWizardNode(){

                protected IWizard createWizard() {
                    IWorkbenchWizard result = null;
                    IWizardRegistry newWizardRegistry = WorkbenchPlugin.getDefault().getNewWizardRegistry();
                    IWizardDescriptor servletWizardDescriptor = newWizardRegistry.findWizard("org.eclipse.jst.servlet.ui.WebComponentCreationWizard");
                    try {
                        result = servletWizardDescriptor.createWizard();
                    }
                    catch (CoreException ce) {
                        Logger.getLogger().log((Throwable)ce);
                    }
                    return result;
                }
            };
        }
        return this.webNode;
    }

    private void setSelectedNode(GenericWizardNode selectedNode) {
        this.selectedNode = selectedNode;
    }

    public boolean canFlipToNextPage() {
        if (!this.defaultModulesButton.getSelection()) {
            return this.selectedNode != null;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        if (this.selectedNode == null) {
            return null;
        }
        IPluginContribution pluginContribution = new IPluginContribution(){

            public String getLocalId() {
                String id = null;
                if (NewJ2EEComponentSelectionPage.this.selectedNode == NewJ2EEComponentSelectionPage.this.appClientNode) {
                    id = "org.eclipse.jst.j2ee.internal.internal.internal.appclientProjectWizard";
                } else if (NewJ2EEComponentSelectionPage.this.selectedNode == NewJ2EEComponentSelectionPage.this.ejbNode) {
                    id = "org.eclipse.jst.j2ee.internal.internal.internal.ejb.ui.util.ejbProjectWizard";
                } else if (NewJ2EEComponentSelectionPage.this.selectedNode == NewJ2EEComponentSelectionPage.this.connectorNode) {
                    id = "org.eclipse.jst.j2ee.internal.internal.internal.jcaProjectWizard";
                } else if (NewJ2EEComponentSelectionPage.this.selectedNode == NewJ2EEComponentSelectionPage.this.webNode) {
                    id = "org.eclipse.jst.j2ee.internal.internal.internal.webProjectWizard";
                }
                return id;
            }

            public String getPluginId() {
                return "org.eclipse.jst.j2ee.internal.internal.internal.ui";
            }
        };
        if (!WorkbenchActivityHelper.allowUseOf((Object)pluginContribution)) {
            return null;
        }
        boolean isCreated = this.selectedNode.isContentCreated();
        IWizard wizard = this.selectedNode.getWizard();
        if (wizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (!isCreated) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    protected void validatePage() {
        if (!this.defaultModulesButton.getSelection()) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
        } else {
            super.validatePage();
        }
    }
}

