/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModel;
import org.eclipse.jst.j2ee.internal.dialogs.TypeSearchEngine;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.AnnotationsStandaloneGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.frameworks.internal.ui.WTPWizardPage;

public class NewJavaClassWizardPage
extends WTPWizardPage {
    private Text folderText;
    private Button folderButton;
    private Text packageText;
    private Button packageButton;
    protected Text classText;
    private Text superText;
    private Button superButton;
    private Combo projectNameCombo;
    private Combo componentNameCombo;
    private String moduleType;
    private boolean hasNewModuleButton;
    private AnnotationsStandaloneGroup annotationsGroup = null;
    private String projectName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewJavaClassWizardPage(ArtifactEditOperationDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super((WTPOperationDataModel)model, pageName);
        this.setDescription(pageDesc);
        this.setTitle(pageTitle);
        this.setPageComplete(false);
        this.moduleType = moduleType;
        this.hasNewModuleButton = false;
        this.projectName = null;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"ArtifactEditOperationDataModel.PROJECT_NAME", "ArtifactEditOperationDataModel.MODULE_NAME", "NewJavaClassDataModel.SOURCE_FOLDER", "NewJavaClassDataModel.JAVA_PACKAGE", "NewJavaClassDataModel.CLASS_NAME", "NewJavaClassDataModel.SUPERCLASS"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.addProjectNameGroup(composite);
        this.addComponentGroup(composite);
        this.addFolderGroup(composite);
        this.addSeperator(composite, 3);
        this.addPackageGroup(composite);
        this.addClassnameGroup(composite);
        this.addSuperclassGroup(composite);
        this.createAnnotationsGroup(composite);
        this.folderText.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getInfopopID());
        return composite;
    }

    private void addComponentGroup(Composite composite) {
        Label componentLabel = new Label(composite, 16384);
        componentLabel.setText(J2EEUIMessages.getResourceString("99"));
        componentLabel.setLayoutData((Object)new GridData(256));
        this.componentNameCombo = new Combo(composite, 2056);
        GridData data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        this.componentNameCombo.setLayoutData((Object)data);
        this.initializeComponentList();
        this.synchHelper.synchCombo(this.componentNameCombo, "ArtifactEditOperationDataModel.MODULE_NAME", new Control[0]);
        if (!this.hasNewModuleButton) {
            new Label(composite, 0);
        } else {
            Button newModuleButton = new Button(composite, 8);
            newModuleButton.setText(J2EEUIMessages.getResourceString("14"));
            newModuleButton.setLayoutData((Object)new GridData(256));
            newModuleButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    NewJavaClassWizardPage.this.handleNewModuleButtonPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void initializeComponentList() {
        String sourceFolder;
        ArrayList<String> componentList = new ArrayList<String>();
        if (this.projectNameCombo.getText().length() == 0) {
            return;
        }
        IProject project = ProjectUtilities.getProject((String)this.projectNameCombo.getText());
        IVirtualComponent[] components = ComponentCore.createFlexibleProject((IProject)project).getComponentsOfType(this.moduleType);
        int i = 0;
        while (i < components.length) {
            if (!componentList.contains(components[i].getName())) {
                componentList.add(components[i].getName());
            }
            ++i;
        }
        String[] componentNames = new String[componentList.size()];
        int i2 = 0;
        while (i2 < componentList.size()) {
            componentNames[i2] = (String)componentList.get(i2);
            ++i2;
        }
        this.model.setIgnorePropertyChanges(true);
        this.componentNameCombo.setItems(componentNames);
        this.model.setIgnorePropertyChanges(false);
        if (componentNames.length > 0) {
            this.componentNameCombo.setText(componentNames[0]);
            this.model.setProperty("ArtifactEditOperationDataModel.MODULE_NAME", (Object)this.componentNameCombo.getText());
        }
        if (this.folderText != null && (sourceFolder = this.getModel().getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER")) != null) {
            this.folderText.setText(sourceFolder);
        }
    }

    private void addProjectNameGroup(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText(String.valueOf(J2EEUIMessages.getResourceString("32")) + ":");
        GridData data = new GridData();
        projectNameLabel.setLayoutData((Object)data);
        this.projectNameCombo = new Combo(parent, 2056);
        data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        this.projectNameCombo.setLayoutData((Object)data);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                NewJavaClassWizardPage.this.initializeComponentList();
            }
        });
        this.synchHelper.synchCombo(this.projectNameCombo, "ArtifactEditOperationDataModel.PROJECT_NAME", null);
        this.initializeProjectList();
        new Label(parent, 0);
    }

    private void initializeProjectList() {
        IProject[] workspaceProjects = ProjectUtilities.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && ComponentCore.createFlexibleProject((IProject)project).getComponentsOfType(this.moduleType).length > 0) {
                    items.add(project.getName());
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        if (items.isEmpty()) {
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        try {
            IProject selectedProject = this.getSelectedProject();
            if (selectedProject != null && selectedProject.isAccessible() && selectedProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                this.projectNameCombo.setText(selectedProject.getName());
                this.model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)selectedProject.getName());
            }
        }
        catch (CoreException coreException) {}
        if (this.projectName == null && names.length > 0) {
            this.projectName = names[0];
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && this.projectName != null) {
            this.projectNameCombo.setText(this.projectName);
            this.model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)this.projectName);
        }
    }

    private void addFolderGroup(Composite composite) {
        Label folderLabel = new Label(composite, 16384);
        folderLabel.setText(J2EEUIMessages.FOLDER_LABEL);
        folderLabel.setLayoutData((Object)new GridData(256));
        this.folderText = new Text(composite, 2052);
        this.folderText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.folderText, "NewJavaClassDataModel.SOURCE_FOLDER", null);
        this.folderButton = new Button(composite, 8);
        this.folderButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
        this.folderButton.setLayoutData((Object)new GridData(256));
        this.folderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaClassWizardPage.this.handleFolderButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addPackageGroup(Composite composite) {
        Label packageLabel = new Label(composite, 16384);
        packageLabel.setText(J2EEUIMessages.JAVA_PACKAGE_LABEL);
        packageLabel.setLayoutData((Object)new GridData(256));
        this.packageText = new Text(composite, 2052);
        this.packageText.setLayoutData((Object)new GridData(768));
        IPackageFragment packageFragment = this.getSelectedPackageFragment();
        if (packageFragment != null && packageFragment.exists()) {
            this.projectNameCombo.setText(packageFragment.getElementName());
            this.model.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)packageFragment.getElementName());
        }
        this.synchHelper.synchText(this.packageText, "NewJavaClassDataModel.JAVA_PACKAGE", null);
        this.packageButton = new Button(composite, 8);
        this.packageButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
        this.packageButton.setLayoutData((Object)new GridData(256));
        this.packageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaClassWizardPage.this.handlePackageButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addClassnameGroup(Composite composite) {
        Label classLabel = new Label(composite, 16384);
        classLabel.setText(J2EEUIMessages.CLASS_NAME_LABEL);
        classLabel.setLayoutData((Object)new GridData(256));
        this.classText = new Text(composite, 2052);
        this.classText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.classText, "NewJavaClassDataModel.CLASS_NAME", null);
        new Label(composite, 16384);
    }

    protected void addSeperator(Composite composite, int horSpan) {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        Label seperator = new Label(composite, 258);
        data = new GridData(256);
        data.horizontalSpan = horSpan;
        seperator.setLayoutData((Object)data);
    }

    private void addSuperclassGroup(Composite composite) {
        Label superLabel = new Label(composite, 16384);
        superLabel.setText(J2EEUIMessages.SUPERCLASS_LABEL);
        superLabel.setLayoutData((Object)new GridData(256));
        this.superText = new Text(composite, 2052);
        this.superText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.superText, "NewJavaClassDataModel.SUPERCLASS", null);
        this.superButton = new Button(composite, 8);
        this.superButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
        this.superButton.setLayoutData((Object)new GridData(256));
        this.superButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaClassWizardPage.this.handleSuperButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void handleFolderButtonPressed() {
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(J2EEUIMessages.CONTAINER_SELECTION_DIALOG_TITLE);
        dialog.setMessage(J2EEUIMessages.CONTAINER_SELECTION_DIALOG_DESC);
        dialog.addFilter(filter);
        IProject project = ((NewJavaClassDataModel)this.model).getTargetProject();
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (project != null) {
            dialog.setInitialSelection((Object)project);
        }
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    this.folderText.setText(container.getFullPath().toString());
                }
            }
            catch (Exception exception) {}
        }
    }

    private void handleNewModuleButtonPressed() {
        this.createNewComponent();
        this.initializeProjectList();
        this.initializeComponentList();
    }

    protected void createNewComponent() {
    }

    protected void handlePackageButtonPressed() {
        IPackageFragmentRoot packRoot = ((NewJavaClassDataModel)this.model).getJavaPackageFragmentRoot();
        if (packRoot == null) {
            return;
        }
        Object[] packages = null;
        try {
            packages = packRoot.getChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_TITLE);
        dialog.setMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_DESC);
        dialog.setEmptyListMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_MSG_NONE);
        dialog.setElements(packages);
        if (dialog.open() == 0) {
            IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
            if (fragment != null) {
                this.packageText.setText(fragment.getElementName());
            } else {
                this.packageText.setText("");
            }
        }
    }

    protected void handleSuperButtonPressed() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IPackageFragmentRoot packRoot = ((NewJavaClassDataModel)this.model).getJavaPackageFragmentRoot();
        if (packRoot == null) {
            return;
        }
        IJavaSearchScope scope = TypeSearchEngine.createJavaSearchScopeForAProject(packRoot.getJavaProject(), true, true);
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 5);
        dialog.setTitle(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_TITLE);
        dialog.setMessage(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_DESC);
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getFirstResult();
            String superclassFullPath = "";
            if (type != null) {
                superclassFullPath = type.getFullyQualifiedName();
            }
            this.superText.setText(superclassFullPath);
            this.getControl().setCursor(null);
            return;
        }
        this.getControl().setCursor(null);
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection[0] != null && !(selection[0] instanceof IProject)) {
                    return WTPCommonPlugin.OK_STATUS;
                }
                return WTPCommonPlugin.createErrorStatus((String)J2EEUIMessages.CONTAINER_SELECTION_DIALOG_VALIDATOR_MESG);
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName().equals(NewJavaClassWizardPage.this.model.getProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
                }
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    ArtifactEditOperationDataModel dataModel = (ArtifactEditOperationDataModel)NewJavaClassWizardPage.this.model;
                    IPackageFragmentRoot[] sourceFolders = ComponentUtilities.getSourceContainers((IVirtualComponent)dataModel.getComponent());
                    int i = 0;
                    while (i < sourceFolders.length) {
                        if (sourceFolders[i].getResource() != null && sourceFolders[i].getResource().equals((Object)folder)) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }
        };
    }

    private void createAnnotationsGroup(Composite parent) {
        this.annotationsGroup = new AnnotationsStandaloneGroup(parent, this.model, "jst.ejb".equals(this.moduleType), "jst.web".equals(this.moduleType));
        if (!this.model.isSet("ArtifactEditOperationDataModel.PROJECT_NAME")) {
            return;
        }
        IProject project = ((NewJavaClassDataModel)this.model).getTargetProject();
        this.annotationsGroup.setEnablement(project);
    }

    private IProject getSelectedProject() {
        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        StructuredSelection stucturedSelection = (StructuredSelection)selection;
        if (stucturedSelection.getFirstElement() instanceof EObject) {
            return ProjectUtilities.getProject((Object)stucturedSelection.getFirstElement());
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        return null;
    }

    private IPackageFragment getSelectedPackageFragment() {
        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null) {
            if (element.getElementType() == 4) {
                return (IPackageFragment)element;
            }
            if (element.getElementType() == 7) {
                return ((IType)element).getPackageFragment();
            }
        }
        return null;
    }

    protected IJavaElement getInitialJavaElement(ISelection selection) {
        Object selectedElement;
        IJavaProject jelem = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)selectedElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jelem = (IJavaElement)adaptable.getAdapter((Class)clazz)) == null) {
                IResource resource;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null && resource.getType() != 8) {
                    while (jelem == null && resource.getType() != 4) {
                        resource = resource.getParent();
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        jelem = (IJavaElement)resource.getAdapter((Class)clazz3);
                    }
                    if (jelem == null) {
                        jelem = JavaCore.create((IResource)resource);
                    }
                }
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchPart part = JavaPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = JavaPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                jelem = (IJavaElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return jelem;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void setHasNewModuleButton(boolean hasNewModuleButton) {
        this.hasNewModuleButton = hasNewModuleButton;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

