/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.JRESelectDecorator;
import org.eclipse.jst.server.generic.ui.internal.ServerDefinitionTypeAwareWizardFragment;
import org.eclipse.jst.server.generic.ui.internal.ServerTypeDefinitionRuntimeDecorator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class GenericServerRuntimeWizardFragment
extends ServerDefinitionTypeAwareWizardFragment {
    private GenericServerCompositeDecorator[] fDecorators;
    Composite fParent;
    static /* synthetic */ Class class$0;

    public boolean isComplete() {
        GenericServerRuntime runtime = this.getRuntimeDelegate();
        if (runtime == null) {
            return false;
        }
        IStatus status = runtime.validate();
        return status != null && status.isOK();
    }

    public void createContent(Composite parent, IWizardHandle handle) {
        this.fParent = parent;
    }

    private String getServerDefinitionId() {
        String currentDefinition = null;
        if (this.getRuntimeDelegate() != null) {
            currentDefinition = this.getRuntimeDelegate().getRuntime().getRuntimeType().getId();
        }
        if (currentDefinition != null && currentDefinition.length() > 0) {
            return currentDefinition;
        }
        return null;
    }

    public void enter() {
        if (this.getRuntimeDelegate() != null) {
            this.getRuntimeDelegate().getRuntimeWorkingCopy().setName(this.createName());
        }
        Control[] controls = this.fParent.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        Map properties = null;
        ServerRuntime definition = null;
        if (this.getRuntimeDelegate() != null) {
            properties = this.getRuntimeDelegate().getServerInstanceProperties();
            definition = this.getServerTypeDefinition(this.getServerDefinitionId(), properties);
        }
        this.fDecorators = new GenericServerCompositeDecorator[2];
        this.fDecorators[0] = new JRESelectDecorator(this.getRuntimeDelegate());
        this.fDecorators[1] = new ServerTypeDefinitionRuntimeDecorator(definition, properties, this.getWizard(), this.getRuntimeDelegate());
        new GenericServerComposite(this.fParent, this.fDecorators);
        this.fParent.layout();
        int i2 = 0;
        while (i2 < this.fDecorators.length) {
            if (this.fDecorators[i2].validate()) {
                return;
            }
            ++i2;
        }
    }

    public void exit() {
    }

    private String createName() {
        GenericServerRuntime dl = this.getRuntimeDelegate();
        IRuntimeType runtimeType = dl.getRuntime().getRuntimeType();
        String name = GenericServerUIMessages.bind((String)GenericServerUIMessages.runtimeName, (Object)runtimeType.getName());
        IRuntime[] list = ServerCore.getRuntimes();
        int suffix = 1;
        String suffixName = name;
        int i = 0;
        while (i < list.length) {
            if ((list[i].getName().equals(name) || list[i].getName().equals(suffixName)) && !list[i].equals(dl.getRuntime())) {
                ++suffix;
            }
            suffixName = String.valueOf(name) + " " + suffix;
            ++i;
        }
        if (suffix > 1) {
            return suffixName;
        }
        return name;
    }

    private GenericServerRuntime getRuntimeDelegate() {
        IRuntimeWorkingCopy wc = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (wc == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (GenericServerRuntime)wc.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
    }

    public String description() {
        String rName = this.getRuntimeName();
        if (rName == null || rName.length() < 1) {
            rName = "Generic";
        }
        return GenericServerUIMessages.bind((String)GenericServerUIMessages.runtimeWizardDescription, (Object)rName);
    }

    public String title() {
        String rName = this.getRuntimeName();
        if (rName == null || rName.length() < 1) {
            rName = "Generic";
        }
        return GenericServerUIMessages.bind((String)GenericServerUIMessages.runtimeWizardTitle, (Object)rName);
    }

    private String getRuntimeName() {
        if (this.getRuntimeDelegate() != null && this.getRuntimeDelegate().getRuntime() != null) {
            return this.getRuntimeDelegate().getRuntime().getName();
        }
        return null;
    }
}

