/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.application.internal.operations.AddArchiveProjectsToEAROperation;
import org.eclipse.jst.j2ee.application.internal.operations.AddArchiveToEARDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.internal.emfworkbench.operation.EditModelOperationDataModel;

public class AddArchiveProjectsToEARDataModel
extends EditModelOperationDataModel {
    public static final String MODULE_LIST = "AddArchiveProjectsToEARDataModel.MODULE_LIST";
    public static final String MODULE_MODELS = "AddArchiveProjectsToEARDataModel.MODULE_MODELS";
    public static final String ALL_MODULE_MODELS = "AddModulesToEARDataModel.ALL_MODULE_MODELS";

    public WTPOperation getDefaultOperation() {
        return new AddArchiveProjectsToEAROperation(this);
    }

    protected void init() {
        super.init();
        this.setProperty("EditModelOperationDataModel.EDIT_MODEL_ID", "org.eclipse.jst.j2ee.application.editModel");
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(MODULE_LIST);
        this.addValidBaseProperty(MODULE_MODELS);
        this.addValidBaseProperty(ALL_MODULE_MODELS);
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(MODULE_LIST) || propertyName.equals(MODULE_MODELS)) {
            return Collections.EMPTY_LIST;
        }
        return super.getDefaultProperty(propertyName);
    }

    protected Object doGetProperty(String propertyName) {
        if (propertyName.equals(ALL_MODULE_MODELS)) {
            return this.computeAllModuleModels();
        }
        return super.doGetProperty(propertyName);
    }

    private List computeAllModuleModels() {
        List projects = (List)this.getProperty(MODULE_LIST);
        List models = (List)this.getProperty(MODULE_MODELS);
        if (!projects.isEmpty()) {
            return this.computeAllArchiveModels(projects, models);
        }
        return models;
    }

    private List computeAllArchiveModels(List projects, List models) {
        ArrayList<AddArchiveToEARDataModel> allModels = new ArrayList<AddArchiveToEARDataModel>(projects.size());
        String earProjName = this.getStringProperty("EditModelOperationDataModel.PROJECT_NAME");
        IProject project = null;
        AddArchiveToEARDataModel model = null;
        int i = 0;
        while (i < projects.size()) {
            project = (IProject)projects.get(i);
            model = this.findOrCreateModel(project, models);
            if (model != null) {
                model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", earProjName);
                allModels.add(model);
            }
            ++i;
        }
        return allModels;
    }

    private AddArchiveToEARDataModel findOrCreateModel(IProject project, List models) {
        return null;
    }
}

