/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.internal.operations.AddArchiveProjectToEAROperation;
import org.eclipse.jst.j2ee.application.internal.operations.AddArchiveToEARDataModel;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.servertarget.ServerTargetDataModel;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class AddUtilityProjectToEARDataModel
extends AddArchiveToEARDataModel {
    private static final String NESTED_MODEL_MANIFEST = "AddUtilityProjectToEARDataModel.NESTED_MODEL_MANIFEST";
    private static final String NESTED_MODEL_SERVER_TARGET = "AddUtilityProjectToEARDataModel.NESTED_MODEL_SERVER_TARGET";
    private UpdateManifestDataModel manifestModel;
    private ServerTargetDataModel serverTargetModel;

    public static AddUtilityProjectToEARDataModel createAddToEARDataModel(String earProjectName, IProject moduleProject) {
        AddUtilityProjectToEARDataModel model = new AddUtilityProjectToEARDataModel();
        model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", earProjectName);
        return model;
    }

    public static AddUtilityProjectToEARDataModel createAddToEARDataModel(String earModuleName, WorkbenchComponent module) {
        AddUtilityProjectToEARDataModel model = new AddUtilityProjectToEARDataModel();
        model.setProperty("ArtifactEditOperationDataModel.MODULE_NAME", earModuleName);
        model.setProperty("AddModuleToEARDataModel.ARCHIVE_PROJECT", module);
        return model;
    }

    public WTPOperation getDefaultOperation() {
        return new AddArchiveProjectToEAROperation(this);
    }

    protected void initNestedModels() {
        super.initNestedModels();
        this.manifestModel = new UpdateManifestDataModel();
        this.addNestedModel(NESTED_MODEL_MANIFEST, this.manifestModel);
        this.serverTargetModel = new ServerTargetDataModel();
        this.addNestedModel(NESTED_MODEL_SERVER_TARGET, this.serverTargetModel);
    }

    private void updateServerTargetIDs() {
        EARNatureRuntime nature = EARNatureRuntime.getRuntime(this.getTargetProject());
        if (nature != null) {
            this.serverTargetModel.setIntProperty("ServerTargetDataModel.J2EE_VERSION_ID", nature.getJ2EEVersion());
            IRuntime targetType = ServerCore.getProjectProperties((IProject)this.getTargetProject()).getRuntimeTarget();
            if (targetType != null) {
                this.serverTargetModel.setProperty("ServerTargetDataModel.RUNTIME_TARGET_ID", targetType.getId());
            }
            this.serverTargetModel.setIntProperty("ServerTargetDataModel.DD_TYPE_ID", 2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUtilityJARUriInFirstEAR(IProject utilProject) {
        EAREditModel model;
        Object key;
        block3: {
            String string;
            key = new Object();
            EARNatureRuntime earNature = J2EEProjectUtilities.getFirstReferencingEARProject(utilProject);
            if (earNature == null) return null;
            model = earNature.getEarEditModelForRead(key);
            try {
                UtilityJARMapping mapping = model.getUtilityJARMapping(utilProject);
                if (mapping == null || mapping.getUri() == null || mapping.getUri().length() <= 0) break block3;
                string = mapping.getUri();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                model.releaseAccess(key);
                throw throwable;
            }
            model.releaseAccess(key);
            return string;
        }
        Object var6_9 = null;
        model.releaseAccess(key);
        return null;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean result = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals("AddModuleToEARDataModel.ARCHIVE_PROJECT")) {
            WorkbenchComponent wbComp = (WorkbenchComponent)propertyValue;
            IProject proj = this.getProjectForGivenComponent(wbComp);
            this.updateManifestModel(proj);
            this.updateServerTargetModel(proj);
        } else if (propertyName.equals("ArtifactEditOperationDataModel.PROJECT_NAME")) {
            this.updateServerTargetIDs();
        }
        return result;
    }

    private void updateServerTargetModel(IProject proj) {
        if (proj != null) {
            this.serverTargetModel.setProperty("ServerTargetDataModel.PROJECT_NAME", proj.getName());
        }
    }

    private void updateManifestModel(IProject proj) {
        if (proj != null) {
            this.manifestModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", proj.getName());
        } else {
            this.manifestModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", null);
        }
    }

    protected String getDefaultArchiveURI() {
        WorkbenchComponent wbComp = (WorkbenchComponent)this.getProperty("AddModuleToEARDataModel.ARCHIVE_PROJECT");
        return wbComp.getHandle().toString();
    }

    protected IStatus doValidateProperty(String propertyName) {
        if ("AddModuleToEARDataModel.ARCHIVE_PROJECT".equals(propertyName)) {
            IStatus status = super.doValidateProperty(propertyName);
            if (!status.isOK()) {
                return status;
            }
            WorkbenchComponent wbComp = (WorkbenchComponent)this.getProperty("AddModuleToEARDataModel.ARCHIVE_PROJECT");
            if (this.isWebOrClientModule(wbComp) || !this.isJavaModule(wbComp)) {
                return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.getString("6"));
            }
        } else if ("AddModuleToEARDataModel.URI".equals(propertyName)) {
            IStatus status = super.doValidateProperty(propertyName);
            if (!status.isOK()) {
                return status;
            }
            if (!this.getStringProperty("AddModuleToEARDataModel.URI").endsWith(".jar")) {
                return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.getString("7"));
            }
        }
        return super.doValidateProperty(propertyName);
    }

    private boolean isJavaModule(WorkbenchComponent wbComp) {
        return wbComp.getComponentType().getComponentTypeId().equals("jst.utility");
    }

    private boolean isWebOrClientModule(WorkbenchComponent wbComp) {
        String typeID = wbComp.getComponentType().getComponentTypeId();
        return typeID.equals("jst.web") || typeID.equals("jst.appclient");
    }

    public UpdateManifestDataModel getManifestModel() {
        return this.manifestModel;
    }

    public ServerTargetDataModel getServerTargetModel() {
        return this.serverTargetModel;
    }
}

