/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.datamodel.properties.IJavaComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.UpdateProjectClasspath;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.operation.ComponentCreationOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.FlexibleJavaProjectPreferenceUtil;

public class JavaUtilityComponentCreationOperation
extends ComponentCreationOperation
implements IJavaComponentCreationDataModelProperties {
    public JavaUtilityComponentCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        super.execute("jst.utility", monitor, info);
        this.createManifest(monitor);
        this.addSrcFolderToProject();
        return OK_STATUS;
    }

    public IStatus execute(String componentType, IProgressMonitor monitor, IAdaptable info) {
        super.execute(componentType, monitor, info);
        this.createManifest(monitor);
        this.addSrcFolderToProject();
        return OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    protected void createAndLinkJ2EEComponentsForMultipleComponents() throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getProject(), (String)this.getComponentDeployName());
        component.create(0, null);
        IVirtualFolder javaSourceFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        javaSourceFolder.createLink((IPath)new Path("/" + this.getJavaSourceFolder()), 0, null);
        IVirtualFolder metaInfFolder = component.getRootFolder().getFolder((IPath)new Path("/META-INF"));
        metaInfFolder.createLink((IPath)new Path("/" + this.getComponentName() + "/" + "META-INF"), 0, null);
    }

    protected void createAndLinkJ2EEComponentsForSingleComponent() throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getProject(), (String)this.getComponentDeployName());
        component.create(0, null);
        IVirtualFolder javaSourceFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        javaSourceFolder.createLink((IPath)new Path("/" + this.getJavaSourceFolder()), 0, null);
        IVirtualFolder metaInfFolder = component.getRootFolder().getFolder((IPath)new Path("/META-INF"));
        metaInfFolder.createLink((IPath)new Path("/META-INF"), 0, null);
    }

    protected void createManifest(IProgressMonitor monitor) {
        IFolder container = this.getProject().getFolder(this.getManifestFolder());
        IFile file = container.getFile((IPath)new Path("MANIFEST.MF"));
        try {
            ManifestFileCreationAction.createManifestFile(file, this.getProject());
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    private void addSrcFolderToProject() {
        new UpdateProjectClasspath(this.getJavaSourceFolder(), this.getComponentName(), this.getProject());
    }

    String getJavaSourceFolder() {
        String folder = this.model.getStringProperty("IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER");
        String ret = "";
        if (!folder.equals("/")) {
            ret = this.model.getStringProperty("IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER");
        }
        return ret;
    }

    String getManifestFolder() {
        return this.model.getStringProperty("IJavaComponentCreationDataModelProperties.MANIFEST_FOLDER");
    }

    protected String getVersion() {
        return null;
    }

    protected List getProperties() {
        ArrayList<Property> newProps = new ArrayList<Property>();
        Property outputProperty = this.getOutputProperty();
        if (outputProperty != null) {
            newProps.add(outputProperty);
        }
        return newProps;
    }

    protected Property getOutputProperty() {
        String javaSourceFolder = this.model.getStringProperty("IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER");
        if (javaSourceFolder != null && !javaSourceFolder.equals("")) {
            Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
            IPath newOutputPath = null;
            newOutputPath = FlexibleJavaProjectPreferenceUtil.getMultipleModulesPerProjectProp() ? Path.fromOSString((String)("/bin/" + this.getComponentName() + '/')) : Path.fromOSString((String)"/bin/");
            prop.setName("java-output-path");
            prop.setValue(newOutputPath.toString());
            return prop;
        }
        return null;
    }
}

