/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactImportOperation;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EARComponentImportOperation
extends J2EEArtifactImportOperation {
    private EARFile earFile;

    public EARComponentImportOperation(IDataModel dataModel) {
        super(dataModel);
        this.earFile = (EARFile)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        super.doExecute(monitor);
        List modelsToImport = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
        try {
            IDataModel importModel = null;
            List allModels = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
            ArrayList<ComponentHandle> componentHandlesToAdd = new ArrayList<ComponentHandle>();
            int i = 0;
            while (i < allModels.size()) {
                importModel = (IDataModel)allModels.get(i);
                if (modelsToImport.contains(importModel)) {
                    importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)Boolean.FALSE);
                    try {
                        importModel.getDefaultOperation().execute(monitor, this.info);
                    }
                    catch (ExecutionException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                    componentHandlesToAdd.add(((IVirtualComponent)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.COMPONENT")).getComponentHandle());
                }
                ++i;
            }
            if (componentHandlesToAdd.size() > 0) {
                IDataModel addComponentsDM = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE", (Object)this.virtualComponent.getComponentHandle());
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST", componentHandlesToAdd);
                addComponentsDM.getDefaultOperation().execute(monitor, this.info);
            }
            try {
                this.fixupClasspaths(modelsToImport, this.virtualComponent);
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            Object var8_12 = null;
            this.resetDisposeImportModels();
            return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.resetDisposeImportModels();
            throw throwable;
        }
    }

    private void resetDisposeImportModels() {
        this.resetDisposeImportModels((List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST"));
    }

    private void resetDisposeImportModels(List models) {
        int i = 0;
        while (i < models.size()) {
            IDataModel model = (IDataModel)models.get(i);
            model.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)Boolean.TRUE);
            ++i;
        }
    }

    private void fixupClasspaths(List selectedModels, IVirtualComponent earComponent) throws JavaModelException {
        int i = 0;
        while (i < selectedModels.size()) {
            IDataModel importModel = (IDataModel)selectedModels.get(i);
            Archive archive = (Archive)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            String[] manifestClasspath = archive.getManifest().getClassPathTokenized();
            if (manifestClasspath.length > 0) {
                List extraEntries = this.fixupClasspath(earComponent, manifestClasspath, new ArrayList(), archive, (IVirtualComponent)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.COMPONENT"));
                EARComponentImportOperation.addToClasspath(importModel, extraEntries);
                this.fixModuleReference(importModel, manifestClasspath);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List fixupClasspath(IVirtualComponent earComponent, String[] manifestClasspath, List computedFiles, Archive anArchive, IVirtualComponent nestedComponent) throws JavaModelException {
        ArrayList<IClasspathEntry> extraEntries = new ArrayList<IClasspathEntry>();
        int j = 0;
        while (true) {
            block12: {
                IVirtualFile vFile;
                if (j >= manifestClasspath.length) {
                    return extraEntries;
                }
                String manifestURI = ArchiveUtil.deriveEARRelativeURI((String)manifestClasspath[j], (Archive)anArchive);
                if (manifestURI != null && !computedFiles.contains(vFile = earComponent.getRootFolder().getFile(manifestURI))) {
                    computedFiles.add(vFile);
                    if (vFile.exists()) {
                        Object var13_14;
                        IFile file = vFile.getUnderlyingFile();
                        extraEntries.add(JavaCore.newLibraryEntry((IPath)file.getFullPath(), (IPath)file.getFullPath(), null, (boolean)true));
                        Archive archive = null;
                        try {
                            try {
                                archive = (Archive)this.earFile.getFile(manifestURI);
                                String[] nestedManifestClasspath = archive.getManifest().getClassPathTokenized();
                                extraEntries.addAll(this.fixupClasspath(earComponent, nestedManifestClasspath, computedFiles, archive, nestedComponent));
                            }
                            catch (FileNotFoundException e) {
                                Logger.getLogger().logError((Throwable)e);
                            }
                        }
                        catch (Throwable throwable) {
                            var13_14 = null;
                            if (archive != null) {
                                archive.close();
                            }
                            throw throwable;
                        }
                        {
                            var13_14 = null;
                            if (archive != null) {
                                archive.close();
                            }
                            break block12;
                        }
                    }
                    String compSearchName = manifestURI.substring(0, manifestURI.length() - 4);
                    IVirtualReference vRef = earComponent.getReference(compSearchName);
                    if (vRef != null && nestedComponent != vRef.getReferencedComponent()) {
                        IProject project = vRef.getReferencedComponent().getProject();
                        extraEntries.add(JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)true));
                    }
                }
            }
            ++j;
        }
    }

    private void releaseDeploymentDescriptor() {
        try {
            XMLResource res;
            if (this.earFile != null && this.earFile.isDeploymentDescriptorSet() && (res = (XMLResource)this.earFile.getDeploymentDescriptor().eResource()) != null) {
                res.releaseFromRead();
            }
        }
        catch (Exception suppress) {
            Logger.getLogger().logError((Throwable)suppress);
        }
    }

    protected SaveStrategy createSaveStrategy(IProject project) {
        return null;
    }

    protected SaveStrategy createSaveStrategy(IVirtualComponent virtualComponent) {
        return new EARComponentSaveStrategyImpl(virtualComponent);
    }
}

