/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.OverwriteHandlerException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;

public abstract class J2EEArtifactImportOperation
extends AbstractDataModelOperation {
    protected ModuleFile moduleFile;
    protected IVirtualComponent virtualComponent;
    protected IAdaptable info;

    public J2EEArtifactImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus iStatus;
        try {
            this.info = info;
            this.doExecute(monitor);
            iStatus = OK_STATUS;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.model.dispose();
            throw throwable;
        }
        this.model.dispose();
        return iStatus;
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        this.moduleFile = (ModuleFile)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
        monitor.beginTask(null, this.moduleFile.getFiles().size());
        this.virtualComponent = this.createVirtualComponent(this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION"), monitor);
        try {
            this.importModuleFile(monitor);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected IVirtualComponent createVirtualComponent(IDataModel model, IProgressMonitor monitor) throws ExecutionException {
        model.getDefaultOperation().execute(monitor, this.info);
        return (IVirtualComponent)model.getProperty("IComponentCreationDataModelProperties.COMPONENT");
    }

    protected abstract SaveStrategy createSaveStrategy(IVirtualComponent var1);

    protected void modifyStrategy(SaveStrategy saveStrat) {
    }

    protected void importModuleFile(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.worked(1);
            J2EEComponentSaveStrategyImpl aStrategy = (J2EEComponentSaveStrategyImpl)this.createSaveStrategy(this.virtualComponent);
            aStrategy.setProgressMonitor(monitor);
            aStrategy.setOverwriteHandler((IOverwriteHandler)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER"));
            aStrategy.setDataModel(this.model);
            this.modifyStrategy((SaveStrategy)aStrategy);
            this.moduleFile.save((SaveStrategy)aStrategy);
        }
        catch (OverwriteHandlerException overwriteHandlerException) {
            throw new InterruptedException();
        }
        catch (Exception ex) {
            throw new WFTWrappedException((Throwable)ex, EJBArchiveOpsResourceHandler.getString("ERROR_IMPORTING_MODULE_FILE"));
        }
    }

    protected static void addToClasspath(IDataModel importModel, List extraEntries) throws JavaModelException {
        if (extraEntries.size() > 0) {
            IJavaProject javaProject = JavaCore.create((IProject)((IVirtualComponent)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.COMPONENT")).getProject());
            IVirtualComponent cfr_ignored_0 = (IVirtualComponent)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.COMPONENT");
            IClasspathEntry[] javaClasspath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> nonDuplicateList = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < extraEntries.size()) {
                IClasspathEntry extraEntry = (IClasspathEntry)extraEntries.get(i);
                boolean include = true;
                int j = 0;
                while (include && j < javaClasspath.length) {
                    if (extraEntry.equals(javaClasspath[j])) {
                        include = false;
                    }
                    ++j;
                }
                if (include) {
                    nonDuplicateList.add(extraEntry);
                }
                ++i;
            }
            if (nonDuplicateList.size() > 0) {
                IClasspathEntry[] newJavaClasspath = new IClasspathEntry[javaClasspath.length + nonDuplicateList.size()];
                System.arraycopy(javaClasspath, 0, newJavaClasspath, 0, javaClasspath.length);
                int j = 0;
                while (j < nonDuplicateList.size()) {
                    newJavaClasspath[javaClasspath.length + j] = (IClasspathEntry)nonDuplicateList.get(j);
                    ++j;
                }
                javaProject.setRawClasspath(newJavaClasspath, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected void fixModuleReference(IDataModel importModel, String[] manifestEntries) {
        IVirtualComponent comp = (IVirtualComponent)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.COMPONENT");
        if (comp.getComponentTypeId().equals("jst.ejb") && manifestEntries.length > 0) {
            int j = 0;
            while (j < manifestEntries.length) {
                IVirtualComponent refcomp;
                String name = manifestEntries[j];
                IProject project = ProjectUtilities.getProject((String)(name = name.substring(0, name.length() - 4)));
                if (project != null && project.isAccessible() && project.exists() && (refcomp = ComponentCore.createComponent((IProject)project, (String)name)).exists()) {
                    ArrayList<ComponentHandle> list = new ArrayList<ComponentHandle>();
                    list.add(refcomp.getComponentHandle());
                    CreateReferenceComponentsOp op = ComponentUtilities.createReferenceComponentOperation((ComponentHandle)comp.getComponentHandle(), list);
                    try {
                        op.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
                ++j;
            }
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

