/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.AddSecurityRoleOperation;
import org.eclipse.jst.j2ee.internal.common.operations.J2EEModelModifierOperationDataModel;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddSecurityRoleOperationDataModel
extends J2EEModelModifierOperationDataModel {
    private EObject ddRoot;
    public static final String ROLE_NAME = "AddSecurityRoleOperationDataModel.ROLE_NAME";
    public static final String ROLE_DESCRIPTION = "AddSecurityRoleOperationDataModel.ROLE_DESCRIPTION";

    public WTPOperation getDefaultOperation() {
        return new AddSecurityRoleOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(ROLE_NAME);
        this.addValidBaseProperty(ROLE_DESCRIPTION);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(ROLE_NAME)) {
            return this.validateRoleName(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateRoleName(String roleName) {
        boolean exists;
        if (roleName.length() == 0) {
            String msg = J2EECommonMessages.getResourceString("ERR_SECURITY_ROLE_EMPTY");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (this.ddRoot == null) {
            this.ddRoot = this.getDeploymentDescriptorRoot();
        }
        if (exists = this.roleExists(roleName)) {
            String msg = J2EECommonMessages.getResourceString("ERR_SECURITY_ROLE_EXIST", new String[]{roleName});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private boolean roleExists(String roleName) {
        switch (this.getDeploymentDescriptorType()) {
            case 2: {
                return this.roleExists(roleName, (Application)this.ddRoot);
            }
            case 3: {
                return this.roleExists(roleName, (EJBJar)this.ddRoot);
            }
            case 4: {
                return this.roleExists(roleName, (WebApp)this.ddRoot);
            }
        }
        return false;
    }

    private boolean roleExists(String roleName, EJBJar jar) {
        AssemblyDescriptor descriptor = jar.getAssemblyDescriptor();
        return descriptor != null && descriptor.getSecurityRoleNamed(roleName) != null;
    }

    private boolean roleExists(String roleName, Application application) {
        return application.getSecurityRoleNamed(roleName) != null;
    }

    private boolean roleExists(String roleName, WebApp webApp) {
        return webApp.getSecurityRoleNamed(roleName) != null;
    }
}

